/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.util.Objects;
import java.util.function.Supplier;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.gax.grpc.GrpcCallContext;
import net.snowflake.client.jdbc.internal.google.api.services.storage.model.StorageObject;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferHandle;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BufferedWritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ByteStringStrategy;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Conversions;
import net.snowflake.client.jdbc.internal.google.cloud.storage.GrpcStorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.Hasher;
import net.snowflake.client.jdbc.internal.google.cloud.storage.HttpClientContext;
import net.snowflake.client.jdbc.internal.google.cloud.storage.JsonResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.LazyWriteChannel;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableMedia;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ResumableWrite;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageImpl;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageInternal;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnifiedOpts;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.cloud.storage.spi.v1.StorageRpc;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableMap;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectRequest;
import net.snowflake.client.jdbc.internal.google.storage.v2.WriteObjectResponse;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
@Immutable
public final class DefaultBlobWriteSessionConfig
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.HttpCompatible,
BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = -6873740918589930633L;
    private final int chunkSize;

    @InternalApi
    DefaultBlobWriteSessionConfig(int chunkSize) {
        this.chunkSize = chunkSize;
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    @BetaApi
    public DefaultBlobWriteSessionConfig withChunkSize(int chunkSize) {
        Preconditions.checkArgument(chunkSize >= 262144, "chunkSize must be >= %d", 262144);
        return new DefaultBlobWriteSessionConfig(chunkSize);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultBlobWriteSessionConfig)) {
            return false;
        }
        DefaultBlobWriteSessionConfig that = (DefaultBlobWriteSessionConfig)o;
        return this.chunkSize == that.chunkSize;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.chunkSize);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) {
        return new Factory(this.chunkSize);
    }

    @InternalApi
    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private static final Conversions.Decoder<WriteObjectResponse, BlobInfo> WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER = Conversions.grpc().blobInfo().compose(WriteObjectResponse::getResource);
        private final int chunkSize;

        private Factory(int chunkSize) {
            this.chunkSize = chunkSize;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal s2, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            if (s2 instanceof GrpcStorageImpl) {
                return new DecoratedWritableByteChannelSession(new LazySession(new LazyWriteChannel(() -> {
                    GrpcStorageImpl grpc = (GrpcStorageImpl)s2;
                    GrpcCallContext grpcCallContext = opts.grpcMetadataMapper().apply(GrpcCallContext.createDefault());
                    WriteObjectRequest req = grpc.getWriteObjectRequest(info, opts);
                    ApiFuture<ResumableWrite> startResumableWrite = grpc.startResumableWrite(grpcCallContext, req, opts);
                    return ResumableMedia.gapic().write().byteChannel(grpc.storageClient.writeObjectCallable().withDefaultCallContext(grpcCallContext)).setHasher(Hasher.noop()).setByteStringStrategy(ByteStringStrategy.copy()).resumable().withRetryConfig(grpc.getOptions(), grpc.retryAlgorithmManager.idempotent()).buffered(BufferHandle.allocate(this.chunkSize)).setStartAsync(startResumableWrite).build();
                })), WRITE_OBJECT_RESPONSE_BLOB_INFO_DECODER);
            }
            if (s2 instanceof StorageImpl) {
                StorageImpl json = (StorageImpl)s2;
                return new DecoratedWritableByteChannelSession(new LazySession(new LazyWriteChannel(() -> {
                    ImmutableMap<StorageRpc.Option, ?> optionsMap = opts.getRpcOptions();
                    BlobInfo.Builder builder = info.toBuilder().setMd5(null).setCrc32c(null);
                    BlobInfo updated = opts.blobInfoMapper().apply(builder).build();
                    StorageObject encode = (StorageObject)Conversions.json().blobInfo().encode(updated);
                    Supplier<String> uploadIdSupplier = ResumableMedia.startUploadForBlobInfo(json.getOptions(), updated, optionsMap, json.retryAlgorithmManager.getForResumableUploadSessionCreate(optionsMap));
                    ApiFuture<JsonResumableWrite> startAsync = ApiFutures.immediateFuture(JsonResumableWrite.of(encode, optionsMap, uploadIdSupplier.get(), 0L));
                    return ResumableMedia.http().write().byteChannel(HttpClientContext.from(json.storageRpc)).resumable().buffered(BufferHandle.allocate(this.chunkSize)).setStartAsync(startAsync).build();
                })), Conversions.json().blobInfo());
            }
            throw new IllegalStateException("Unknown Storage implementation: " + s2.getClass().getName());
        }
    }

    static final class LazySession<R>
    implements WritableByteChannelSession<BufferedWritableByteChannelSession.BufferedWritableByteChannel, R> {
        private final LazyWriteChannel<R> lazy;

        LazySession(LazyWriteChannel<R> lazy) {
            this.lazy = lazy;
        }

        @Override
        public ApiFuture<BufferedWritableByteChannelSession.BufferedWritableByteChannel> openAsync() {
            return ApiFutures.transform(this.lazy.getSession().openAsync(), delegate -> new BufferedWritableByteChannelSession.BufferedWritableByteChannel(){
                final /* synthetic */ BufferedWritableByteChannelSession.BufferedWritableByteChannel val$delegate;
                {
                    this.val$delegate = bufferedWritableByteChannel;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    try {
                        return this.val$delegate.write(src);
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw StorageException.coalesce(e);
                    }
                }

                @Override
                public void flush() throws IOException {
                    try {
                        this.val$delegate.flush();
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw StorageException.coalesce(e);
                    }
                }

                @Override
                public boolean isOpen() {
                    try {
                        return this.val$delegate.isOpen();
                    }
                    catch (Exception e) {
                        throw StorageException.coalesce(e);
                    }
                }

                @Override
                public void close() throws IOException {
                    try {
                        this.val$delegate.close();
                    }
                    catch (IOException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw StorageException.coalesce(e);
                    }
                }
            }, MoreExecutors.directExecutor());
        }

        @Override
        public ApiFuture<R> getResult() {
            return this.lazy.getSession().getResult();
        }
    }

    static final class DecoratedWritableByteChannelSession<WBC extends WritableByteChannel, T>
    implements WritableByteChannelSession<WBC, BlobInfo> {
        private final WritableByteChannelSession<WBC, T> delegate;
        private final Conversions.Decoder<T, BlobInfo> decoder;

        DecoratedWritableByteChannelSession(WritableByteChannelSession<WBC, T> delegate, Conversions.Decoder<T, BlobInfo> decoder) {
            this.delegate = delegate;
            this.decoder = decoder;
        }

        @Override
        public ApiFuture<WBC> openAsync() {
            return ApiFutures.catchingAsync(this.delegate.openAsync(), Throwable.class, throwable -> ApiFutures.immediateFailedFuture(StorageException.coalesce(throwable)), MoreExecutors.directExecutor());
        }

        @Override
        public ApiFuture<BlobInfo> getResult() {
            ApiFuture<BlobInfo> decodeResult = ApiFutures.transform(this.delegate.getResult(), this.decoder::decode, MoreExecutors.directExecutor());
            return ApiFutures.catchingAsync(decodeResult, Throwable.class, throwable -> ApiFutures.immediateFailedFuture(StorageException.coalesce(throwable)), MoreExecutors.directExecutor());
        }
    }
}

