/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.cloud.storage;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Clock;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Collector;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFuture;
import net.snowflake.client.jdbc.internal.google.api.core.ApiFutures;
import net.snowflake.client.jdbc.internal.google.api.core.BetaApi;
import net.snowflake.client.jdbc.internal.google.api.core.InternalApi;
import net.snowflake.client.jdbc.internal.google.api.core.SettableApiFuture;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobInfo;
import net.snowflake.client.jdbc.internal.google.cloud.storage.BlobWriteSessionConfig;
import net.snowflake.client.jdbc.internal.google.cloud.storage.RecoveryFile;
import net.snowflake.client.jdbc.internal.google.cloud.storage.RecoveryFileManager;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageException;
import net.snowflake.client.jdbc.internal.google.cloud.storage.StorageInternal;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ThroughputMovingWindow;
import net.snowflake.client.jdbc.internal.google.cloud.storage.ThroughputSink;
import net.snowflake.client.jdbc.internal.google.cloud.storage.TransportCompatibility;
import net.snowflake.client.jdbc.internal.google.cloud.storage.UnifiedOpts;
import net.snowflake.client.jdbc.internal.google.cloud.storage.WritableByteChannelSession;
import net.snowflake.client.jdbc.internal.google.common.annotations.VisibleForTesting;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableList;
import net.snowflake.client.jdbc.internal.google.common.util.concurrent.MoreExecutors;
import net.snowflake.client.jdbc.internal.javax.annotation.concurrent.Immutable;
import net.snowflake.client.jdbc.internal.org.checkerframework.checker.nullness.qual.MonotonicNonNull;

@BetaApi
@TransportCompatibility(value={TransportCompatibility.Transport.GRPC, TransportCompatibility.Transport.HTTP})
@Immutable
public final class BufferToDiskThenUpload
extends BlobWriteSessionConfig
implements BlobWriteSessionConfig.HttpCompatible,
BlobWriteSessionConfig.GrpcCompatible {
    private static final long serialVersionUID = 9059242302276891867L;
    private transient @MonotonicNonNull ImmutableList<Path> paths;
    private final boolean includeLoggingSink;
    private volatile @MonotonicNonNull ArrayList<String> absolutePaths;

    @InternalApi
    BufferToDiskThenUpload(ImmutableList<Path> paths, boolean includeLoggingSink) throws IOException {
        this.paths = paths;
        this.includeLoggingSink = includeLoggingSink;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BufferToDiskThenUpload)) {
            return false;
        }
        BufferToDiskThenUpload that = (BufferToDiskThenUpload)o;
        return this.includeLoggingSink == that.includeLoggingSink && Objects.equals(this.paths, that.paths) && Objects.equals(this.absolutePaths, that.absolutePaths);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.paths, this.includeLoggingSink, this.absolutePaths);
    }

    @InternalApi
    @VisibleForTesting
    BufferToDiskThenUpload withIncludeLoggingSink() throws IOException {
        return new BufferToDiskThenUpload(this.paths, true);
    }

    @Override
    @InternalApi
    BlobWriteSessionConfig.WriterFactory createFactory(Clock clock) throws IOException {
        Duration window = Duration.ofMinutes(10L);
        RecoveryFileManager recoveryFileManager = RecoveryFileManager.of(this.paths, this.getRecoverVolumeSinkFactory(clock, window));
        ThroughputSink gcs = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
        gcs = this.includeLoggingSink ? ThroughputSink.tee(ThroughputSink.logged("gcs", clock), gcs) : gcs;
        return new Factory(recoveryFileManager, clock, gcs);
    }

    private RecoveryFileManager.RecoveryVolumeSinkFactory getRecoverVolumeSinkFactory(Clock clock, Duration window) {
        return path -> {
            ThroughputSink windowed = ThroughputSink.windowed(ThroughputMovingWindow.of(window), clock);
            if (this.includeLoggingSink) {
                return ThroughputSink.tee(ThroughputSink.logged(path.toAbsolutePath().toString(), clock), windowed);
            }
            return windowed;
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.absolutePaths == null) {
            BufferToDiskThenUpload bufferToDiskThenUpload = this;
            synchronized (bufferToDiskThenUpload) {
                if (this.absolutePaths == null) {
                    this.absolutePaths = this.paths.stream().map(Path::toAbsolutePath).map(Path::toString).collect(Collector.of(ArrayList::new, ArrayList::add, (left, right) -> {
                        left.addAll(right);
                        return left;
                    }, new Collector.Characteristics[0]));
                }
            }
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.paths = this.absolutePaths.stream().map(x$0 -> Paths.get(x$0, new String[0])).collect(ImmutableList.toImmutableList());
    }

    private static final class Factory
    implements BlobWriteSessionConfig.WriterFactory {
        private final RecoveryFileManager recoveryFileManager;
        private final Clock clock;
        private final ThroughputSink gcs;

        private Factory(RecoveryFileManager recoveryFileManager, Clock clock, ThroughputSink gcs) {
            this.recoveryFileManager = recoveryFileManager;
            this.clock = clock;
            this.gcs = gcs;
        }

        @Override
        @InternalApi
        public WritableByteChannelSession<?, BlobInfo> writeSession(StorageInternal storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts) {
            return new WriteToFileThenUpload(storage, info, opts, this.recoveryFileManager.newRecoveryFile(info));
        }

        private final class WriteToFileThenUpload
        implements WritableByteChannelSession<WritableByteChannel, BlobInfo> {
            private final StorageInternal storage;
            private final BlobInfo info;
            private final UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts;
            private final RecoveryFile rf;
            private final SettableApiFuture<BlobInfo> result;

            private WriteToFileThenUpload(StorageInternal storage, BlobInfo info, UnifiedOpts.Opts<UnifiedOpts.ObjectTargetOpt> opts, RecoveryFile rf) {
                this.info = info;
                this.opts = opts;
                this.rf = rf;
                this.storage = storage;
                this.result = SettableApiFuture.create();
            }

            @Override
            public ApiFuture<WritableByteChannel> openAsync() {
                try {
                    ApiFuture<WritableByteChannel> f = ApiFutures.immediateFuture(this.rf.writer());
                    return ApiFutures.transform(f, x$0 -> new Flusher((WritableByteChannel)x$0), MoreExecutors.directExecutor());
                }
                catch (IOException e) {
                    throw StorageException.coalesce(e);
                }
            }

            @Override
            public ApiFuture<BlobInfo> getResult() {
                return this.result;
            }

            private final class Flusher
            implements WritableByteChannel {
                private final WritableByteChannel delegate;

                private Flusher(WritableByteChannel delegate) {
                    this.delegate = delegate;
                }

                @Override
                public int write(ByteBuffer src) throws IOException {
                    return this.delegate.write(src);
                }

                @Override
                public boolean isOpen() {
                    return this.delegate.isOpen();
                }

                @Override
                public void close() throws IOException {
                    this.delegate.close();
                    try (RecoveryFile rf = WriteToFileThenUpload.this.rf;){
                        Path path = rf.getPath();
                        long size = Files.size(path);
                        ThroughputSink.computeThroughput(Factory.this.clock, Factory.this.gcs, size, () -> {
                            BlobInfo blob = WriteToFileThenUpload.this.storage.internalCreateFrom(path, WriteToFileThenUpload.this.info, WriteToFileThenUpload.this.opts);
                            WriteToFileThenUpload.this.result.set(blob);
                        });
                    }
                    catch (IOException | StorageException e) {
                        WriteToFileThenUpload.this.result.setException(e);
                        throw e;
                    }
                }
            }
        }
    }
}

