/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api;

import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.ParseException;
import net.snowflake.client.jdbc.internal.com.nimbusds.oauth2.sdk.http.HTTPResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.api.FetchEntityStatementResponse;
import net.snowflake.client.jdbc.internal.com.nimbusds.openid.connect.sdk.federation.entities.EntityStatement;
import net.snowflake.client.jdbc.internal.net.jcip.annotations.Immutable;

@Immutable
public class FetchEntityStatementSuccessResponse
extends FetchEntityStatementResponse {
    private final EntityStatement entityStatement;

    public FetchEntityStatementSuccessResponse(EntityStatement entityStatement) {
        if (entityStatement == null) {
            throw new IllegalArgumentException("The federation entity statement must not be null");
        }
        this.entityStatement = entityStatement;
    }

    public EntityStatement getEntityStatement() {
        return this.entityStatement;
    }

    @Override
    public boolean indicatesSuccess() {
        return true;
    }

    @Override
    public HTTPResponse toHTTPResponse() {
        HTTPResponse httpResponse = new HTTPResponse(200);
        httpResponse.setEntityContentType(EntityStatement.CONTENT_TYPE);
        httpResponse.setContent(this.getEntityStatement().getSignedStatement().serialize());
        return httpResponse;
    }

    public static FetchEntityStatementSuccessResponse parse(HTTPResponse httpResponse) throws ParseException {
        httpResponse.ensureStatusCode(200);
        httpResponse.ensureEntityContentType(EntityStatement.CONTENT_TYPE);
        return new FetchEntityStatementSuccessResponse(EntityStatement.parse(httpResponse.getBody()));
    }
}

