/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.regions;

import net.snowflake.client.jdbc.internal.amazonaws.regions.Region;
import net.snowflake.client.jdbc.internal.amazonaws.regions.RegionMetadataProvider;
import net.snowflake.client.jdbc.internal.amazonaws.util.SdkUri;

public abstract class AbstractRegionMetadataProvider
implements RegionMetadataProvider {
    @Override
    public Region getRegionByEndpoint(String endpoint) {
        String host = AbstractRegionMetadataProvider.getHost(endpoint);
        for (Region region : this.getRegions()) {
            for (String serviceEndpoint : region.getAvailableEndpoints()) {
                if (!host.equals(AbstractRegionMetadataProvider.getHost(serviceEndpoint))) continue;
                return region;
            }
        }
        throw new IllegalArgumentException("No region found with any service for endpoint " + endpoint);
    }

    protected static String getHost(String endpoint) {
        try {
            String host = SdkUri.getInstance().create(endpoint).getHost();
            if (host == null) {
                host = SdkUri.getInstance().create("http://" + endpoint).getHost();
            }
            if (host == null) {
                return "";
            }
            return host;
        }
        catch (IllegalArgumentException e) {
            return "";
        }
    }
}

