/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.auth;

import java.util.Date;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkInternalApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.auth.SessionCredentialsHolder;
import net.snowflake.client.jdbc.internal.amazonaws.internal.SdkPredicate;

@SdkInternalApi
@ThreadSafe
class ShouldDoBlockingSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final int EXPIRY_TIME_MILLIS = 60000;

    ShouldDoBlockingSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        return sessionCredentialsHolder == null || ShouldDoBlockingSessionRefresh.expiring(sessionCredentialsHolder.getSessionCredentialsExpiration());
    }

    private static boolean expiring(Date expiry) {
        long timeRemaining = expiry.getTime() - System.currentTimeMillis();
        return timeRemaining < 60000L;
    }
}

