/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.auth.wif;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.snowflake.client.core.SFException;
import net.snowflake.client.core.SFLoginInput;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestation;
import net.snowflake.client.core.auth.wif.WorkloadIdentityAttestationCreator;
import net.snowflake.client.core.auth.wif.WorkloadIdentityProviderType;
import net.snowflake.client.core.auth.wif.WorkloadIdentityUtil;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpGet;
import net.snowflake.client.jdbc.internal.apache.http.client.methods.HttpPost;
import net.snowflake.client.jdbc.internal.apache.http.entity.StringEntity;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.core.JsonProcessingException;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.JsonNode;
import net.snowflake.client.jdbc.internal.fasterxml.jackson.databind.ObjectMapper;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

@SnowflakeJdbcInternalApi
public class GcpIdentityAttestationCreator
implements WorkloadIdentityAttestationCreator {
    private static final String METADATA_FLAVOR_HEADER_NAME = "Metadata-Flavor";
    private static final String METADATA_FLAVOR = "Google";
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private static final String DEFAULT_GCP_IAM_CREDENTIALS_URL = "https://iamcredentials.googleapis.com";
    private final String gcpMetadataServiceBaseUrl;
    private final String gcpIamCredentialsBaseUrl;
    private static final SFLogger logger = SFLoggerFactory.getLogger(GcpIdentityAttestationCreator.class);
    private final SFLoginInput loginInput;

    public GcpIdentityAttestationCreator(SFLoginInput loginInput) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = "http://169.254.169.254";
        this.gcpIamCredentialsBaseUrl = DEFAULT_GCP_IAM_CREDENTIALS_URL;
    }

    GcpIdentityAttestationCreator(SFLoginInput loginInput, String gcpBaseUrl, String gcpIamUrl) {
        this.loginInput = loginInput;
        this.gcpMetadataServiceBaseUrl = gcpBaseUrl;
        this.gcpIamCredentialsBaseUrl = gcpIamUrl;
    }

    @Override
    public WorkloadIdentityAttestation createAttestation() throws SFException {
        String token;
        if (this.loginInput.getWorkloadIdentityImpersonationPath().isEmpty()) {
            logger.debug("Creating GCP identity attestation...", new Object[0]);
            token = this.getGcpIdentityTokenFromMetadataService();
        } else {
            logger.debug("Creating GCP identity attestation with impersonation...", new Object[0]);
            token = this.getGcpIdentityTokenViaImpersonation();
        }
        if (token == null) {
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "No GCP token was found.");
        }
        WorkloadIdentityUtil.SubjectAndIssuer claims = WorkloadIdentityUtil.extractClaimsWithoutVerifyingSignature(token);
        return new WorkloadIdentityAttestation(WorkloadIdentityProviderType.GCP, token, Collections.singletonMap("sub", claims.getSubject()));
    }

    private String getGcpIdentityTokenFromMetadataService() throws SFException {
        String uri = this.gcpMetadataServiceBaseUrl + "/computeMetadata/v1/instance/service-accounts/default/identity?audience=" + "snowflakecomputing.com";
        return this.executeGcpTokenRequest(uri);
    }

    private String fetchTokenFromMetadataService() throws SFException {
        String uri = this.gcpMetadataServiceBaseUrl + "/computeMetadata/v1/instance/service-accounts/default/token";
        String response = this.executeGcpTokenRequest(uri);
        try {
            JsonNode responseBody = objectMapper.readTree(response);
            return responseBody.get("access_token").asText();
        }
        catch (JsonProcessingException e) {
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "GCP metadata server request for token was not successful: " + e.getMessage());
        }
    }

    private String executeGcpTokenRequest(String uri) throws SFException {
        HttpGet tokenRequest = new HttpGet(uri);
        tokenRequest.setHeader(METADATA_FLAVOR_HEADER_NAME, METADATA_FLAVOR);
        try {
            return WorkloadIdentityUtil.performIdentityRequest(tokenRequest, this.loginInput);
        }
        catch (Exception e) {
            logger.error("GCP metadata server request was not successful", e);
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "GCP metadata server request was not successful: " + e.getMessage());
        }
    }

    private String getGcpIdentityTokenViaImpersonation() throws SFException {
        String accessToken = this.fetchTokenFromMetadataService();
        List fullServiceAccountPaths = this.loginInput.getWorkloadIdentityImpersonationPath().stream().map(sa -> "projects/-/serviceAccounts/" + sa).collect(Collectors.toList());
        String targetServiceAccount = (String)fullServiceAccountPaths.get(fullServiceAccountPaths.size() - 1);
        List delegates = fullServiceAccountPaths.subList(0, fullServiceAccountPaths.size() - 1);
        String url = String.format(this.gcpIamCredentialsBaseUrl + "/v1/%s:generateIdToken", targetServiceAccount);
        HttpPost request = new HttpPost(url);
        request.setHeader("Authorization", "Bearer " + accessToken);
        request.setHeader("Content-Type", "application/json");
        HashMap<String, Object> requestBody = new HashMap<String, Object>();
        requestBody.put("delegates", delegates);
        requestBody.put("audience", "snowflakecomputing.com");
        try {
            String json = objectMapper.writeValueAsString(requestBody);
            request.setEntity(new StringEntity(json, StandardCharsets.UTF_8));
            String response = WorkloadIdentityUtil.performIdentityRequest(request, this.loginInput);
            JsonNode responseBody = objectMapper.readTree(response);
            return responseBody.get("token").asText();
        }
        catch (Exception e) {
            logger.error("Error fetching GCP impersonated identity token", e);
            throw new SFException(ErrorCode.WORKLOAD_IDENTITY_FLOW_ERROR, "Error fetching GCP impersonated identity token: " + e.getMessage());
        }
    }
}

