/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core.arrow;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Duration;
import java.util.Map;
import net.snowflake.client.core.DataConversionContext;
import net.snowflake.client.core.SFBaseSession;
import net.snowflake.client.core.SnowflakeJdbcInternalApi;
import net.snowflake.client.core.arrow.ArrayConverter;
import net.snowflake.client.core.arrow.ArrowVectorConverter;
import net.snowflake.client.core.arrow.BigIntToFixedConverter;
import net.snowflake.client.core.arrow.BigIntToScaledFixedConverter;
import net.snowflake.client.core.arrow.BigIntToTimeConverter;
import net.snowflake.client.core.arrow.BigIntToTimestampLTZConverter;
import net.snowflake.client.core.arrow.BigIntToTimestampNTZConverter;
import net.snowflake.client.core.arrow.BitToBooleanConverter;
import net.snowflake.client.core.arrow.DateConverter;
import net.snowflake.client.core.arrow.DecfloatToDecimalConverter;
import net.snowflake.client.core.arrow.DecimalToScaledFixedConverter;
import net.snowflake.client.core.arrow.DoubleToRealConverter;
import net.snowflake.client.core.arrow.IntToFixedConverter;
import net.snowflake.client.core.arrow.IntToScaledFixedConverter;
import net.snowflake.client.core.arrow.IntToTimeConverter;
import net.snowflake.client.core.arrow.IntervalDayTimeToDurationConverter;
import net.snowflake.client.core.arrow.IntervalYearMonthToPeriodConverter;
import net.snowflake.client.core.arrow.MapConverter;
import net.snowflake.client.core.arrow.SmallIntToFixedConverter;
import net.snowflake.client.core.arrow.SmallIntToScaledFixedConverter;
import net.snowflake.client.core.arrow.StructConverter;
import net.snowflake.client.core.arrow.ThreeFieldStructToTimestampTZConverter;
import net.snowflake.client.core.arrow.TinyIntToFixedConverter;
import net.snowflake.client.core.arrow.TinyIntToScaledFixedConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampLTZConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampNTZConverter;
import net.snowflake.client.core.arrow.TwoFieldStructToTimestampTZConverter;
import net.snowflake.client.core.arrow.VarBinaryToBinaryConverter;
import net.snowflake.client.core.arrow.VarCharConverter;
import net.snowflake.client.core.arrow.VectorTypeConverter;
import net.snowflake.client.jdbc.ErrorCode;
import net.snowflake.client.jdbc.SnowflakeSQLException;
import net.snowflake.client.jdbc.SnowflakeSQLLoggedException;
import net.snowflake.client.jdbc.SnowflakeType;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.FieldVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.ValueVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.FixedSizeListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.ListVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.MapVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.complex.StructVector;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.Types;
import net.snowflake.client.jdbc.internal.apache.arrow.vector.types.pojo.Field;

@SnowflakeJdbcInternalApi
public final class ArrowVectorConverterUtil {
    private ArrowVectorConverterUtil() {
    }

    public static SnowflakeType getSnowflakeTypeFromFieldMetadata(Field field) {
        Map<String, String> customMeta = field.getMetadata();
        if (customMeta != null && customMeta.containsKey("logicalType")) {
            return SnowflakeType.valueOf(customMeta.get("logicalType"));
        }
        return null;
    }

    public static ArrowVectorConverter initConverter(ValueVector vector, DataConversionContext context, SFBaseSession session, int idx) throws SnowflakeSQLException {
        Types.MinorType type = Types.getMinorTypeForArrowType(vector.getField().getType());
        SnowflakeType st = ArrowVectorConverterUtil.getSnowflakeTypeFromFieldMetadata(vector.getField());
        if (type == Types.MinorType.DECIMAL) {
            return new DecimalToScaledFixedConverter(vector, idx, context);
        }
        if (st != null) {
            switch (st) {
                case ANY: 
                case CHAR: 
                case TEXT: 
                case VARIANT: {
                    return new VarCharConverter(vector, idx, context);
                }
                case MAP: {
                    if (vector instanceof MapVector) {
                        return new MapConverter((MapVector)vector, idx, context);
                    }
                    return new VarCharConverter(vector, idx, context);
                }
                case VECTOR: {
                    return new VectorTypeConverter((FixedSizeListVector)vector, idx, context);
                }
                case ARRAY: {
                    if (vector instanceof ListVector) {
                        return new ArrayConverter((ListVector)vector, idx, context);
                    }
                    return new VarCharConverter(vector, idx, context);
                }
                case OBJECT: {
                    if (vector instanceof StructVector) {
                        return new StructConverter((StructVector)vector, idx, context);
                    }
                    return new VarCharConverter(vector, idx, context);
                }
                case BINARY: {
                    return new VarBinaryToBinaryConverter(vector, idx, context);
                }
                case BOOLEAN: {
                    return new BitToBooleanConverter(vector, idx, context);
                }
                case DATE: {
                    boolean getFormatDateWithTimeZone = false;
                    if (context.getSession() != null) {
                        getFormatDateWithTimeZone = context.getSession().getFormatDateWithTimezone();
                    }
                    return new DateConverter(vector, idx, context, getFormatDateWithTimeZone);
                }
                case FIXED: {
                    String scaleStr = vector.getField().getMetadata().get("scale");
                    int sfScale = Integer.parseInt(scaleStr);
                    switch (type) {
                        case TINYINT: {
                            if (sfScale == 0) {
                                return new TinyIntToFixedConverter(vector, idx, context);
                            }
                            return new TinyIntToScaledFixedConverter(vector, idx, context, sfScale);
                        }
                        case SMALLINT: {
                            if (sfScale == 0) {
                                return new SmallIntToFixedConverter(vector, idx, context);
                            }
                            return new SmallIntToScaledFixedConverter(vector, idx, context, sfScale);
                        }
                        case INT: {
                            if (sfScale == 0) {
                                return new IntToFixedConverter(vector, idx, context);
                            }
                            return new IntToScaledFixedConverter(vector, idx, context, sfScale);
                        }
                        case BIGINT: {
                            if (sfScale == 0) {
                                return new BigIntToFixedConverter(vector, idx, context);
                            }
                            return new BigIntToScaledFixedConverter(vector, idx, context, sfScale);
                        }
                    }
                    break;
                }
                case DECFLOAT: {
                    return new DecfloatToDecimalConverter(vector, idx, context);
                }
                case INTERVAL_YEAR_MONTH: {
                    return new IntervalYearMonthToPeriodConverter(vector, idx, context);
                }
                case INTERVAL_DAY_TIME: {
                    return new IntervalDayTimeToDurationConverter(vector, idx, context);
                }
                case REAL: {
                    return new DoubleToRealConverter(vector, idx, context);
                }
                case TIME: {
                    switch (type) {
                        case INT: {
                            return new IntToTimeConverter(vector, idx, context);
                        }
                        case BIGINT: {
                            return new BigIntToTimeConverter(vector, idx, context);
                        }
                    }
                    throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected Arrow Field for ", st.name());
                }
                case TIMESTAMP_LTZ: {
                    if (vector.getField().getChildren().isEmpty()) {
                        return new BigIntToTimestampLTZConverter(vector, idx, context);
                    }
                    if (vector.getField().getChildren().size() == 2) {
                        return new TwoFieldStructToTimestampLTZConverter(vector, idx, context);
                    }
                    throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected Arrow Field for ", st.name());
                }
                case TIMESTAMP_NTZ: {
                    if (vector.getField().getChildren().isEmpty()) {
                        return new BigIntToTimestampNTZConverter(vector, idx, context);
                    }
                    if (vector.getField().getChildren().size() == 2) {
                        return new TwoFieldStructToTimestampNTZConverter(vector, idx, context);
                    }
                    throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected Arrow Field for ", st.name());
                }
                case TIMESTAMP_TZ: {
                    if (vector.getField().getChildren().size() == 2) {
                        return new TwoFieldStructToTimestampTZConverter(vector, idx, context);
                    }
                    if (vector.getField().getChildren().size() == 3) {
                        return new ThreeFieldStructToTimestampTZConverter(vector, idx, context);
                    }
                    throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected SnowflakeType ", st.name());
                }
                default: {
                    throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected Arrow Field for ", st.name());
                }
            }
        }
        throw new SnowflakeSQLLoggedException(session, (int)ErrorCode.INTERNAL_ERROR.getMessageCode(), "XX000", "Unexpected Arrow Field for ", type.toString());
    }

    public static ArrowVectorConverter initConverter(FieldVector vector, DataConversionContext context, int columnIndex) throws SnowflakeSQLException {
        return ArrowVectorConverterUtil.initConverter(vector, context, context.getSession(), columnIndex);
    }

    public static Duration getDurationFromNanos(BigDecimal numNanos) {
        BigDecimal nanoInSecond = BigDecimal.valueOf(1000000000L);
        int sign = numNanos.signum();
        numNanos = numNanos.abs();
        Duration duration = Duration.ofSeconds(numNanos.divide(nanoInSecond, RoundingMode.FLOOR).longValueExact(), numNanos.remainder(nanoInSecond).longValueExact());
        if (sign >= 0) {
            return duration;
        }
        return duration.negated();
    }
}

