/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.core;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.snowflake.client.core.HexUtil;

interface SecureStorageManager {
    public static final int COLON_CHAR_LENGTH = 1;

    public SecureStorageStatus setCredential(String var1, String var2, String var3, String var4);

    public String getCredential(String var1, String var2, String var3);

    public SecureStorageStatus deleteCredential(String var1, String var2, String var3);

    public static String buildCredentialsKey(String host, String user, String type) {
        StringBuilder target = new StringBuilder(host.length() + user.length() + type.length() + 3);
        target.append(host.toUpperCase());
        target.append(":");
        target.append(user.toUpperCase());
        target.append(":");
        target.append(type.toUpperCase());
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(target.toString().getBytes());
            return HexUtil.byteToHexString(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum SecureStorageStatus {
        NOT_FOUND,
        FAILURE,
        SUCCESS,
        UNSUPPORTED;

    }
}

