/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.indices;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch.indices.IndexRoutingAllocationDisk;
import org.opensearch.client.opensearch.indices.IndexRoutingAllocationInclude;
import org.opensearch.client.opensearch.indices.IndexRoutingAllocationInitialRecovery;
import org.opensearch.client.opensearch.indices.IndexRoutingAllocationOptions;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class IndexRoutingAllocation
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, IndexRoutingAllocation> {
    @Nullable
    private final IndexRoutingAllocationDisk disk;
    @Nullable
    private final IndexRoutingAllocationOptions enable;
    @Nullable
    private final IndexRoutingAllocationInclude include;
    @Nullable
    private final IndexRoutingAllocationInitialRecovery initialRecovery;
    @Nullable
    private final Integer totalPrimaryShardsPerNode;
    @Nullable
    private final Integer totalShardsPerNode;
    public static final JsonpDeserializer<IndexRoutingAllocation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, IndexRoutingAllocation::setupIndexRoutingAllocationDeserializer);

    private IndexRoutingAllocation(Builder builder) {
        this.disk = builder.disk;
        this.enable = builder.enable;
        this.include = builder.include;
        this.initialRecovery = builder.initialRecovery;
        this.totalPrimaryShardsPerNode = builder.totalPrimaryShardsPerNode;
        this.totalShardsPerNode = builder.totalShardsPerNode;
    }

    public static IndexRoutingAllocation of(Function<Builder, ObjectBuilder<IndexRoutingAllocation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final IndexRoutingAllocationDisk disk() {
        return this.disk;
    }

    @Nullable
    public final IndexRoutingAllocationOptions enable() {
        return this.enable;
    }

    @Nullable
    public final IndexRoutingAllocationInclude include() {
        return this.include;
    }

    @Nullable
    public final IndexRoutingAllocationInitialRecovery initialRecovery() {
        return this.initialRecovery;
    }

    @Nullable
    public final Integer totalPrimaryShardsPerNode() {
        return this.totalPrimaryShardsPerNode;
    }

    @Nullable
    public final Integer totalShardsPerNode() {
        return this.totalShardsPerNode;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.disk != null) {
            generator.writeKey("disk");
            this.disk.serialize(generator, mapper);
        }
        if (this.enable != null) {
            generator.writeKey("enable");
            this.enable.serialize(generator, mapper);
        }
        if (this.include != null) {
            generator.writeKey("include");
            this.include.serialize(generator, mapper);
        }
        if (this.initialRecovery != null) {
            generator.writeKey("initial_recovery");
            this.initialRecovery.serialize(generator, mapper);
        }
        if (this.totalPrimaryShardsPerNode != null) {
            generator.writeKey("total_primary_shards_per_node");
            generator.write(this.totalPrimaryShardsPerNode.intValue());
        }
        if (this.totalShardsPerNode != null) {
            generator.writeKey("total_shards_per_node");
            generator.write(this.totalShardsPerNode.intValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupIndexRoutingAllocationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::disk, IndexRoutingAllocationDisk._DESERIALIZER, "disk");
        op.add(Builder::enable, IndexRoutingAllocationOptions._DESERIALIZER, "enable");
        op.add(Builder::include, IndexRoutingAllocationInclude._DESERIALIZER, "include");
        op.add(Builder::initialRecovery, IndexRoutingAllocationInitialRecovery._DESERIALIZER, "initial_recovery");
        op.add(Builder::totalPrimaryShardsPerNode, JsonpDeserializer.integerDeserializer(), "total_primary_shards_per_node");
        op.add(Builder::totalShardsPerNode, JsonpDeserializer.integerDeserializer(), "total_shards_per_node");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.disk);
        result = 31 * result + Objects.hashCode(this.enable);
        result = 31 * result + Objects.hashCode(this.include);
        result = 31 * result + Objects.hashCode(this.initialRecovery);
        result = 31 * result + Objects.hashCode(this.totalPrimaryShardsPerNode);
        result = 31 * result + Objects.hashCode(this.totalShardsPerNode);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexRoutingAllocation other = (IndexRoutingAllocation)o;
        return Objects.equals(this.disk, other.disk) && Objects.equals(this.enable, other.enable) && Objects.equals(this.include, other.include) && Objects.equals(this.initialRecovery, other.initialRecovery) && Objects.equals(this.totalPrimaryShardsPerNode, other.totalPrimaryShardsPerNode) && Objects.equals(this.totalShardsPerNode, other.totalShardsPerNode);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, IndexRoutingAllocation> {
        @Nullable
        private IndexRoutingAllocationDisk disk;
        @Nullable
        private IndexRoutingAllocationOptions enable;
        @Nullable
        private IndexRoutingAllocationInclude include;
        @Nullable
        private IndexRoutingAllocationInitialRecovery initialRecovery;
        @Nullable
        private Integer totalPrimaryShardsPerNode;
        @Nullable
        private Integer totalShardsPerNode;

        public Builder() {
        }

        private Builder(IndexRoutingAllocation o) {
            this.disk = o.disk;
            this.enable = o.enable;
            this.include = o.include;
            this.initialRecovery = o.initialRecovery;
            this.totalPrimaryShardsPerNode = o.totalPrimaryShardsPerNode;
            this.totalShardsPerNode = o.totalShardsPerNode;
        }

        private Builder(Builder o) {
            this.disk = o.disk;
            this.enable = o.enable;
            this.include = o.include;
            this.initialRecovery = o.initialRecovery;
            this.totalPrimaryShardsPerNode = o.totalPrimaryShardsPerNode;
            this.totalShardsPerNode = o.totalShardsPerNode;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder disk(@Nullable IndexRoutingAllocationDisk value) {
            this.disk = value;
            return this;
        }

        @Nonnull
        public final Builder disk(Function<IndexRoutingAllocationDisk.Builder, ObjectBuilder<IndexRoutingAllocationDisk>> fn) {
            return this.disk(fn.apply(new IndexRoutingAllocationDisk.Builder()).build());
        }

        @Nonnull
        public final Builder enable(@Nullable IndexRoutingAllocationOptions value) {
            this.enable = value;
            return this;
        }

        @Nonnull
        public final Builder include(@Nullable IndexRoutingAllocationInclude value) {
            this.include = value;
            return this;
        }

        @Nonnull
        public final Builder include(Function<IndexRoutingAllocationInclude.Builder, ObjectBuilder<IndexRoutingAllocationInclude>> fn) {
            return this.include(fn.apply(new IndexRoutingAllocationInclude.Builder()).build());
        }

        @Nonnull
        public final Builder initialRecovery(@Nullable IndexRoutingAllocationInitialRecovery value) {
            this.initialRecovery = value;
            return this;
        }

        @Nonnull
        public final Builder initialRecovery(Function<IndexRoutingAllocationInitialRecovery.Builder, ObjectBuilder<IndexRoutingAllocationInitialRecovery>> fn) {
            return this.initialRecovery(fn.apply(new IndexRoutingAllocationInitialRecovery.Builder()).build());
        }

        @Nonnull
        public final Builder totalPrimaryShardsPerNode(@Nullable Integer value) {
            this.totalPrimaryShardsPerNode = value;
            return this;
        }

        @Nonnull
        public final Builder totalShardsPerNode(@Nullable Integer value) {
            this.totalShardsPerNode = value;
            return this;
        }

        @Override
        @Nonnull
        public IndexRoutingAllocation build() {
            this._checkSingleUse();
            return new IndexRoutingAllocation(this);
        }
    }
}

