/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.webauthn4j.data.jws.JWAIdentifier;
import com.webauthn4j.data.jws.JWSHeader;
import com.webauthn4j.util.Base64Util;
import com.webauthn4j.util.CertificateUtil;
import java.io.IOException;
import java.security.cert.CertPath;
import java.security.cert.X509Certificate;
import java.util.ArrayList;

public class JWSHeaderDeserializer
extends StdDeserializer<JWSHeader> {
    public JWSHeaderDeserializer() {
        super(JWSHeader.class);
    }

    public JWSHeader deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode jsonNode = (JsonNode)p.getCodec().readTree(p);
        JWAIdentifier alg = (JWAIdentifier)((Object)p.getCodec().treeToValue((TreeNode)jsonNode.get("alg"), JWAIdentifier.class));
        JsonNode x5cNode = jsonNode.get("x5c");
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>();
        for (JsonNode node : x5cNode) {
            certificates.add(CertificateUtil.generateX509Certificate(Base64Util.decode(node.asText())));
        }
        CertPath x5c = CertificateUtil.generateCertPath(certificates);
        return new JWSHeader(alg, x5c);
    }
}

