/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Computes the gradient of an image using directional derivatives.


Computes the gradient of an image using directional derivatives. The
directional derivative at each pixel location is computed by
convolution with a first-order derivative operator.

The second template parameter defines the value type used in the
derivative operator (defaults to float). The third template parameter
defines the value type used for output image (defaults to float). The
output image is defined as a covariant vector image whose value type
is specified as this third template parameter.


See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 itk::simple::Gradient for the procedural interface

 itk::GradientImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkGradientImageFilter.h
*/
public class GradientImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected GradientImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.GradientImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(GradientImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(GradientImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::GradientImageFilter::~GradientImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_GradientImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::GradientImageFilter::GradientImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  GradientImageFilter() {
    this(SimpleITKJNI.new_GradientImageFilter(), true);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to compute the derivatives in physical
space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.GradientImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.GradientImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.GradientImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::GradientImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations. Use On to take the image spacing
information into account and to compute the derivatives in physical
space; use Off to ignore the image spacing and to compute the
derivatives in isotropic voxel space. Default is On.

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.GradientImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::SetUseImageDirection(bool UseImageDirection)

The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public  void setUseImageDirection(boolean UseImageDirection) {
    SimpleITKJNI.GradientImageFilter_setUseImageDirection(swigCPtr, this, UseImageDirection);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::UseImageDirectionOn()

Set the value of UseImageDirection to true or false respectfully.

*/
public  void useImageDirectionOn() {
    SimpleITKJNI.GradientImageFilter_useImageDirectionOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::GradientImageFilter::UseImageDirectionOff()
*/
public  void useImageDirectionOff() {
    SimpleITKJNI.GradientImageFilter_useImageDirectionOff(swigCPtr, this);
  }

  /**
bool itk::simple::GradientImageFilter::GetUseImageDirection() const

The UseImageDirection flag determines whether image derivatives are
computed with respect to the image grid or with respect to the
physical space. When this flag is ON the derivatives are computed with
respect to the coordinate system of physical space. The difference is
whether we take into account the image Direction or not. The flag ON
will take into account the image direction and will result in an extra
matrix multiplication compared to the amount of computation performed
when the flag is OFF. The default value of this flag is On.

*/
public  boolean getUseImageDirection() {
    return SimpleITKJNI.GradientImageFilter_getUseImageDirection(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.GradientImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::GradientImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.GradientImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::GradientImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.GradientImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
