// Generated by gmmproc 2.86.0 -- DO NOT MODIFY!
#ifndef _GTKMM_SIGNALLISTITEMFACTORY_H
#define _GTKMM_SIGNALLISTITEMFACTORY_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (C) 2020 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtkmm/listitem.h>
#include <gtkmm/listitemfactory.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
using GtkSignalListItemFactory = struct _GtkSignalListItemFactory;
using GtkSignalListItemFactoryClass = struct _GtkSignalListItemFactoryClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Gtk
{ class GTKMM_API SignalListItemFactory_Class; } // namespace Gtk
#endif //DOXYGEN_SHOULD_SKIP_THIS

namespace Gtk
{

/** A listitem factory providing signals.
 *
 * %Gtk::SignalListItemFactory is a Gtk::ListItemFactory that provides signals
 * with which user code can manage instances of ListItem or other list objects.
 *
 * Note the below signals, not suffixed `%_obj()` and taking ListItem arguments,
 * only work if the factory is indeed making ListItem instances. If not, e.g. if
 * it makes ListHeader objects as the ListView::property_header_factory(), these
 * signals receive null args and cannot be used. In such cases, use the versions
 * suffixed `%_obj()`, and cast the Glib::Object argument to the right subclass.
 *
 * Signals are emitted for every listitem in the same order:
 *
 *  1. signal_setup() is emitted to set up permanent things
 *  on the listitem. This usually means constructing the widgets used in the
 *  row and adding them to the listitem.
 *
 *  2. signal_bind() is emitted to bind the item passed via
 *  Gtk::ListItem::property_item() to the widgets that have been
 *  created in step 1 or to add item-specific widgets. Signals are
 *  connected to listen to changes - both to changes in the item to
 *  update the widgets or to changes in the widgets to update the
 *  item. After this signal has been called, the listitem may be shown
 *  in a list widget.
 *
 *  3. signal_unbind() is emitted to undo everything done in step 2.
 *  Usually this means disconnecting signal handlers. Once this signal
 *  has been called, the listitem will no longer be used in a list
 *  widget.
 *
 *  4. signal_bind() and signal_unbind() may be emitted multiple times
 *  again to bind the listitem for use with new items. By reusing
 *  listitems, potentially costly setup can be avoided. However, it
 *  means code needs to make sure to properly clean up the listitem in
 *  step 3 so that no information from the previous use leaks into the
 *  next use.
 *
 *  5. signal_teardown() is emitted to allow undoing the effects of
 *  signal_setup(). After this signal was emitted on a listitem, the
 *  listitem will be destroyed and not be used again.
 *
 * Note that during the signal emissions, changing properties on the
 * Gtk::ListItems passed will not trigger notify signals as the listitem's
 * notifications are frozen. See Glib::ObjectBase::freeze_notify() for details.
 *
 * For tracking changes in other properties in the Gtk::ListItem, the
 * Gtk::ListItem notify signal is recommended. The signal can be connected
 * in the signal_setup() signal and removed again during signal_teardown().
 *
 * @see Gtk::ListItemFactory
 * @ingroup ListView
 * @newin{3,98}
 */

class GTKMM_API SignalListItemFactory : public ListItemFactory
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  using CppObjectType = SignalListItemFactory;
  using CppClassType = SignalListItemFactory_Class;
  using BaseObjectType = GtkSignalListItemFactory;
  using BaseClassType = GtkSignalListItemFactoryClass;

  // noncopyable
  SignalListItemFactory(const SignalListItemFactory&) = delete;
  SignalListItemFactory& operator=(const SignalListItemFactory&) = delete;

private:  friend class SignalListItemFactory_Class;
  static CppClassType signallistitemfactory_class_;

protected:
  explicit SignalListItemFactory(const Glib::ConstructParams& construct_params);
  explicit SignalListItemFactory(GtkSignalListItemFactory* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  SignalListItemFactory(SignalListItemFactory&& src) noexcept;
  SignalListItemFactory& operator=(SignalListItemFactory&& src) noexcept;

  ~SignalListItemFactory() noexcept override;

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GtkSignalListItemFactory*       gobj()       { return reinterpret_cast<GtkSignalListItemFactory*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GtkSignalListItemFactory* gobj() const { return reinterpret_cast<GtkSignalListItemFactory*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GtkSignalListItemFactory* gobj_copy();

private:


protected:
  SignalListItemFactory();

public:
  
  static Glib::RefPtr<SignalListItemFactory> create();


  // no_default_handler because GtkSignalListItemFactoryClass is private.

  // Gtk now declares these signals as taking a GObject*. We can't make such a
  // change in gtkmm. It would break API, and perhaps ABI.
  // Fixed by gtk/src/gtk_signals.defs.patch
  // https://gitlab.gnome.org/GNOME/gtk/-/issues/5056
 

  /**
   * This signal is only usable if the factory is being used to make ListItems.
   * If not, e.g. because the factory is making ListHeader items via being used
   * as a ListView::property_header_factory(), this signal will receive a null
   * RefPtr and so not be usable. In such cases, use signal_setup_obj() instead.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%setup(const Glib::RefPtr<ListItem>& list_item)</tt>
   *
   * Flags: Run First
   *
   * Emitted when a newly created listitem needs to be prepared for use.
   * 
   * It is the first signal emitted for every listitem.
   * 
   * The handler for this signal must call Gtk::ListItem::set_child()
   * to populate the listitem with widgets.
   * 
   * The signal_teardown() signal is the opposite
   * of this signal and can be used to undo everything done in this signal.
   * 
   * @param list_item The `Glib::Object` to set up.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<ListItem>&)> signal_setup();

  
  /**
   * This signal is only usable if the factory is being used to make ListItems.
   * If not, e.g. because the factory is making ListHeader items via being used
   * as a ListView::property_header_factory(), this signal will receive a null
   * RefPtr and so not be usable. In such cases, use signal_bind_obj() instead.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%bind(const Glib::RefPtr<ListItem>& list_item)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object has been bound to an item.
   * 
   * The handler for this signal must set
   * to populate the listitem with widgets.
   * 
   * After this signal was emitted, the object might be shown in
   * a Gtk::ListView or other widget.
   * 
   * The signal_unbind() signal is the
   * opposite of this signal and can be used to undo everything done
   * in this signal.
   * 
   * @param list_item The `Glib::Object` to bind.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<ListItem>&)> signal_bind();

  
  /**
   * This signal is only usable if the factory is being used to make ListItems.
   * If not, e.g. because the factory is making ListHeader items via being used
   * as a ListView::property_header_factory(), this signal will receive a null
   * RefPtr and so not be usable. In such cases, use signal_unbind_obj() instead.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%unbind(const Glib::RefPtr<ListItem>& list_item)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object has been unbound from its item.
   * 
   * This happens for example when a listitem was removed from use
   * in a list widget and its Gtk::ListItem::property_item() is about
   * to be unset.
   * 
   * This signal is the opposite of the signal_bind()
   * signal and should be used to undo everything done in that signal.
   * 
   * @param list_item The `Glib::Object` to unbind.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<ListItem>&)> signal_unbind();

  
  /**
   * This signal is only usable if the factory is being used to make ListItems.
   * If not, e.g. because the factory is making ListHeader items via being used
   * as a ListView::property_header_factory(), this signal will receive a null
   * RefPtr and so not be usable. In such cases, use signal_teardown_obj() instead.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%teardown(const Glib::RefPtr<ListItem>& list_item)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object is about to be destroyed.
   * 
   * It is the last signal ever emitted for this @a list_item.
   * 
   * This signal is the opposite of the signal_setup()
   * signal and should be used to undo everything done in that signal.
   * 
   * @param list_item The `Glib::Object` to tear down.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<ListItem>&)> signal_teardown();


  /**
   * This is a more generic version of signal_setup(), usable if the factory is
   * being used to make something other than ListItems, for example ListHeader.
   * It receives a RefPtr to Glib::Object, which can be cast to the actual type.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%setup_obj(const Glib::RefPtr<Glib::Object>& object)</tt>
   *
   * Flags: Run First
   *
   * Emitted when a newly created listitem needs to be prepared for use.
   * 
   * It is the first signal emitted for every listitem.
   * 
   * The handler for this signal must call Gtk::ListItem::set_child()
   * to populate the listitem with widgets.
   * 
   * The signal_teardown() signal is the opposite
   * of this signal and can be used to undo everything done in this signal.
   * 
   * @newin{4,14}
   * 
   * @param object The `Glib::Object` to set up.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Glib::Object>&)> signal_setup_obj();

  
  /**
   * This is a more generic version of signal_bind(), usable if the factory is
   * being used to make something other than ListItems, for example ListHeader.
   * It receives a RefPtr to Glib::Object, which can be cast to the actual type.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%bind_obj(const Glib::RefPtr<Glib::Object>& object)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object has been bound to an item.
   * 
   * The handler for this signal must set
   * to populate the listitem with widgets.
   * 
   * After this signal was emitted, the object might be shown in
   * a Gtk::ListView or other widget.
   * 
   * The signal_unbind() signal is the
   * opposite of this signal and can be used to undo everything done
   * in this signal.
   * 
   * @newin{4,14}
   * 
   * @param object The `Glib::Object` to bind.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Glib::Object>&)> signal_bind_obj();

  
  /**
   * This is a more generic version of signal_unbind(), usable if the factory is
   * being used to make something other than ListItems, for example ListHeader.
   * It receives a RefPtr to Glib::Object, which can be cast to the actual type.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%unbind_obj(const Glib::RefPtr<Glib::Object>& object)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object has been unbound from its item.
   * 
   * This happens for example when a listitem was removed from use
   * in a list widget and its Gtk::ListItem::property_item() is about
   * to be unset.
   * 
   * This signal is the opposite of the signal_bind()
   * signal and should be used to undo everything done in that signal.
   * 
   * @newin{4,14}
   * 
   * @param object The `Glib::Object` to unbind.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Glib::Object>&)> signal_unbind_obj();

  
  /**
   * This is a more generic version of signal_teardown(), usable if the factory is
   * being used to make something other than ListItems, for example ListHeader.
   * It receives a RefPtr to Glib::Object, which can be cast to the actual type.
   *
   * @par Slot Prototype:
   * <tt>void on_my_%teardown_obj(const Glib::RefPtr<Glib::Object>& object)</tt>
   *
   * Flags: Run First
   *
   * Emitted when an object is about to be destroyed.
   * 
   * It is the last signal ever emitted for this @a object.
   * 
   * This signal is the opposite of the signal_setup()
   * signal and should be used to undo everything done in that signal.
   * 
   * @newin{4,14}
   * 
   * @param object The `Glib::Object` to tear down.
   */

  Glib::SignalProxy<void(const Glib::RefPtr<Glib::Object>&)> signal_teardown_obj();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gtk


namespace Glib
{
  /** A Glib::wrap() method for this object.
   *
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gtk::SignalListItemFactory
   */
  GTKMM_API
  Glib::RefPtr<Gtk::SignalListItemFactory> wrap(GtkSignalListItemFactory* object, bool take_copy = false);
}


#endif /* _GTKMM_SIGNALLISTITEMFACTORY_H */

