# Release notes for Gluster 11.1

This is a bugfix release. The release notes for [11.0](11.0.md) contains a listing of all the new improvements and bugs fixed in the GlusterFS 11 stable release.

**NOTE:**
- Next minor release tentative date: Release will be based on requirement only
- Users are highly encouraged to upgrade to newer releases of GlusterFS.

## Important fixes in this release
- Fix upgrade issue by reverting posix change related to storage.reserve value
- Fix possible data loss during rebalance if there is any linkfile on the system
- Fix maximum op-version for release 11

## Builds are available at

[https://download.gluster.org/pub/gluster/glusterfs/11/11.1/](https://download.gluster.org/pub/gluster/glusterfs/11/11.1/)

## Issues addressed in this release

- [#1000](https://github.com/gluster/glusterfs/issues/1000) Force 'char' type to be signed and add '-fsigned-char' option during compilation
- [#2752](https://github.com/gluster/glusterfs/issues/2752) Fix directory gfid handle if a rename fails
- [#3346](https://github.com/gluster/glusterfs/issues/3346) Fix stack overflow when processing glx_dir(p)list structures in xdr
- [#3636](https://github.com/gluster/glusterfs/issues/3636) Fix upgrade  issue by reverting posix change related to storage.reserve value
- [#3701](https://github.com/gluster/glusterfs/issues/3701) Fix error "not supported for ipv6"
- [#3732](https://github.com/gluster/glusterfs/issues/3732) Fix an AddressSanitizer issue heap-use-after-free
- [#4005](https://github.com/gluster/glusterfs/issues/4005) Fix maximum op-version for release 11
- [#4020](https://github.com/gluster/glusterfs/issues/4020) Improve regression test suite
- [#4029](https://github.com/gluster/glusterfs/issues/4029) Process stuck listing snapshots from NFS
- [#4031](https://github.com/gluster/glusterfs/issues/4031) Fix write failures with "I/O error" when using linux-aio on big-endean architectures
- [#4042](https://github.com/gluster/glusterfs/issues/4042) Recover posix locks upon reconnection of a disconnected brick
- [#4071](https://github.com/gluster/glusterfs/issues/4071) Make timestamps stable in snapview-server
- [#4074](https://github.com/gluster/glusterfs/issues/4074) Fix fuse Crashing with "Assertion failed: inode_lookup >= nlookup
- [#4107](https://github.com/gluster/glusterfs/issues/4107) Fix the issue of cli not showing the correct volume type
- [#4148](https://github.com/gluster/glusterfs/issues/4148) Fix possible data loss during rebalance if there is any linkfile on the system
- [#4190](https://github.com/gluster/glusterfs/issues/4190) Fix the issue of glusterfs encountering a SIGSEGV in __gf_free
- [#4198](https://github.com/gluster/glusterfs/issues/4198) Fix warnings raised by glusterfs fuse script on fedora38
- [#4224](https://github.com/gluster/glusterfs/pull/4224)   Add simple-quota xattr to afr and ec ignore list
- [#4196](https://github.com/gluster/glusterfs/pull/4196)   Revert structure of per_thread_pool_list_t
- [#4255](https://github.com/gluster/glusterfs/issues/4255) Fix the brick process crash during the upcall event
