#!/usr/bin/python3
# -*- coding: utf-8 -*-

import configparser, os

CURRENT_PATH = os.path.dirname(os.path.realpath(__file__))

files = ['ahorrodeenergia', 'equilibrado', 'maximorendimiento']


old_parser = configparser.ConfigParser()
new_parser = configparser.ConfigParser()

for file in files:
    OLD = os.path.join(CURRENT_PATH, 'old_defaults', file)
    NEW = os.path.join(CURRENT_PATH, '..', file)

    with open(OLD) as stream:
        old_parser.read_string("[CONFIGURATION]\n" + stream.read()) 
        
    with open(NEW) as stream:
        new_parser.read_string("[CONFIGURATION]\n" + stream.read())
        
    old_values = old_parser.items('CONFIGURATION')
    new_values = new_parser.items('CONFIGURATION')

    print('\n\nValues changed in :', file)

    for element, value  in old_values:   
        found = False     
        for new_element, new_value in new_values:    
              
            if element == new_element:
                found = True
                if value != new_value:
                    print('\t\n', element, ":", "'"+value+"'", ">>>", "'"+new_value+"'")

        if not found: 
            print("\t\n", '***', element, "Was deleted")
            
# for element in list(old_parser.items('CONFIGURATION')):
#     print(element[1])