/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PBEParametersGenerator;
import org.bouncycastle.crypto.internal.params.KeyParameterImpl;
import org.bouncycastle.crypto.internal.params.ParametersWithIV;

class PKCS12ParametersGenerator<T extends Parameters>
extends PBEParametersGenerator<T> {
    public static final int KEY_MATERIAL = 1;
    public static final int IV_MATERIAL = 2;
    public static final int MAC_MATERIAL = 3;
    private final Digest digest;
    private final int u;
    private final int v;

    public PKCS12ParametersGenerator(T t, Digest digest) {
        super(t);
        this.digest = digest;
        this.u = digest.getDigestSize();
        this.v = digest.getByteLength();
    }

    private void adjust(byte[] byArray, int n, byte[] byArray2) {
        int n2 = (byArray2[byArray2.length - 1] & 0xFF) + (byArray[n + byArray2.length - 1] & 0xFF) + 1;
        byArray[n + byArray2.length - 1] = (byte)n2;
        n2 >>>= 8;
        for (int i = byArray2.length - 2; i >= 0; --i) {
            byArray[n + i] = (byte)(n2 += (byArray2[i] & 0xFF) + (byArray[n + i] & 0xFF));
            n2 >>>= 8;
        }
    }

    private byte[] generateDerivedKey(int n, int n2) {
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3 = new byte[this.v];
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i != byArray3.length; ++i) {
            byArray3[i] = (byte)n;
        }
        if (this.salt != null && this.salt.length != 0) {
            byArray2 = new byte[this.v * ((this.salt.length + this.v - 1) / this.v)];
            for (int i = 0; i != byArray2.length; ++i) {
                byArray2[i] = this.salt[i % this.salt.length];
            }
        } else {
            byArray2 = new byte[]{};
        }
        if (this.password != null && this.password.length != 0) {
            byArray = new byte[this.v * ((this.password.length + this.v - 1) / this.v)];
            for (int i = 0; i != byArray.length; ++i) {
                byArray[i] = this.password[i % this.password.length];
            }
        } else {
            byArray = new byte[]{};
        }
        byte[] byArray5 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray5, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray5, byArray2.length, byArray.length);
        byte[] byArray6 = new byte[this.v];
        int n3 = (n2 + this.u - 1) / this.u;
        byte[] byArray7 = new byte[this.u];
        for (int i = 1; i <= n3; ++i) {
            int n4;
            this.digest.update(byArray3, 0, byArray3.length);
            this.digest.update(byArray5, 0, byArray5.length);
            this.digest.doFinal(byArray7, 0);
            for (n4 = 1; n4 < this.iterationCount; ++n4) {
                this.digest.update(byArray7, 0, byArray7.length);
                this.digest.doFinal(byArray7, 0);
            }
            for (n4 = 0; n4 != byArray6.length; ++n4) {
                byArray6[n4] = byArray7[n4 % byArray7.length];
            }
            for (n4 = 0; n4 != byArray5.length / this.v; ++n4) {
                this.adjust(byArray5, n4 * this.v, byArray6);
            }
            if (i == n3) {
                System.arraycopy(byArray7, 0, byArray4, (i - 1) * this.u, byArray4.length - (i - 1) * this.u);
                continue;
            }
            System.arraycopy(byArray7, 0, byArray4, (i - 1) * this.u, byArray7.length);
        }
        return byArray4;
    }

    @Override
    public CipherParameters generateDerivedParameters(int n) {
        byte[] byArray = this.generateDerivedKey(1, n /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public CipherParameters generateDerivedParameters(int n, int n2) {
        byte[] byArray = this.generateDerivedKey(1, n /= 8);
        byte[] byArray2 = this.generateDerivedKey(2, n2 /= 8);
        return new ParametersWithIV(new KeyParameterImpl(byArray), byArray2, 0, n2);
    }

    @Override
    public CipherParameters generateDerivedMacParameters(int n) {
        byte[] byArray = this.generateDerivedKey(3, n /= 8);
        return new KeyParameterImpl(byArray);
    }

    @Override
    public byte[] deriveKey(PasswordBasedDeriver.KeyType keyType, int n) {
        switch (keyType) {
            case CIPHER: {
                return this.generateDerivedKey(1, n);
            }
            case MAC: {
                return this.generateDerivedKey(3, n);
            }
        }
        throw new IllegalStateException("Unknown type in deriveKey: " + keyType.name());
    }

    @Override
    public byte[][] deriveKeyAndIV(PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        byte[][] byArrayArray = new byte[2][];
        switch (keyType) {
            case CIPHER: {
                byArrayArray[0] = this.generateDerivedKey(1, n);
                break;
            }
            case MAC: {
                byArrayArray[0] = this.generateDerivedKey(3, n);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type in deriveKeyAndIV: " + keyType.name());
            }
        }
        byArrayArray[1] = this.generateDerivedKey(2, n2);
        return byArrayArray;
    }
}

