/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOffering;
import software.amazon.awssdk.services.ec2.model.CapacityBlockExtensionOfferingSetCopier;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeCapacityBlockExtensionOfferingsResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeCapacityBlockExtensionOfferingsResponse> {
    private static final SdkField<List<CapacityBlockExtensionOffering>> CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CapacityBlockExtensionOfferings").getter(DescribeCapacityBlockExtensionOfferingsResponse.getter(DescribeCapacityBlockExtensionOfferingsResponse::capacityBlockExtensionOfferings)).setter(DescribeCapacityBlockExtensionOfferingsResponse.setter(Builder::capacityBlockExtensionOfferings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CapacityBlockExtensionOfferingSet").unmarshallLocationName("capacityBlockExtensionOfferingSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CapacityBlockExtensionOffering::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeCapacityBlockExtensionOfferingsResponse.getter(DescribeCapacityBlockExtensionOfferingsResponse::nextToken)).setter(DescribeCapacityBlockExtensionOfferingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeCapacityBlockExtensionOfferingsResponse.memberNameToFieldInitializer();
    private final List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings;
    private final String nextToken;

    private DescribeCapacityBlockExtensionOfferingsResponse(BuilderImpl builder) {
        super(builder);
        this.capacityBlockExtensionOfferings = builder.capacityBlockExtensionOfferings;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCapacityBlockExtensionOfferings() {
        return this.capacityBlockExtensionOfferings != null && !(this.capacityBlockExtensionOfferings instanceof SdkAutoConstructList);
    }

    public final List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings() {
        return this.capacityBlockExtensionOfferings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCapacityBlockExtensionOfferings() ? this.capacityBlockExtensionOfferings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeCapacityBlockExtensionOfferingsResponse)) {
            return false;
        }
        DescribeCapacityBlockExtensionOfferingsResponse other = (DescribeCapacityBlockExtensionOfferingsResponse)((Object)obj);
        return this.hasCapacityBlockExtensionOfferings() == other.hasCapacityBlockExtensionOfferings() && Objects.equals(this.capacityBlockExtensionOfferings(), other.capacityBlockExtensionOfferings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeCapacityBlockExtensionOfferingsResponse").add("CapacityBlockExtensionOfferings", this.hasCapacityBlockExtensionOfferings() ? this.capacityBlockExtensionOfferings() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CapacityBlockExtensionOfferings": {
                return Optional.ofNullable(clazz.cast(this.capacityBlockExtensionOfferings()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("CapacityBlockExtensionOfferingSet", CAPACITY_BLOCK_EXTENSION_OFFERINGS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeCapacityBlockExtensionOfferingsResponse, T> g) {
        return obj -> g.apply((DescribeCapacityBlockExtensionOfferingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeCapacityBlockExtensionOfferingsResponse model) {
            super(model);
            this.capacityBlockExtensionOfferings(model.capacityBlockExtensionOfferings);
            this.nextToken(model.nextToken);
        }

        public final List<CapacityBlockExtensionOffering.Builder> getCapacityBlockExtensionOfferings() {
            List<CapacityBlockExtensionOffering.Builder> result = CapacityBlockExtensionOfferingSetCopier.copyToBuilder(this.capacityBlockExtensionOfferings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCapacityBlockExtensionOfferings(Collection<CapacityBlockExtensionOffering.BuilderImpl> capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings = CapacityBlockExtensionOfferingSetCopier.copyFromBuilder(capacityBlockExtensionOfferings);
        }

        @Override
        public final Builder capacityBlockExtensionOfferings(Collection<CapacityBlockExtensionOffering> capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings = CapacityBlockExtensionOfferingSetCopier.copy(capacityBlockExtensionOfferings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensionOfferings(CapacityBlockExtensionOffering ... capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings(Arrays.asList(capacityBlockExtensionOfferings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder capacityBlockExtensionOfferings(Consumer<CapacityBlockExtensionOffering.Builder> ... capacityBlockExtensionOfferings) {
            this.capacityBlockExtensionOfferings(Stream.of(capacityBlockExtensionOfferings).map(c -> (CapacityBlockExtensionOffering)((CapacityBlockExtensionOffering.Builder)CapacityBlockExtensionOffering.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeCapacityBlockExtensionOfferingsResponse build() {
            return new DescribeCapacityBlockExtensionOfferingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeCapacityBlockExtensionOfferingsResponse> {
        public Builder capacityBlockExtensionOfferings(Collection<CapacityBlockExtensionOffering> var1);

        public Builder capacityBlockExtensionOfferings(CapacityBlockExtensionOffering ... var1);

        public Builder capacityBlockExtensionOfferings(Consumer<CapacityBlockExtensionOffering.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

