/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.DiffContext;
import org.openapitools.openapidiff.core.model.DiffResult;

public abstract class ChangedList<T>
implements Changed {
    protected DiffContext context;
    protected List<T> oldValue;
    protected List<T> newValue;
    private List<T> increased;
    private List<T> missing;
    private List<T> shared;

    protected ChangedList(List<T> oldValue, List<T> newValue, DiffContext context) {
        this.oldValue = Optional.ofNullable(oldValue).orElse(new ArrayList());
        this.newValue = Optional.ofNullable(newValue).orElse(new ArrayList());
        this.context = context;
        this.shared = new ArrayList<T>();
        this.increased = new ArrayList<T>();
        this.missing = new ArrayList<T>();
    }

    @Override
    public DiffResult isChanged() {
        if (this.missing.isEmpty() && this.increased.isEmpty()) {
            return DiffResult.NO_CHANGES;
        }
        return this.isItemsChanged();
    }

    public abstract DiffResult isItemsChanged();

    public DiffContext getContext() {
        return this.context;
    }

    public List<T> getOldValue() {
        return this.oldValue;
    }

    public List<T> getNewValue() {
        return this.newValue;
    }

    public List<T> getIncreased() {
        return this.increased;
    }

    public List<T> getMissing() {
        return this.missing;
    }

    public List<T> getShared() {
        return this.shared;
    }

    public ChangedList<T> setContext(DiffContext context) {
        this.context = context;
        return this;
    }

    public ChangedList<T> setOldValue(List<T> oldValue) {
        this.oldValue = oldValue;
        return this;
    }

    public ChangedList<T> setNewValue(List<T> newValue) {
        this.newValue = newValue;
        return this;
    }

    public ChangedList<T> setIncreased(List<T> increased) {
        this.increased = increased;
        return this;
    }

    public ChangedList<T> setMissing(List<T> missing) {
        this.missing = missing;
        return this;
    }

    public ChangedList<T> setShared(List<T> shared) {
        this.shared = shared;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChangedList that = (ChangedList)o;
        return Objects.equals(this.context, that.context) && Objects.equals(this.oldValue, that.oldValue) && Objects.equals(this.newValue, that.newValue) && Objects.equals(this.increased, that.increased) && Objects.equals(this.missing, that.missing) && Objects.equals(this.shared, that.shared);
    }

    public int hashCode() {
        return Objects.hash(this.context, this.oldValue, this.newValue, this.increased, this.missing, this.shared);
    }

    public String toString() {
        return "ChangedList(context=" + this.getContext() + ", oldValue=" + this.getOldValue() + ", newValue=" + this.getNewValue() + ", increased=" + this.getIncreased() + ", missing=" + this.getMissing() + ", shared=" + this.getShared() + ")";
    }

    public static class SimpleChangedList<T>
    extends ChangedList<T> {
        public SimpleChangedList(List<T> oldValue, List<T> newValue) {
            super(oldValue, newValue, null);
        }

        @Override
        public DiffResult isItemsChanged() {
            return DiffResult.UNKNOWN;
        }
    }
}

