/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.CodeBuilder;
import io.github.dmlloyd.classfile.Label;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.Expr;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.impl.BlockCreatorImpl;
import io.quarkus.gizmo2.impl.Item;
import io.quarkus.gizmo2.impl.Node;
import io.quarkus.gizmo2.impl.Util;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.function.BiFunction;

final class InstanceOf
extends Item {
    private final Item input;
    private final GenericType type;
    private Label label;

    InstanceOf(Expr input, GenericType type) {
        this.input = (Item)input;
        this.type = type;
    }

    @Override
    public ClassDesc type() {
        return ConstantDescs.CD_boolean;
    }

    @Override
    protected Node forEachDependency(Node node, BiFunction<Item, Node, Node> op) {
        return this.input.process(node.prev(), op);
    }

    @Override
    public void writeCode(CodeBuilder cb, BlockCreatorImpl block) {
        this.label = cb.newBoundLabel();
        cb.instanceOf(this.type.desc());
    }

    @Override
    public void writeAnnotations(RetentionPolicy retention, ArrayList<TypeAnnotation> annotations) {
        if (this.type.hasAnnotations(retention)) {
            Util.computeAnnotations(this.type, retention, (TypeAnnotation.TargetInfo)TypeAnnotation.TargetInfo.ofInstanceofExpr((Label)this.label), annotations, new ArrayDeque<TypeAnnotation.TypePathComponent>());
        }
    }
}

