/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.rendered;

import io.sf.carte.echosvg.ext.awt.ColorSpaceHintKey;
import io.sf.carte.echosvg.ext.awt.image.GraphicsUtil;
import io.sf.carte.echosvg.ext.awt.image.rendered.AbstractRed;
import io.sf.carte.echosvg.ext.awt.image.rendered.CachableRed;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.BandCombineOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class Any2LumRed
extends AbstractRed {
    private static final boolean isColorConvertOpAplhaSupported = Any2LumRed.getColorConvertOpAplhaSupported();

    public Any2LumRed(CachableRed cachableRed) {
        super(cachableRed, cachableRed.getBounds(), Any2LumRed.fixColorModel(cachableRed), Any2LumRed.fixSampleModel(cachableRed), cachableRed.getTileGridXOffset(), cachableRed.getTileGridYOffset(), null);
        this.props.put("io.sf.carte.echosvg.gvt.filter.Colorspace", ColorSpaceHintKey.VALUE_COLORSPACE_GREY);
    }

    @Override
    public WritableRaster copyData(WritableRaster writableRaster) {
        CachableRed cachableRed = (CachableRed)this.getSources().get(0);
        SampleModel sampleModel = cachableRed.getSampleModel();
        ColorModel colorModel = cachableRed.getColorModel();
        Raster raster = cachableRed.getData(writableRaster.getBounds());
        if (colorModel == null) {
            float[][] fArray = null;
            if (sampleModel.getNumBands() == 2) {
                fArray = new float[2][2];
                fArray[0][0] = 1.0f;
                fArray[1][1] = 1.0f;
            } else {
                fArray = new float[sampleModel.getNumBands()][1];
                fArray[0][0] = 1.0f;
            }
            BandCombineOp bandCombineOp = new BandCombineOp(fArray, null);
            bandCombineOp.filter(raster, writableRaster);
        } else {
            BufferedImage bufferedImage;
            Object object;
            WritableRaster writableRaster2 = (WritableRaster)raster;
            if (colorModel.hasAlpha()) {
                GraphicsUtil.coerceData(writableRaster2, colorModel, false);
            }
            BufferedImage bufferedImage2 = new BufferedImage(colorModel, writableRaster2.createWritableTranslatedChild(0, 0), false, null);
            ColorModel colorModel2 = this.getColorModel();
            if (colorModel2.hasAlpha() && !isColorConvertOpAplhaSupported) {
                object = (PixelInterleavedSampleModel)writableRaster.getSampleModel();
                PixelInterleavedSampleModel pixelInterleavedSampleModel = new PixelInterleavedSampleModel(((SampleModel)object).getDataType(), ((SampleModel)object).getWidth(), ((SampleModel)object).getHeight(), ((ComponentSampleModel)object).getPixelStride(), ((ComponentSampleModel)object).getScanlineStride(), new int[]{0});
                WritableRaster writableRaster3 = Raster.createWritableRaster(pixelInterleavedSampleModel, writableRaster.getDataBuffer(), new Point(0, 0));
                writableRaster3 = writableRaster3.createWritableChild(writableRaster.getMinX() - writableRaster.getSampleModelTranslateX(), writableRaster.getMinY() - writableRaster.getSampleModelTranslateY(), writableRaster.getWidth(), writableRaster.getHeight(), 0, 0, null);
                ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
                bufferedImage = new BufferedImage(componentColorModel, writableRaster3, false, null);
            } else {
                bufferedImage = new BufferedImage(colorModel2, writableRaster.createWritableTranslatedChild(0, 0), colorModel2.isAlphaPremultiplied(), null);
            }
            object = new ColorConvertOp(null);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage);
            if (colorModel2.hasAlpha()) {
                Any2LumRed.copyBand(writableRaster2, sampleModel.getNumBands() - 1, writableRaster, this.getSampleModel().getNumBands() - 1);
                if (colorModel2.isAlphaPremultiplied()) {
                    GraphicsUtil.multiplyAlpha(writableRaster);
                }
            }
        }
        return writableRaster;
    }

    protected static ColorModel fixColorModel(CachableRed cachableRed) {
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8, 8}, true, colorModel.isAlphaPremultiplied(), 3, 0);
            }
            return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
        }
        SampleModel sampleModel = cachableRed.getSampleModel();
        if (sampleModel.getNumBands() == 2) {
            return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8, 8}, true, true, 3, 0);
        }
        return new ComponentColorModel(ColorSpace.getInstance(1003), new int[]{8}, false, false, 1, 0);
    }

    protected static SampleModel fixSampleModel(CachableRed cachableRed) {
        SampleModel sampleModel = cachableRed.getSampleModel();
        int n = sampleModel.getWidth();
        int n2 = sampleModel.getHeight();
        ColorModel colorModel = cachableRed.getColorModel();
        if (colorModel != null) {
            if (colorModel.hasAlpha()) {
                return new PixelInterleavedSampleModel(0, n, n2, 2, 2 * n, new int[]{0, 1});
            }
            return new PixelInterleavedSampleModel(0, n, n2, 1, n, new int[]{0});
        }
        if (sampleModel.getNumBands() == 2) {
            return new PixelInterleavedSampleModel(0, n, n2, 2, 2 * n, new int[]{0, 1});
        }
        return new PixelInterleavedSampleModel(0, n, n2, 1, n, new int[]{0});
    }

    private static boolean getColorConvertOpAplhaSupported() {
        int n = 50;
        BufferedImage bufferedImage = new BufferedImage(n, n, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setColor(Color.red);
        graphics2D.fillRect(0, 0, n, n);
        graphics2D.dispose();
        BufferedImage bufferedImage2 = new BufferedImage(n, n, 2);
        Graphics2D graphics2D2 = bufferedImage2.createGraphics();
        graphics2D2.setComposite(AlphaComposite.Clear);
        graphics2D2.fillRect(0, 0, n, n);
        graphics2D2.dispose();
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        ColorConvertOp colorConvertOp = new ColorConvertOp(colorSpace, null);
        colorConvertOp.filter(bufferedImage, bufferedImage2);
        return Any2LumRed.getAlpha(bufferedImage) == Any2LumRed.getAlpha(bufferedImage2);
    }

    private static int getAlpha(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth() / 2;
        int n2 = bufferedImage.getHeight() / 2;
        return 0xFF & bufferedImage.getRGB(n, n2) >> 24;
    }
}

