/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.xmlimpl;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.Ref;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.xmlimpl.XML;
import org.mozilla.javascript.xmlimpl.XMLList;
import org.mozilla.javascript.xmlimpl.XMLObjectImpl;
import org.mozilla.javascript.xmlimpl.XmlNode;

class XMLName
extends Ref {
    static final long serialVersionUID = 3832176310755686977L;
    private XmlNode.QName qname;
    private boolean isAttributeName;
    private boolean isDescendants;
    private XMLObjectImpl xmlObject;

    private static boolean isNCNameStartChar(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            if (n >= 97) {
                return n <= 122;
            }
            if (n >= 65) {
                if (n <= 90) {
                    return true;
                }
                return n == 95;
            }
        } else if ((n & 0xFFFFE000) == 0) {
            return 192 <= n && n <= 214 || 216 <= n && n <= 246 || 248 <= n && n <= 767 || 880 <= n && n <= 893 || 895 <= n;
        }
        return 8204 <= n && n <= 8205 || 8304 <= n && n <= 8591 || 11264 <= n && n <= 12271 || 12289 <= n && n <= 55295 || 63744 <= n && n <= 64975 || 65008 <= n && n <= 65533 || 65536 <= n && n <= 983039;
    }

    private static boolean isNCNameChar(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            if (n >= 97) {
                return n <= 122;
            }
            if (n >= 65) {
                if (n <= 90) {
                    return true;
                }
                return n == 95;
            }
            if (n >= 48) {
                return n <= 57;
            }
            return n == 45 || n == 46;
        }
        if ((n & 0xFFFFE000) == 0) {
            return XMLName.isNCNameStartChar(n) || n == 183 || 768 <= n && n <= 879;
        }
        return XMLName.isNCNameStartChar(n) || 8255 <= n && n <= 8256;
    }

    static boolean accept(Object object) {
        String string;
        try {
            string = ScriptRuntime.toString(object);
        }
        catch (EcmaError ecmaError) {
            if ("TypeError".equals(ecmaError.getName())) {
                return false;
            }
            throw ecmaError;
        }
        int n = string.length();
        if (n != 0 && XMLName.isNCNameStartChar(string.charAt(0))) {
            for (int i = 1; i != n; ++i) {
                if (XMLName.isNCNameChar(string.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private XMLName() {
    }

    static XMLName formStar() {
        XMLName xMLName = new XMLName();
        xMLName.qname = XmlNode.QName.create(null, null);
        return xMLName;
    }

    @Deprecated
    static XMLName formProperty(XmlNode.Namespace namespace, String string) {
        if (string != null && string.equals("*")) {
            string = null;
        }
        XMLName xMLName = new XMLName();
        xMLName.qname = XmlNode.QName.create(namespace, string);
        return xMLName;
    }

    static XMLName formProperty(String string, String string2) {
        return XMLName.formProperty(XmlNode.Namespace.create(string), string2);
    }

    static XMLName create(String string, String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException();
        }
        int n = string2.length();
        if (n != 0) {
            char c = string2.charAt(0);
            if (c == '*') {
                if (n == 1) {
                    return XMLName.formStar();
                }
            } else if (c == '@') {
                XMLName xMLName = XMLName.formProperty("", string2.substring(1));
                xMLName.setAttributeName();
                return xMLName;
            }
        }
        return XMLName.formProperty(string, string2);
    }

    static XMLName create(XmlNode.QName qName, boolean bl, boolean bl2) {
        XMLName xMLName = new XMLName();
        xMLName.qname = qName;
        xMLName.isAttributeName = bl;
        xMLName.isDescendants = bl2;
        return xMLName;
    }

    @Deprecated
    static XMLName create(XmlNode.QName qName) {
        return XMLName.create(qName, false, false);
    }

    void initXMLObject(XMLObjectImpl xMLObjectImpl) {
        if (xMLObjectImpl == null) {
            throw new IllegalArgumentException();
        }
        if (this.xmlObject != null) {
            throw new IllegalStateException();
        }
        this.xmlObject = xMLObjectImpl;
    }

    String uri() {
        if (this.qname.getNamespace() == null) {
            return null;
        }
        return this.qname.getNamespace().getUri();
    }

    String localName() {
        if (this.qname.getLocalName() == null) {
            return "*";
        }
        return this.qname.getLocalName();
    }

    private void addDescendantChildren(XMLList xMLList, XML xML) {
        XMLName xMLName = this;
        if (xML.isElement()) {
            XML[] xMLArray = xML.getChildren();
            for (int i = 0; i < xMLArray.length; ++i) {
                if (xMLName.matches(xMLArray[i])) {
                    xMLList.addToList(xMLArray[i]);
                }
                this.addDescendantChildren(xMLList, xMLArray[i]);
            }
        }
    }

    void addMatchingAttributes(XMLList xMLList, XML xML) {
        XMLName xMLName = this;
        if (xML.isElement()) {
            XML[] xMLArray = xML.getAttributes();
            for (int i = 0; i < xMLArray.length; ++i) {
                if (!xMLName.matches(xMLArray[i])) continue;
                xMLList.addToList(xMLArray[i]);
            }
        }
    }

    private void addDescendantAttributes(XMLList xMLList, XML xML) {
        if (xML.isElement()) {
            this.addMatchingAttributes(xMLList, xML);
            XML[] xMLArray = xML.getChildren();
            for (int i = 0; i < xMLArray.length; ++i) {
                this.addDescendantAttributes(xMLList, xMLArray[i]);
            }
        }
    }

    XMLList matchDescendantAttributes(XMLList xMLList, XML xML) {
        xMLList.setTargets(xML, null);
        this.addDescendantAttributes(xMLList, xML);
        return xMLList;
    }

    XMLList matchDescendantChildren(XMLList xMLList, XML xML) {
        xMLList.setTargets(xML, null);
        this.addDescendantChildren(xMLList, xML);
        return xMLList;
    }

    void addDescendants(XMLList xMLList, XML xML) {
        XMLName xMLName = this;
        if (xMLName.isAttributeName()) {
            this.matchDescendantAttributes(xMLList, xML);
        } else {
            this.matchDescendantChildren(xMLList, xML);
        }
    }

    private void addAttributes(XMLList xMLList, XML xML) {
        this.addMatchingAttributes(xMLList, xML);
    }

    void addMatches(XMLList xMLList, XML xML) {
        if (this.isDescendants()) {
            this.addDescendants(xMLList, xML);
        } else if (this.isAttributeName()) {
            this.addAttributes(xMLList, xML);
        } else {
            XML[] xMLArray = xML.getChildren();
            if (xMLArray != null) {
                for (int i = 0; i < xMLArray.length; ++i) {
                    if (!this.matches(xMLArray[i])) continue;
                    xMLList.addToList(xMLArray[i]);
                }
            }
            xMLList.setTargets(xML, this.toQname());
        }
    }

    XMLList getMyValueOn(XML xML) {
        XMLList xMLList = xML.newXMLList();
        this.addMatches(xMLList, xML);
        return xMLList;
    }

    void setMyValueOn(XML xML, Object object) {
        if (object == null) {
            object = "null";
        } else if (object instanceof Undefined) {
            object = "undefined";
        }
        XMLName xMLName = this;
        if (xMLName.isAttributeName()) {
            xML.setAttribute(xMLName, object);
        } else if (xMLName.uri() == null && xMLName.localName().equals("*")) {
            xML.setChildren(object);
        } else {
            XMLList xMLList;
            XMLObjectImpl xMLObjectImpl = null;
            if (object instanceof XMLObjectImpl) {
                xMLObjectImpl = (XMLObjectImpl)object;
                if (xMLObjectImpl instanceof XML && ((XML)xMLObjectImpl).isAttribute()) {
                    xMLObjectImpl = xML.makeXmlFromString(xMLName, xMLObjectImpl.toString());
                }
                if (xMLObjectImpl instanceof XMLList) {
                    for (int i = 0; i < xMLObjectImpl.length(); ++i) {
                        XML xML2 = ((XMLList)xMLObjectImpl).item(i);
                        if (!xML2.isAttribute()) continue;
                        ((XMLList)xMLObjectImpl).replace(i, xML.makeXmlFromString(xMLName, xML2.toString()));
                    }
                }
            } else {
                xMLObjectImpl = xML.makeXmlFromString(xMLName, ScriptRuntime.toString(object));
            }
            if ((xMLList = xML.getPropertyList(xMLName)).length() == 0) {
                xML.appendChild(xMLObjectImpl);
            } else {
                for (int i = 1; i < xMLList.length(); ++i) {
                    xML.removeChild(xMLList.item(i).childIndex());
                }
                XML xML3 = xMLList.item(0);
                xML.replace(xML3.childIndex(), (Object)xMLObjectImpl);
            }
        }
    }

    @Override
    public boolean has(Context context) {
        if (this.xmlObject == null) {
            return false;
        }
        return this.xmlObject.hasXMLProperty(this);
    }

    @Override
    public Object get(Context context) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefReadError(Undefined.instance, this.toString());
        }
        return this.xmlObject.getXMLProperty(this);
    }

    @Override
    public Object set(Context context, Object object) {
        if (this.xmlObject == null) {
            throw ScriptRuntime.undefWriteError(Undefined.instance, this.toString(), object);
        }
        if (this.isDescendants) {
            throw Kit.codeBug();
        }
        this.xmlObject.putXMLProperty(this, object);
        return object;
    }

    @Override
    public boolean delete(Context context) {
        if (this.xmlObject == null) {
            return true;
        }
        this.xmlObject.deleteXMLProperty(this);
        return !this.xmlObject.hasXMLProperty(this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.isDescendants) {
            stringBuilder.append("..");
        }
        if (this.isAttributeName) {
            stringBuilder.append('@');
        }
        if (this.uri() == null) {
            stringBuilder.append('*');
            if (this.localName().equals("*")) {
                return stringBuilder.toString();
            }
        } else {
            stringBuilder.append('\"').append(this.uri()).append('\"');
        }
        stringBuilder.append(':').append(this.localName());
        return stringBuilder.toString();
    }

    final XmlNode.QName toQname() {
        return this.qname;
    }

    final boolean matchesLocalName(String string) {
        return this.localName().equals("*") || this.localName().equals(string);
    }

    final boolean matchesElement(XmlNode.QName qName) {
        return !(this.uri() != null && !this.uri().equals(qName.getNamespace().getUri()) || !this.localName().equals("*") && !this.localName().equals(qName.getLocalName()));
    }

    final boolean matches(XML xML) {
        XmlNode.QName qName = xML.getNodeQname();
        String string = null;
        if (qName.getNamespace() != null) {
            string = qName.getNamespace().getUri();
        }
        if (this.isAttributeName) {
            if (xML.isAttribute()) {
                return !(this.uri() != null && !this.uri().equals(string) || !this.localName().equals("*") && !this.localName().equals(qName.getLocalName()));
            }
            return false;
        }
        if (this.uri() == null || xML.isElement() && this.uri().equals(string)) {
            if (this.localName().equals("*")) {
                return true;
            }
            if (xML.isElement() && this.localName().equals(qName.getLocalName())) {
                return true;
            }
        }
        return false;
    }

    boolean isAttributeName() {
        return this.isAttributeName;
    }

    void setAttributeName() {
        this.isAttributeName = true;
    }

    boolean isDescendants() {
        return this.isDescendants;
    }

    @Deprecated
    void setIsDescendants() {
        this.isDescendants = true;
    }
}

