/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.serialize;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.meta.DBSerializable;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.tools.transfer.serialize.DTObjectSerializer;
import org.jkiss.dbeaver.tools.transfer.serialize.SerializerDescriptor;

public class SerializerRegistry {
    private static final Log log = Log.getLog(SerializerRegistry.class);
    private static SerializerRegistry instance = null;
    private final Map<String, SerializerDescriptor> serializers = new HashMap<String, SerializerDescriptor>();

    public static synchronized SerializerRegistry getInstance() {
        if (instance == null) {
            instance = new SerializerRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private SerializerRegistry(IExtensionRegistry registry) {
        IConfigurationElement[] extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.serialize");
        boolean isDistributedMultiuserApp = DBWorkbench.isDistributed() && DBWorkbench.getPlatform().getApplication().isMultiuser();
        IConfigurationElement[] iConfigurationElementArray = extElements;
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            if ("serializer".equals(ext.getName())) {
                SerializerDescriptor sd = new SerializerDescriptor(ext);
                if (!isDistributedMultiuserApp || sd.isDistributed()) {
                    this.serializers.put(sd.getId(), sd);
                }
            }
            ++n2;
        }
    }

    public boolean isSerializable(Object object) {
        return object.getClass().getAnnotation(DBSerializable.class) != null;
    }

    public String getObjectType(Object object) {
        DBSerializable dbSerializable = object.getClass().getAnnotation(DBSerializable.class);
        return dbSerializable != null ? dbSerializable.value() : null;
    }

    @Nullable
    public DTObjectSerializer createSerializer(Object object) {
        DBSerializable dbSerializable = object.getClass().getAnnotation(DBSerializable.class);
        if (dbSerializable != null) {
            return this.createSerializerByType(dbSerializable.value());
        }
        return null;
    }

    @Nullable
    public <OBJECT_CONTEXT, OBJECT_TYPE> DTObjectSerializer<OBJECT_CONTEXT, OBJECT_TYPE> createSerializerByType(String typeID) {
        SerializerDescriptor sd = this.serializers.get(typeID);
        if (sd == null) {
            log.error((Object)("Serializer '" + typeID + "' not found"));
            return null;
        }
        try {
            return sd.createSerializer();
        }
        catch (Exception e) {
            log.error((Object)("Error creating serializer " + sd.getId()), (Throwable)e);
            return null;
        }
    }
}

