/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import org.netbeans.api.io.Fold;
import org.netbeans.api.io.Hyperlink;
import org.netbeans.api.io.OutputColor;
import org.netbeans.api.io.Position;
import org.netbeans.spi.io.InputOutputProvider;

public abstract class OutputWriter
extends PrintWriter {
    private OutputWriter() {
        super(new DummyWriter());
    }

    public abstract Position getCurrentPosition();

    public abstract Fold startFold(boolean var1);

    public abstract void endFold(Fold var1);

    public abstract void print(String var1, Hyperlink var2, OutputColor var3);

    public abstract void print(String var1, Hyperlink var2);

    public abstract void print(String var1, OutputColor var2);

    public abstract void println(String var1, Hyperlink var2, OutputColor var3);

    public abstract void println(String var1, Hyperlink var2);

    public abstract void println(String var1, OutputColor var2);

    static <IO, OW extends PrintWriter, P, F> OutputWriter create(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW) {
        return new Impl<IO, OW, P, F>(inputOutputProvider, IO, OW);
    }

    private static class DummyWriter
    extends Writer {
        private DummyWriter() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }

    private static class Impl<IO, OW extends PrintWriter, P, F>
    extends OutputWriter {
        private final InputOutputProvider<IO, OW, P, F> provider;
        private final IO io;
        private final OW writer;

        public Impl(InputOutputProvider<IO, OW, P, F> inputOutputProvider, IO IO, OW OW) {
            this.provider = inputOutputProvider;
            this.io = IO;
            this.writer = OW;
        }

        @Override
        public Position getCurrentPosition() {
            return Position.create(this.provider, this.io, this.writer, this.provider.getCurrentPosition(this.io, this.writer));
        }

        @Override
        public void print(String string, Hyperlink hyperlink, OutputColor outputColor) {
            this.provider.print(this.io, this.writer, string, hyperlink, outputColor, false);
        }

        @Override
        public void print(String string, Hyperlink hyperlink) {
            this.provider.print(this.io, this.writer, string, hyperlink, null, false);
        }

        @Override
        public void print(String string, OutputColor outputColor) {
            this.provider.print(this.io, this.writer, string, null, outputColor, false);
        }

        @Override
        public void println(String string, Hyperlink hyperlink, OutputColor outputColor) {
            this.provider.print(this.io, this.writer, string, hyperlink, outputColor, true);
        }

        @Override
        public void println(String string, Hyperlink hyperlink) {
            this.provider.print(this.io, this.writer, string, hyperlink, null, true);
        }

        @Override
        public void println(String string, OutputColor outputColor) {
            this.provider.print(this.io, this.writer, string, null, outputColor, true);
        }

        @Override
        public void flush() {
            ((PrintWriter)this.writer).flush();
        }

        @Override
        public void close() {
            ((PrintWriter)this.writer).close();
        }

        @Override
        public boolean checkError() {
            return ((PrintWriter)this.writer).checkError();
        }

        @Override
        public void write(int n) {
            ((PrintWriter)this.writer).write(n);
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            ((PrintWriter)this.writer).write(cArray, n, n2);
        }

        @Override
        public void write(char[] cArray) {
            ((PrintWriter)this.writer).write(cArray);
        }

        @Override
        public void write(String string, int n, int n2) {
            ((PrintWriter)this.writer).write(string, n, n2);
        }

        @Override
        public void write(String string) {
            ((PrintWriter)this.writer).write(string);
        }

        @Override
        public void print(boolean bl) {
            ((PrintWriter)this.writer).print(bl);
        }

        @Override
        public void print(char c) {
            ((PrintWriter)this.writer).print(c);
        }

        @Override
        public void print(int n) {
            ((PrintWriter)this.writer).print(n);
        }

        @Override
        public void print(long l) {
            ((PrintWriter)this.writer).print(l);
        }

        @Override
        public void print(float f) {
            ((PrintWriter)this.writer).print(f);
        }

        @Override
        public void print(double d) {
            ((PrintWriter)this.writer).print(d);
        }

        @Override
        public void print(char[] cArray) {
            ((PrintWriter)this.writer).print(cArray);
        }

        @Override
        public void print(String string) {
            ((PrintWriter)this.writer).print(string);
        }

        @Override
        public void print(Object object) {
            ((PrintWriter)this.writer).print(object);
        }

        @Override
        public void println() {
            ((PrintWriter)this.writer).println();
        }

        @Override
        public void println(boolean bl) {
            ((PrintWriter)this.writer).println(bl);
        }

        @Override
        public void println(char c) {
            ((PrintWriter)this.writer).println(c);
        }

        @Override
        public void println(int n) {
            ((PrintWriter)this.writer).println(n);
        }

        @Override
        public void println(long l) {
            ((PrintWriter)this.writer).println(l);
        }

        @Override
        public void println(float f) {
            ((PrintWriter)this.writer).println(f);
        }

        @Override
        public void println(double d) {
            ((PrintWriter)this.writer).println(d);
        }

        @Override
        public void println(char[] cArray) {
            ((PrintWriter)this.writer).println(cArray);
        }

        @Override
        public void println(String string) {
            ((PrintWriter)this.writer).println(string);
        }

        @Override
        public void println(Object object) {
            ((PrintWriter)this.writer).println(object);
        }

        @Override
        public PrintWriter printf(String string, Object ... objectArray) {
            return ((PrintWriter)this.writer).printf(string, objectArray);
        }

        @Override
        public PrintWriter printf(Locale locale, String string, Object ... objectArray) {
            return ((PrintWriter)this.writer).printf(locale, string, objectArray);
        }

        @Override
        public PrintWriter format(String string, Object ... objectArray) {
            return ((PrintWriter)this.writer).format(string, objectArray);
        }

        @Override
        public PrintWriter format(Locale locale, String string, Object ... objectArray) {
            return ((PrintWriter)this.writer).format(locale, string, objectArray);
        }

        @Override
        public PrintWriter append(CharSequence charSequence) {
            return ((PrintWriter)this.writer).append(charSequence);
        }

        @Override
        public PrintWriter append(CharSequence charSequence, int n, int n2) {
            return ((PrintWriter)this.writer).append(charSequence, n, n2);
        }

        @Override
        public PrintWriter append(char c) {
            return ((PrintWriter)this.writer).append(c);
        }

        @Override
        public Fold startFold(boolean bl) {
            F f = this.provider.startFold(this.io, this.writer, bl);
            return Fold.create(this.provider, this.io, this.writer, f);
        }

        @Override
        public void endFold(Fold fold) {
            if (fold != Fold.UNSUPPORTED) {
                fold.endFold();
            }
        }
    }
}

