/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2.datasources;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionAndInfo;
import org.apache.tomcat.dbcp.dbcp2.datasources.PooledConnectionManager;
import org.apache.tomcat.dbcp.pool2.DestroyMode;
import org.apache.tomcat.dbcp.pool2.ObjectPool;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.PooledObjectFactory;
import org.apache.tomcat.dbcp.pool2.impl.DefaultPooledObject;

class CPDSConnectionFactory
implements PooledObjectFactory<PooledConnectionAndInfo>,
ConnectionEventListener,
PooledConnectionManager {
    private static final String NO_KEY_MESSAGE = "close() was called on a Connection, but I have no record of the underlying PooledConnection.";
    private final ConnectionPoolDataSource cpds;
    private final String validationQuery;
    private final int validationQueryTimeoutSeconds;
    private final boolean rollbackAfterValidation;
    private ObjectPool<PooledConnectionAndInfo> pool;
    private final String userName;
    private char[] userPassword;
    private long maxConnLifetimeMillis = -1L;
    private final Set<PooledConnection> validatingSet = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<PooledConnection, PooledConnectionAndInfo> pcMap = new ConcurrentHashMap<PooledConnection, PooledConnectionAndInfo>();

    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, int n, boolean bl, String string2, char[] cArray) {
        this.cpds = connectionPoolDataSource;
        this.validationQuery = string;
        this.validationQueryTimeoutSeconds = n;
        this.userName = string2;
        this.userPassword = cArray;
        this.rollbackAfterValidation = bl;
    }

    CPDSConnectionFactory(ConnectionPoolDataSource connectionPoolDataSource, String string, int n, boolean bl, String string2, String string3) {
        this(connectionPoolDataSource, string, n, bl, string2, Utils.toCharArray(string3));
    }

    char[] getPasswordCharArray() {
        return this.userPassword;
    }

    public ObjectPool<PooledConnectionAndInfo> getPool() {
        return this.pool;
    }

    public void setPool(ObjectPool<PooledConnectionAndInfo> objectPool) {
        this.pool = objectPool;
    }

    @Override
    public synchronized PooledObject<PooledConnectionAndInfo> makeObject() {
        PooledConnectionAndInfo pooledConnectionAndInfo;
        try {
            PooledConnection pooledConnection = null;
            pooledConnection = this.userName == null ? this.cpds.getPooledConnection() : this.cpds.getPooledConnection(this.userName, Utils.toString(this.userPassword));
            if (pooledConnection == null) {
                throw new IllegalStateException("Connection pool data source returned null from getPooledConnection");
            }
            pooledConnection.addConnectionEventListener(this);
            pooledConnectionAndInfo = new PooledConnectionAndInfo(pooledConnection, this.userName, this.userPassword);
            this.pcMap.put(pooledConnection, pooledConnectionAndInfo);
        }
        catch (SQLException sQLException) {
            throw new RuntimeException(sQLException.getMessage());
        }
        return new DefaultPooledObject<PooledConnectionAndInfo>(pooledConnectionAndInfo);
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        this.doDestroyObject(pooledObject.getObject());
    }

    @Override
    public void destroyObject(PooledObject<PooledConnectionAndInfo> pooledObject, DestroyMode destroyMode) throws Exception {
        this.destroyObject(pooledObject);
    }

    private void doDestroyObject(PooledConnectionAndInfo pooledConnectionAndInfo) throws Exception {
        PooledConnection pooledConnection = pooledConnectionAndInfo.getPooledConnection();
        pooledConnection.removeConnectionEventListener(this);
        this.pcMap.remove(pooledConnection);
        pooledConnection.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean validateObject(PooledObject<PooledConnectionAndInfo> pooledObject) {
        try {
            this.validateLifetime(pooledObject);
        }
        catch (Exception exception) {
            return false;
        }
        boolean bl = false;
        PooledConnection pooledConnection = pooledObject.getObject().getPooledConnection();
        Connection connection = null;
        this.validatingSet.add(pooledConnection);
        if (null == this.validationQuery) {
            int n = this.validationQueryTimeoutSeconds;
            if (n < 0) {
                n = 0;
            }
            try {
                connection = pooledConnection.getConnection();
                bl = connection.isValid(n);
                return bl;
            }
            catch (SQLException sQLException) {
                bl = false;
                return bl;
            }
            finally {
                Utils.closeQuietly(connection);
                this.validatingSet.remove(pooledConnection);
            }
        }
        Statement statement = null;
        ResultSet resultSet = null;
        this.validatingSet.add(pooledConnection);
        try {
            connection = pooledConnection.getConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(this.validationQuery);
            bl = resultSet.next();
            if (this.rollbackAfterValidation) {
                connection.rollback();
            }
            Utils.closeQuietly(resultSet);
        }
        catch (Exception exception) {
            bl = false;
            return bl;
        }
        Utils.closeQuietly(statement);
        Utils.closeQuietly(connection);
        this.validatingSet.remove(pooledConnection);
        return bl;
        finally {
            Utils.closeQuietly(resultSet);
            Utils.closeQuietly(statement);
            Utils.closeQuietly(connection);
            this.validatingSet.remove(pooledConnection);
        }
    }

    @Override
    public void passivateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void activateObject(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        this.validateLifetime(pooledObject);
    }

    @Override
    public void connectionClosed(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (!this.validatingSet.contains(pooledConnection)) {
            PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
            if (pooledConnectionAndInfo == null) {
                throw new IllegalStateException(NO_KEY_MESSAGE);
            }
            try {
                this.pool.returnObject(pooledConnectionAndInfo);
            }
            catch (Exception exception) {
                System.err.println("CLOSING DOWN CONNECTION AS IT COULD NOT BE RETURNED TO THE POOL");
                pooledConnection.removeConnectionEventListener(this);
                try {
                    this.doDestroyObject(pooledConnectionAndInfo);
                }
                catch (Exception exception2) {
                    System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
                    exception2.printStackTrace();
                }
            }
        }
    }

    @Override
    public void connectionErrorOccurred(ConnectionEvent connectionEvent) {
        PooledConnection pooledConnection = (PooledConnection)connectionEvent.getSource();
        if (null != connectionEvent.getSQLException()) {
            System.err.println("CLOSING DOWN CONNECTION DUE TO INTERNAL ERROR (" + connectionEvent.getSQLException() + ")");
        }
        pooledConnection.removeConnectionEventListener(this);
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo);
        }
        catch (Exception exception) {
            System.err.println("EXCEPTION WHILE DESTROYING OBJECT " + pooledConnectionAndInfo);
            exception.printStackTrace();
        }
    }

    @Override
    public void invalidate(PooledConnection pooledConnection) throws SQLException {
        PooledConnectionAndInfo pooledConnectionAndInfo = this.pcMap.get(pooledConnection);
        if (pooledConnectionAndInfo == null) {
            throw new IllegalStateException(NO_KEY_MESSAGE);
        }
        try {
            this.pool.invalidateObject(pooledConnectionAndInfo);
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error invalidating connection", exception);
        }
    }

    public synchronized void setPassword(char[] cArray) {
        this.userPassword = Utils.clone(cArray);
    }

    @Override
    public synchronized void setPassword(String string) {
        this.userPassword = Utils.toCharArray(string);
    }

    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnLifetimeMillis = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePool(String string) throws SQLException {
        CPDSConnectionFactory cPDSConnectionFactory = this;
        synchronized (cPDSConnectionFactory) {
            if (string == null || !string.equals(this.userName)) {
                return;
            }
        }
        try {
            this.pool.close();
        }
        catch (Exception exception) {
            throw new SQLException("Error closing connection pool", exception);
        }
    }

    private void validateLifetime(PooledObject<PooledConnectionAndInfo> pooledObject) throws Exception {
        long l;
        if (this.maxConnLifetimeMillis > 0L && (l = System.currentTimeMillis() - pooledObject.getCreateTime()) > this.maxConnLifetimeMillis) {
            throw new Exception(Utils.getMessage("connectionFactory.lifetimeExceeded", l, this.maxConnLifetimeMillis));
        }
    }

    public synchronized String toString() {
        StringBuilder stringBuilder = new StringBuilder(super.toString());
        stringBuilder.append("[cpds=");
        stringBuilder.append(this.cpds);
        stringBuilder.append(", validationQuery=");
        stringBuilder.append(this.validationQuery);
        stringBuilder.append(", validationQueryTimeoutSeconds=");
        stringBuilder.append(this.validationQueryTimeoutSeconds);
        stringBuilder.append(", rollbackAfterValidation=");
        stringBuilder.append(this.rollbackAfterValidation);
        stringBuilder.append(", pool=");
        stringBuilder.append(this.pool);
        stringBuilder.append(", maxConnLifetimeMillis=");
        stringBuilder.append(this.maxConnLifetimeMillis);
        stringBuilder.append(", validatingSet=");
        stringBuilder.append(this.validatingSet);
        stringBuilder.append(", pcMap=");
        stringBuilder.append(this.pcMap);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

