/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.components.configuration.configurators;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.beans.PropertyDescriptor;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.sdedit.ui.components.configuration.Adjustable;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.components.configuration.Configurator;
import net.sf.sdedit.ui.components.configuration.DataObject;

public class NumberConfigurator<C extends DataObject>
extends Configurator<Integer, C>
implements ChangeListener {
    private static final long serialVersionUID = 5195045084014309318L;
    private JSpinner spinner;
    private int min;
    private int max;
    private JLabel label;

    public NumberConfigurator(Bean<C> bean, PropertyDescriptor property) {
        super(bean, property);
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        Adjustable adjustable = this.getProperty().getWriteMethod().getAnnotation(Adjustable.class);
        this.min = adjustable.min();
        this.max = adjustable.max();
        SpinnerNumberModel model = new SpinnerNumberModel(adjustable.min(), adjustable.min(), adjustable.max(), adjustable.step());
        this.spinner = new JSpinner(model);
        this.spinner.setPreferredSize(new Dimension(100, 20));
        this.spinner.addChangeListener(this);
        this.label = new JLabel(adjustable.info());
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
        this.add((Component)this.spinner, "West");
        this.add((Component)this.label, "Center");
    }

    @Override
    protected void refresh(Integer value) {
        if (value < this.min) {
            value = this.min;
        } else if (value > this.max) {
            value = this.max;
        }
        this.spinner.setValue(value);
    }

    @Override
    protected void _actionPerformed(ActionEvent e) {
        int value = (Integer)this.spinner.getValue();
        this.applyValue(value);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.actionPerformed(null);
    }

    @Override
    protected Integer getNullValue() {
        return this.getProperty().getWriteMethod().getAnnotation(Adjustable.class).dflt();
    }

    @Override
    protected void _setEnabled(boolean enabled) {
        this.spinner.setEnabled(enabled);
    }

    @Override
    public void focus() {
        this.spinner.requestFocusInWindow();
    }
}

