/**
 * penguins-eggs
 *
 * Kernel management utilities
 * Handle vmlinuz and initramfs detection across different distributions
 */
/**
 * Kernel utilities for managing vmlinuz and initramfs paths
 */
export default class Kernel {
    /**
     * Ricava path per vmlinuz
     *
     * @returns Path al file vmlinuz
     */
    static vmlinuz(kernel?: string): string;
    /**
     * cerca il path per initramfs/initrd nella directory /boot
     * se fallisce, prova la convenzione Arch
     *
     * @param kernel - Versione del kernel (es. '6.5.0-14-generic'). Se omessa, usa il kernel in esecuzione.
     * @returns Path al file initramfs.
     */
    static initramfs(kernel?: string): string;
    /**
     * ALL PRIVATE
     */
    /**
     * most of the distros:
     * debian, fedora, opensuse, rasberry
     */
    private static vmlinuzFromUname;
    /**
     * vmlinuxFromCmdline
     *
     * It's used mostly on Manjaro
     */
    private static vmlinuzFromCmdline;
}
