/**
 * ./src/components/partitions.tsx
 * penguins-eggs v.25.7.x / ecmascript 2020
 * author: Piero Proietti
 * email: piero.proietti@gmail.com
 * license: MIT
 */
import React from 'react';
import Title from './title.js';
import Steps from './steps.js';
import yaml from 'js-yaml';
import fs from 'fs';
import { InstallationMode } from '../classes/krill_enums.js';
import { Text, Box, Newline } from 'ink';
export default function Partitions({ installationDevice, installationMode, filesystemType, userSwapChoice, replacedPartition }) {
    let installer = 'krill';
    let productName = '';
    let version = '';
    let configRoot = '/etc/penguins-eggs.d/krill/';
    let calamaresRoot = '/etc/calamares/';
    let settingFileName = configRoot + 'settings.conf';
    let brandingFile = '';
    if (fs.existsSync(calamaresRoot + settingFileName)) {
        configRoot = calamaresRoot;
    }
    if (fs.existsSync(configRoot + settingFileName)) {
        const settings = yaml.load(fs.readFileSync(configRoot + 'settings.conf', 'utf-8'));
        const branding = settings.branding;
        brandingFile = configRoot + 'branding/' + branding + '/branding.desc';
        if (fs.existsSync(brandingFile)) {
            const calamares = yaml.load(fs.readFileSync(brandingFile, 'utf-8'));
            productName = calamares.string_product_name;
            version = calamares.string_product_version;
        }
    }
    /**
    * totale width=75
    * step width=15
    * finestra with=59
    */
    let bios = 'standard';
    if (fs.existsSync('/sys/firmware/efi/efivars')) {
        bios = 'UEFI';
    }
    let partitions = {};
    if (fs.existsSync(configRoot + 'modules/partition.conf')) {
        partitions = yaml.load(fs.readFileSync(configRoot + 'modules/partition.conf', 'utf-8'));
    }
    else {
        partitions.initialSwapChoice = 'small';
    }
    let message = '';
    if (installationMode === InstallationMode.Replace) {
        message = `replaced partition: ${replacedPartition}`;
    }
    else {
        message = `installation device: ${installationDevice}`;
    }
    return (React.createElement(React.Fragment, null,
        React.createElement(Title, null),
        React.createElement(Box, { width: 75, height: 11, borderStyle: "round", flexDirection: "column" },
            React.createElement(Box, { flexDirection: "column" },
                React.createElement(Box, { flexDirection: "row" },
                    React.createElement(Steps, { step: 4 }),
                    React.createElement(Box, { flexDirection: "column" }),
                    React.createElement(Box, { flexDirection: "column" },
                        React.createElement(Box, null,
                            React.createElement(Text, null, "BIOS: "),
                            React.createElement(Text, { color: "cyan" },
                                bios,
                                " "),
                            React.createElement(Text, null, "Installation device: "),
                            React.createElement(Text, { color: "cyan" }, installationDevice)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Installation mode: "),
                            React.createElement(Text, { color: "cyan" }, installationMode)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "Filesystem: "),
                            React.createElement(Text, { color: "cyan" }, filesystemType)),
                        React.createElement(Box, null,
                            React.createElement(Text, null, "User swap choice: "),
                            React.createElement(Text, { color: "cyan" }, userSwapChoice)),
                        React.createElement(Newline, null),
                        React.createElement(Box, { flexDirection: "row" },
                            React.createElement(Text, { underline: false }, "(*) "),
                            React.createElement(Box, { flexDirection: "column" },
                                React.createElement(Text, { backgroundColor: "red", color: "white" }, "this will erase all data currently present on the"),
                                React.createElement(Text, { backgroundColor: "red", color: "white" }, message)))))))));
}
