/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.impl;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.security.credential.AbstractCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.x509.X509Credential;
import org.slf4j.Logger;

public class KeyStoreX509CredentialAdapter
extends AbstractCredential
implements X509Credential {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(KeyStoreX509CredentialAdapter.class);
    @Nonnull
    private final KeyStore keyStore;
    @Nonnull
    private final String credentialAlias;
    @Nullable
    private final char[] keyPassword;

    public KeyStoreX509CredentialAdapter(@Nonnull @ParameterName(name="store") KeyStore store, @Nonnull @ParameterName(name="alias") String alias, @Nullable @ParameterName(name="password") char[] password) {
        this.keyStore = Constraint.isNotNull(store, "Keystore cannot be null");
        this.credentialAlias = Constraint.isNotNull(StringSupport.trimOrNull(alias), "Keystore alias cannot be null or empty");
        this.keyPassword = password;
    }

    @Override
    @Nullable
    public Collection<X509CRL> getCRLs() {
        return CollectionSupport.emptyList();
    }

    @Override
    @Nonnull
    public X509Certificate getEntityCertificate() {
        try {
            Certificate cert = this.keyStore.getCertificate(this.credentialAlias);
            if (cert instanceof X509Certificate) {
                X509Certificate c = (X509Certificate)cert;
                return c;
            }
            throw new KeyStoreException("Certificate entry was not an X509Certificate");
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Object)this.credentialAlias, (Object)e);
            throw new IllegalStateException("Error accessing certificate in keystore");
        }
    }

    @Override
    @Nonnull
    public Collection<X509Certificate> getEntityCertificateChain() {
        List<X509Certificate> certsCollection = CollectionSupport.emptyList();
        try {
            Certificate[] certs = this.keyStore.getCertificateChain(this.credentialAlias);
            if (certs != null) {
                certsCollection = new ArrayList<X509Certificate>(certs.length);
                for (Certificate cert : certs) {
                    certsCollection.add((X509Certificate)cert);
                }
            }
        }
        catch (KeyStoreException e) {
            this.log.error("Error accessing {} certificates in keystore", (Object)this.credentialAlias, (Object)e);
        }
        return certsCollection;
    }

    @Override
    @Nullable
    public PrivateKey getPrivateKey() {
        try {
            return (PrivateKey)this.keyStore.getKey(this.credentialAlias, this.keyPassword);
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            this.log.error("Error accessing {} private key in keystore", (Object)this.credentialAlias, (Object)e);
            return null;
        }
    }

    @Override
    @Nullable
    public PublicKey getPublicKey() {
        return this.getEntityCertificate().getPublicKey();
    }

    @Override
    @Nonnull
    public Class<? extends Credential> getCredentialType() {
        return X509Credential.class;
    }

    @Override
    public void setEntityId(@Nullable String newEntityID) {
        super.setEntityId(newEntityID);
    }

    @Override
    public void setUsageType(@Nonnull UsageType newUsageType) {
        super.setUsageType(newUsageType);
    }
}

