/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ElectLeadersResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractResponse;

public class ElectLeadersResponse
extends AbstractResponse {
    private final ElectLeadersResponseData data;

    public ElectLeadersResponse(ElectLeadersResponseData data) {
        super(ApiKeys.ELECT_LEADERS);
        this.data = data;
    }

    public ElectLeadersResponse(int throttleTimeMs, short errorCode, List<ElectLeadersResponseData.ReplicaElectionResult> electionResults, short version) {
        super(ApiKeys.ELECT_LEADERS);
        this.data = new ElectLeadersResponseData();
        this.data.setThrottleTimeMs(throttleTimeMs);
        if (version >= 1) {
            this.data.setErrorCode(errorCode);
        }
        this.data.setReplicaElectionResults(electionResults);
    }

    @Override
    public ElectLeadersResponseData data() {
        return this.data;
    }

    @Override
    public int throttleTimeMs() {
        return this.data.throttleTimeMs();
    }

    @Override
    public void maybeSetThrottleTimeMs(int throttleTimeMs) {
        this.data.setThrottleTimeMs(throttleTimeMs);
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        HashMap<Errors, Integer> counts = new HashMap<Errors, Integer>();
        ElectLeadersResponse.updateErrorCounts(counts, Errors.forCode(this.data.errorCode()));
        this.data.replicaElectionResults().forEach(result -> result.partitionResult().forEach(partitionResult -> ElectLeadersResponse.updateErrorCounts(counts, Errors.forCode(partitionResult.errorCode()))));
        return counts;
    }

    public static ElectLeadersResponse parse(ByteBuffer buffer, short version) {
        return new ElectLeadersResponse(new ElectLeadersResponseData(new ByteBufferAccessor(buffer), version));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return true;
    }

    public static Map<TopicPartition, Optional<Throwable>> electLeadersResult(ElectLeadersResponseData data) {
        HashMap<TopicPartition, Optional<Throwable>> map = new HashMap<TopicPartition, Optional<Throwable>>();
        for (ElectLeadersResponseData.ReplicaElectionResult topicResults : data.replicaElectionResults()) {
            for (ElectLeadersResponseData.PartitionResult partitionResult : topicResults.partitionResult()) {
                Optional<Object> value = Optional.empty();
                Errors error = Errors.forCode(partitionResult.errorCode());
                if (error != Errors.NONE) {
                    value = Optional.of(error.exception(partitionResult.errorMessage()));
                }
                map.put(new TopicPartition(topicResults.topic(), partitionResult.partitionId()), value);
            }
        }
        return map;
    }
}

