/*
 * Decompiled with CFR 0.152.
 */
package com.selectivem.collections;

import java.lang.reflect.Array;
import java.util.function.Function;

class GenericArrays {
    GenericArrays() {
    }

    static <E> E[] create(int size) {
        return new Object[size];
    }

    static <E> E[] extend(E[] old, int newSize) {
        E[] result = GenericArrays.create(newSize);
        System.arraycopy(old, 0, result, 0, old.length);
        return result;
    }

    static <E> Object[] copyAsObjectArray(E[] array) {
        Object[] result = new Object[array.length];
        System.arraycopy(array, 0, result, 0, array.length);
        return result;
    }

    static <E> Object[] copyAsObjectArray(E[] array, int newSize) {
        Object[] result = new Object[newSize];
        System.arraycopy(array, 0, result, 0, Math.min(array.length, newSize));
        return result;
    }

    static <E, T> T[] copyAsTypedArray(E[] source, T[] target) {
        T[] result = target.length >= source.length ? target : (Object[])Array.newInstance(target.getClass().getComponentType(), source.length);
        System.arraycopy(source, 0, result, 0, source.length);
        return result;
    }

    static <E, T> T[] copyAsTypedArray(E[] source, T[] target, int newSize) {
        T[] result = target.length >= newSize ? target : (Object[])Array.newInstance(target.getClass().getComponentType(), newSize);
        System.arraycopy(source, 0, result, 0, Math.min(source.length, newSize));
        return result;
    }

    static int indexOfNextNonNull(Object[] array, int start) {
        for (int i = start; i < array.length; ++i) {
            if (array[i] == null) continue;
            return i;
        }
        return -1;
    }

    static <V, V2> V2[] mapInPlace(V[] array, Function<V, V2> mappingFunction) {
        if (array == null) {
            return null;
        }
        V[] result = array;
        if (mappingFunction != null) {
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                result[i] = mappingFunction.apply(array[i]);
            }
        }
        return result;
    }
}

