/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.services.storage.model.StorageObject;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Objects;

public final class BlobId
implements Serializable {
    private static final long serialVersionUID = -6156002883225601925L;
    private final String bucket;
    private final String name;
    private final Long generation;

    private BlobId(String bucket, String name, Long generation) {
        this.bucket = bucket;
        this.name = name;
        this.generation = generation;
    }

    public String getBucket() {
        return this.bucket;
    }

    public String getName() {
        return this.name;
    }

    public Long getGeneration() {
        return this.generation;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucket", (Object)this.getBucket()).add("name", (Object)this.getName()).add("generation", (Object)this.getGeneration()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.bucket, this.name, this.generation);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(BlobId.class)) {
            return false;
        }
        BlobId other = (BlobId)obj;
        return Objects.equals(this.bucket, other.bucket) && Objects.equals(this.name, other.name) && Objects.equals(this.generation, other.generation);
    }

    StorageObject toPb() {
        StorageObject storageObject = new StorageObject();
        storageObject.setBucket(this.bucket);
        storageObject.setName(this.name);
        storageObject.setGeneration(this.generation);
        return storageObject;
    }

    public static BlobId of(String bucket, String name) {
        return new BlobId((String)Preconditions.checkNotNull((Object)bucket), (String)Preconditions.checkNotNull((Object)name), null);
    }

    public static BlobId of(String bucket, String name, Long generation) {
        return new BlobId((String)Preconditions.checkNotNull((Object)bucket), (String)Preconditions.checkNotNull((Object)name), generation);
    }

    static BlobId fromPb(StorageObject storageObject) {
        return BlobId.of(storageObject.getBucket(), storageObject.getName(), storageObject.getGeneration());
    }
}

