"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AggregateTerm = void 0;
var _explorer = require("../../../../common/constants/explorer");
var _node = require("../node");
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

class AggregateTerm extends _node.PPLNode {
  constructor(name, children, statsFunction, customLabel) {
    super(name, children);
    this.statsFunction = statsFunction;
    this.customLabel = customLabel;
  }
  getTokens() {
    return {
      function: this.statsFunction.getTokens(),
      [_explorer.CUSTOM_LABEL]: this[_explorer.CUSTOM_LABEL]
    };
  }
  toString() {
    if (this[_explorer.CUSTOM_LABEL]) {
      return `${this.statsFunction.toString()}${this[_explorer.CUSTOM_LABEL] ? ` as ${this[_explorer.CUSTOM_LABEL]}` : ''}`;
    }
    return `${this.statsFunction.toString()}`;
  }
}
exports.AggregateTerm = AggregateTerm;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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