/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.sql.Clob;
import java.sql.SQLException;
import org.hsqldb.HsqlException;
import org.hsqldb.SessionInterface;
import org.hsqldb.jdbc.JDBCResultSet;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.types.ClobDataID;
import org.hsqldb.types.ClobInputStream;

public class JDBCClobClient
implements Clob {
    ClobDataID originalClob;
    ClobDataID clob;
    SessionInterface session;
    int colIndex;
    private boolean isClosed;
    private boolean isWritable;
    JDBCResultSet resultSet;

    @Override
    public synchronized InputStream getAsciiStream() throws SQLException {
        this.checkClosed();
        return new InputStream(){
            private Reader reader;
            {
                this.reader = JDBCClobClient.this.clob.getCharacterStream(JDBCClobClient.this.session);
            }

            @Override
            public int read() throws IOException {
                int n = this.reader.read();
                if (n < 0) {
                    return -1;
                }
                if (n >= 256) {
                    if (Character.isHighSurrogate((char)n)) {
                        this.reader.read();
                    }
                    n = 63;
                }
                return n;
            }

            @Override
            public int read(byte[] byArray, int n, int n2) throws IOException {
                int n3;
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return 0;
                }
                int n4 = 0;
                for (int i = 0; i < n2 && (n3 = this.reader.read()) >= 0; ++i) {
                    if (n3 >= 256) {
                        if (Character.isHighSurrogate((char)n3)) {
                            this.reader.read();
                        }
                        n3 = 63;
                    }
                    byArray[n + i] = (byte)n3;
                    ++n4;
                }
                return n4 == 0 ? -1 : n4;
            }

            @Override
            public void close() throws IOException {
                try {
                    this.reader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public synchronized Reader getCharacterStream() throws SQLException {
        this.checkClosed();
        return new ClobInputStream(this.session, this.clob, 0L, this.length());
    }

    @Override
    public synchronized String getSubString(long l, int n) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, n)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.getSubString(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long length() throws SQLException {
        this.checkClosed();
        try {
            return this.clob.length(this.session);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(String string, long l) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        try {
            return this.clob.position(this.session, string, l - 1L);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized long position(Clob clob, long l) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(Long.MAX_VALUE, l - 1L, 0L)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (clob instanceof JDBCClobClient) {
            ClobDataID clobDataID = ((JDBCClobClient)clob).clob;
            try {
                return this.clob.position(this.session, clobDataID, l - 1L);
            }
            catch (HsqlException hsqlException) {
                throw JDBCUtil.sqlException(hsqlException);
            }
        }
        if (!JDBCClobClient.isInLimits(Integer.MAX_VALUE, 0L, clob.length())) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return this.position(clob.getSubString(1L, (int)clob.length()), l);
    }

    @Override
    public synchronized OutputStream setAsciiStream(final long l) throws SQLException {
        return new OutputStream(){
            Writer writer;
            {
                this.writer = JDBCClobClient.this.setCharacterStream(l);
            }

            @Override
            public void write(int n) throws IOException {
                this.writer.write(n & 0xFF);
            }

            @Override
            public void write(byte[] byArray, int n, int n2) throws IOException {
                if (byArray == null) {
                    throw new NullPointerException();
                }
                if (n < 0 || n2 < 0 || n2 > byArray.length - n) {
                    throw new IndexOutOfBoundsException();
                }
                if (n2 == 0) {
                    return;
                }
                char[] cArray = new char[n2];
                for (int i = 0; i < n2; ++i) {
                    cArray[i] = (char)byArray[n + i];
                }
                this.writer.write(cArray, 0, n2);
            }

            @Override
            public void close() throws IOException {
                this.writer.close();
            }
        };
    }

    @Override
    public synchronized Writer setCharacterStream(final long l) throws SQLException {
        this.checkClosed();
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        this.startUpdate();
        return new Writer(){
            private long m_clobPosition;
            private boolean m_closed;
            {
                this.m_clobPosition = l - 1L;
            }

            @Override
            public void write(char[] cArray, int n, int n2) throws IOException {
                this.checkClosed();
                JDBCClobClient.this.clob.setChars(JDBCClobClient.this.session, this.m_clobPosition, cArray, n, n2);
                this.m_clobPosition += (long)n2;
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                this.m_closed = true;
            }

            private void checkClosed() throws IOException {
                if (this.m_closed || JDBCClobClient.this.isClosed()) {
                    throw new IOException("The stream is closed");
                }
            }
        };
    }

    @Override
    public synchronized int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    @Override
    public synchronized int setString(long l, String string, int n, int n2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(string.length(), n, n2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        if (l < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l);
        }
        if (!this.isWritable) {
            throw JDBCUtil.notUpdatableColumn();
        }
        try {
            this.startUpdate();
            string = string.substring(n, n + n2);
            this.clob.setString(this.session, l - 1L, string);
            return n2;
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void truncate(long l) throws SQLException {
        this.checkClosed();
        if (l < 0L) {
            throw JDBCUtil.outOfRangeArgument("len: " + l);
        }
        try {
            this.clob.truncate(this.session, l);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    @Override
    public synchronized void free() throws SQLException {
        this.isClosed = true;
        this.clob = null;
        this.session = null;
    }

    @Override
    public synchronized Reader getCharacterStream(long l, long l2) throws SQLException {
        this.checkClosed();
        if (!JDBCClobClient.isInLimits(this.length(), l - 1L, l2)) {
            throw JDBCUtil.outOfRangeArgument();
        }
        return new ClobInputStream(this.session, this.clob, l - 1L, l2);
    }

    char[] getChars(long l, int n) throws SQLException {
        try {
            return this.clob.getChars(this.session, l - 1L, n);
        }
        catch (HsqlException hsqlException) {
            throw JDBCUtil.sqlException(hsqlException);
        }
    }

    public JDBCClobClient(SessionInterface sessionInterface, ClobDataID clobDataID) {
        this.session = sessionInterface;
        this.clob = clobDataID;
    }

    public ClobDataID getClob() {
        return this.clob;
    }

    public synchronized boolean isClosed() {
        return this.isClosed;
    }

    public synchronized void setWritable(JDBCResultSet jDBCResultSet, int n) {
        this.isWritable = true;
        this.resultSet = jDBCResultSet;
        this.colIndex = n;
    }

    public synchronized void clearUpdates() {
        if (this.originalClob != null) {
            this.clob = this.originalClob;
            this.originalClob = null;
        }
    }

    private void startUpdate() throws SQLException {
        if (this.originalClob != null) {
            return;
        }
        this.originalClob = this.clob;
        this.clob = (ClobDataID)this.clob.duplicate(this.session);
        this.resultSet.startUpdate(this.colIndex + 1);
        this.resultSet.preparedStatement.parameterValues[this.colIndex] = this.clob;
        this.resultSet.preparedStatement.parameterSet[this.colIndex] = true;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw JDBCUtil.sqlException(1852);
        }
    }

    static boolean isInLimits(long l, long l2, long l3) {
        return l >= 0L && l2 >= 0L && l3 >= 0L && l2 <= l - l3;
    }
}

