/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.jdbc.oracle;

import java.util.Date;
import oracle.ucp.UniversalConnectionPoolException;
import oracle.ucp.jdbc.oracle.OracleFailoverEvent;
import oracle.ucp.util.UCPErrorHandler;

public class OracleFailoverEventImpl
implements OracleFailoverEvent {
    private String m_serviceName = null;
    private String m_instanceName = null;
    private String m_dbUniqueName = null;
    private String m_hostName = null;
    private String m_dbDomainName = null;
    private String m_status = null;
    private int m_cardinality = 0;
    private String m_reason = null;
    private String m_eventType;
    private Date m_timestamp = null;
    private String m_timezone = null;
    private boolean m_isValid = true;
    private int m_drainTimeout = 0;

    public OracleFailoverEventImpl(String eventType) throws UniversalConnectionPoolException {
        this.setEventType(eventType);
    }

    private void validateEventType(String eventType) throws UniversalConnectionPoolException {
        if (eventType == null) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(304);
        }
        if (!eventType.equals("database/event/host") && !eventType.equals("database/event/service")) {
            throw UCPErrorHandler.newUniversalConnectionPoolException(305);
        }
    }

    @Override
    public String getServiceName() {
        return this.m_serviceName;
    }

    public void setServiceName(String serviceName) {
        this.m_serviceName = serviceName;
    }

    @Override
    public String getInstanceName() {
        return this.m_instanceName;
    }

    public void setInstanceName(String instanceName) {
        this.m_instanceName = instanceName;
    }

    @Override
    public String getDbUniqueName() {
        return this.m_dbUniqueName;
    }

    public void setDbUniqueName(String dbUniqueName) {
        this.m_dbUniqueName = dbUniqueName;
    }

    @Override
    public String getHostName() {
        return this.m_hostName;
    }

    public void setHostName(String hostName) {
        this.m_hostName = hostName;
    }

    @Override
    public String getDbDomainName() {
        return this.m_dbDomainName;
    }

    public void setDbDomainName(String domainName) {
        this.m_dbDomainName = domainName;
    }

    @Override
    public String getStatus() {
        return this.m_status;
    }

    public void setStatus(String status) {
        this.m_status = status;
    }

    @Override
    public int getCardinality() {
        return this.m_cardinality;
    }

    public void setCardinality(int cardinality) {
        this.m_cardinality = cardinality;
    }

    @Override
    public String getReason() {
        return this.m_reason;
    }

    public void setReason(String reason) {
        this.m_reason = reason;
    }

    @Override
    public String getEventType() {
        return this.m_eventType;
    }

    public void setEventType(String eventType) throws UniversalConnectionPoolException {
        this.validateEventType(eventType);
        this.m_eventType = eventType;
    }

    @Override
    public long getTimestamp() {
        return this.m_timestamp != null ? this.m_timestamp.getTime() : -1L;
    }

    public void setTimestamp(Date ts) {
        this.m_timestamp = ts;
    }

    @Override
    public String getTimeZone() {
        return this.m_timezone;
    }

    public void setTimeZone(String timezone) {
        this.m_timezone = timezone;
    }

    @Override
    public boolean isValid() {
        return this.m_isValid;
    }

    public void setValidity(boolean isValid) {
        this.m_isValid = isValid;
    }

    @Override
    public int getDrainTimeout() {
        return this.m_drainTimeout;
    }

    void setDrainTimeout(int drainTimeout) {
        this.m_drainTimeout = drainTimeout;
    }

    public String toString() {
        return "Service name: " + this.m_serviceName + ", Instance name: " + this.m_instanceName + ", Unique name: " + this.m_dbUniqueName + ", Host name: " + this.m_hostName + ", Domain name: " + this.m_dbDomainName + ", Status: " + this.m_status + ", Cardinality: " + this.m_cardinality + ", Reason: " + this.m_reason + ", Drain timeout: " + this.m_drainTimeout + ", Event type: " + this.m_eventType + ", Timestamp: " + this.m_timestamp + ", Is Valid: " + this.m_isValid;
    }
}

