/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.converter;

import com.jidesoft.converter.ArrayConverter;
import com.jidesoft.converter.ConverterContext;
import java.awt.Rectangle;

public class RectangleConverter
extends ArrayConverter {
    RectangleConverter() {
        super("; ", 4, Integer.class);
    }

    @Override
    public String toString(Object object, ConverterContext context) {
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            return this.arrayToString(new Object[]{rectangle.x, rectangle.y, rectangle.width, rectangle.height}, context);
        }
        return "";
    }

    @Override
    public boolean supportToString(Object object, ConverterContext context) {
        return true;
    }

    @Override
    public Object fromString(String string, ConverterContext context) {
        if (string == null || string.trim().length() == 0) {
            return null;
        }
        Object[] objects = this.arrayFromString(string, context);
        int x = 0;
        int y = 0;
        int w = 0;
        int h2 = 0;
        if (objects.length >= 1 && objects[0] instanceof Integer) {
            x = (Integer)objects[0];
        }
        if (objects.length >= 2 && objects[1] instanceof Integer) {
            y = (Integer)objects[1];
        }
        if (objects.length >= 3 && objects[2] instanceof Integer) {
            w = (Integer)objects[2];
        }
        if (objects.length >= 4 && objects[3] instanceof Integer) {
            h2 = (Integer)objects[3];
        }
        return new Rectangle(x, y, w, h2);
    }

    @Override
    public boolean supportFromString(String string, ConverterContext context) {
        return true;
    }
}

