/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Threshold an image using the Yen Threshold.


This filter creates a binary thresholded image that separates an image
into foreground and background components. The filter computes the
threshold using the YenThresholdCalculator and applies that threshold to the input image using the BinaryThresholdImageFilter .


Richard Beare

Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.
 This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/efycla


See:
 HistogramThresholdImageFilter

 itk::simple::YenThreshold for the procedural interface

 itk::YenThresholdImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkYenThresholdImageFilter.h
*/
public class YenThresholdImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected YenThresholdImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.YenThresholdImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(YenThresholdImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(YenThresholdImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::YenThresholdImageFilter::~YenThresholdImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_YenThresholdImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::YenThresholdImageFilter::YenThresholdImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  YenThresholdImageFilter() {
    this(SimpleITKJNI.new_YenThresholdImageFilter(), true);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::SetInsideValue(uint8_t InsideValue)

Set the "inside" pixel value.

*/
public  void setInsideValue(short InsideValue) {
    SimpleITKJNI.YenThresholdImageFilter_setInsideValue(swigCPtr, this, InsideValue);
  }

  /**
uint8_t itk::simple::YenThresholdImageFilter::GetInsideValue() const

Get the "inside" pixel value.

*/
public  short getInsideValue() {
    return SimpleITKJNI.YenThresholdImageFilter_getInsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::SetOutsideValue(uint8_t OutsideValue)

Set the "outside" pixel value. The default value NumericTraits&lt;OutputPixelType&gt;::Zero.

*/
public  void setOutsideValue(short OutsideValue) {
    SimpleITKJNI.YenThresholdImageFilter_setOutsideValue(swigCPtr, this, OutsideValue);
  }

  /**
uint8_t itk::simple::YenThresholdImageFilter::GetOutsideValue() const

Get the "outside" pixel value.

*/
public  short getOutsideValue() {
    return SimpleITKJNI.YenThresholdImageFilter_getOutsideValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::SetNumberOfHistogramBins(uint32_t NumberOfHistogramBins)

Set/Get the number of histogram bins.

*/
public  void setNumberOfHistogramBins(long NumberOfHistogramBins) {
    SimpleITKJNI.YenThresholdImageFilter_setNumberOfHistogramBins(swigCPtr, this, NumberOfHistogramBins);
  }

  /**
uint32_t itk::simple::YenThresholdImageFilter::GetNumberOfHistogramBins() const
*/
public  long getNumberOfHistogramBins() {
    return SimpleITKJNI.YenThresholdImageFilter_getNumberOfHistogramBins(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::SetMaskOutput(bool MaskOutput)

Do you want the output to be masked by the mask used in histogram
construction. Only relevant if masking is in use.

*/
public  void setMaskOutput(boolean MaskOutput) {
    SimpleITKJNI.YenThresholdImageFilter_setMaskOutput(swigCPtr, this, MaskOutput);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::MaskOutputOn()

Set the value of MaskOutput to true or false respectfully.

*/
public  void maskOutputOn() {
    SimpleITKJNI.YenThresholdImageFilter_maskOutputOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::MaskOutputOff()
*/
public  void maskOutputOff() {
    SimpleITKJNI.YenThresholdImageFilter_maskOutputOff(swigCPtr, this);
  }

  /**
bool itk::simple::YenThresholdImageFilter::GetMaskOutput() const
*/
public  boolean getMaskOutput() {
    return SimpleITKJNI.YenThresholdImageFilter_getMaskOutput(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::YenThresholdImageFilter::SetMaskValue(uint8_t MaskValue)

The value in the mask image, if used, indicating voxels that should be
included. Default is the max of pixel type, as in the
MaskedImageToHistogramFilter

*/
public  void setMaskValue(short MaskValue) {
    SimpleITKJNI.YenThresholdImageFilter_setMaskValue(swigCPtr, this, MaskValue);
  }

  /**
uint8_t itk::simple::YenThresholdImageFilter::GetMaskValue() const
*/
public  short getMaskValue() {
    return SimpleITKJNI.YenThresholdImageFilter_getMaskValue(swigCPtr, this);
  }

  /**
double itk::simple::YenThresholdImageFilter::GetThreshold() const

Get the computed threshold.


This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  double getThreshold() {
    return SimpleITKJNI.YenThresholdImageFilter_getThreshold(swigCPtr, this);
  }

  /**
std::string itk::simple::YenThresholdImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.YenThresholdImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::YenThresholdImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.YenThresholdImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::YenThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image, Image maskImage) {
    return new Image(SimpleITKJNI.YenThresholdImageFilter_execute__SWIG_0(swigCPtr, this, Image.getCPtr(image), image, Image.getCPtr(maskImage), maskImage), true);
  }

  /**
Image itk::simple::YenThresholdImageFilter::Execute(const Image &amp;image, const Image &amp;maskImage)

Execute the filter on the input image

*/
public  Image execute(Image image) {
    return new Image(SimpleITKJNI.YenThresholdImageFilter_execute__SWIG_1(swigCPtr, this, Image.getCPtr(image), image), true);
  }

}
