/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

The Wiener deconvolution image filter is designed to restore an image
convolved with a blurring kernel while keeping noise enhancement to a
minimum.


The Wiener filter aims to minimize noise enhancement induced by
frequencies with low signal-to-noise ratio. The Wiener filter kernel
is defined in the frequency domain as $W(\\omega) = H^*(\\omega) / (|H(\\omega)|^2 + (1 /
SNR(\\omega)))$ where $H(\\omega)$ is the Fourier transform of the blurring kernel with which the
original image was convolved and the signal-to-noise ratio $SNR(\\omega)$ . $SNR(\\omega)$ is defined by $P_f(\\omega) / P_n(\\omega)$ where $P_f(\\omega)$ is the power spectral density of the uncorrupted signal and $P_n(\\omega)$ is the power spectral density of the noise. When applied to the input
blurred image, this filter produces an estimate $\\hat{f}(x)$ of the true underlying signal $f(x)$ that minimizes the expected error between $\\hat{f}(x)$ and $f(x)$ .

This filter requires two inputs, the image to be deconvolved and the
blurring kernel. These two inputs can be set using the methods
SetInput() and SetKernelImage(), respectively.

The power spectral densities of the signal and noise are typically
unavailable for a given problem. In particular, $P_f(\\omega)$ cannot be computed from $f(x)$ because this unknown signal is precisely the signal that this filter
aims to recover. Nevertheless, it is common for the noise to have a
power spectral density that is flat or decreasing significantly more
slowly than the power spectral density of a typical image as the
frequency $\\omega$ increases. Hence, $P_n(\\omega)$ can typically be approximated with a constant, and this filter makes
this assumption (see the NoiseVariance member variable). $P_f(\\omega)$ , on the other hand, will vary with input. This filter computes the
power spectral density of the input blurred image, subtracts the power
spectral density of the noise, and uses the result as the estimate of $P_f(\\omega)$ .

For further information on the Wiener deconvolution filter, please see
"Digital Signal Processing" by Kenneth R. Castleman, Prentice Hall,
1995


Gaetan Lehmann, Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France

Chris Mullins, The University of North Carolina at Chapel Hill

Cory Quammen, The University of North Carolina at Chapel Hill

See:
 itk::simple::WienerDeconvolution for the procedural interface

 itk::WienerDeconvolutionImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkWienerDeconvolutionImageFilter.h
*/
public class WienerDeconvolutionImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected WienerDeconvolutionImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.WienerDeconvolutionImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(WienerDeconvolutionImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(WienerDeconvolutionImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::WienerDeconvolutionImageFilter::~WienerDeconvolutionImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_WienerDeconvolutionImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::WienerDeconvolutionImageFilter::WienerDeconvolutionImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  WienerDeconvolutionImageFilter() {
    this(SimpleITKJNI.new_WienerDeconvolutionImageFilter(), true);
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::SetNoiseVariance(double NoiseVariance)

Set/get the variance of the zero-mean Gaussian white noise assumed to
be added to the input.

*/
public  void setNoiseVariance(double NoiseVariance) {
    SimpleITKJNI.WienerDeconvolutionImageFilter_setNoiseVariance(swigCPtr, this, NoiseVariance);
  }

  /**
double itk::simple::WienerDeconvolutionImageFilter::GetNoiseVariance() const

Set/get the variance of the zero-mean Gaussian white noise assumed to
be added to the input.

*/
public  double getNoiseVariance() {
    return SimpleITKJNI.WienerDeconvolutionImageFilter_getNoiseVariance(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::SetNormalize(bool Normalize)

Normalize the output image by the sum of the kernel components

*/
public  void setNormalize(boolean Normalize) {
    SimpleITKJNI.WienerDeconvolutionImageFilter_setNormalize(swigCPtr, this, Normalize);
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::NormalizeOn()

Set the value of Normalize to true or false respectfully.

*/
public  void normalizeOn() {
    SimpleITKJNI.WienerDeconvolutionImageFilter_normalizeOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::NormalizeOff()
*/
public  void normalizeOff() {
    SimpleITKJNI.WienerDeconvolutionImageFilter_normalizeOff(swigCPtr, this);
  }

  /**
bool itk::simple::WienerDeconvolutionImageFilter::GetNormalize() const
*/
public  boolean getNormalize() {
    return SimpleITKJNI.WienerDeconvolutionImageFilter_getNormalize(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::SetBoundaryCondition(BoundaryConditionType BoundaryCondition)
*/
public  void setBoundaryCondition(WienerDeconvolutionImageFilter.BoundaryConditionType BoundaryCondition) {
    SimpleITKJNI.WienerDeconvolutionImageFilter_setBoundaryCondition(swigCPtr, this, BoundaryCondition.swigValue());
  }

  /**
BoundaryConditionType itk::simple::WienerDeconvolutionImageFilter::GetBoundaryCondition() const
*/
public  WienerDeconvolutionImageFilter.BoundaryConditionType getBoundaryCondition() {
    return WienerDeconvolutionImageFilter.BoundaryConditionType.swigToEnum(SimpleITKJNI.WienerDeconvolutionImageFilter_getBoundaryCondition(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::WienerDeconvolutionImageFilter::SetOutputRegionMode(OutputRegionModeType OutputRegionMode)
*/
public  void setOutputRegionMode(WienerDeconvolutionImageFilter.OutputRegionModeType OutputRegionMode) {
    SimpleITKJNI.WienerDeconvolutionImageFilter_setOutputRegionMode(swigCPtr, this, OutputRegionMode.swigValue());
  }

  /**
OutputRegionModeType itk::simple::WienerDeconvolutionImageFilter::GetOutputRegionMode() const
*/
public  WienerDeconvolutionImageFilter.OutputRegionModeType getOutputRegionMode() {
    return WienerDeconvolutionImageFilter.OutputRegionModeType.swigToEnum(SimpleITKJNI.WienerDeconvolutionImageFilter_getOutputRegionMode(swigCPtr, this));
  }

  /**
std::string itk::simple::WienerDeconvolutionImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.WienerDeconvolutionImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::WienerDeconvolutionImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.WienerDeconvolutionImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::WienerDeconvolutionImageFilter::Execute(const Image &amp;image1, const Image &amp;image2)

Execute the filter on the input images

*/
public  Image execute(Image image1, Image image2) {
    return new Image(SimpleITKJNI.WienerDeconvolutionImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1, Image.getCPtr(image2), image2), true);
  }

  public final static class BoundaryConditionType {
    public final static WienerDeconvolutionImageFilter.BoundaryConditionType ZERO_PAD = new WienerDeconvolutionImageFilter.BoundaryConditionType("ZERO_PAD");
    public final static WienerDeconvolutionImageFilter.BoundaryConditionType ZERO_FLUX_NEUMANN_PAD = new WienerDeconvolutionImageFilter.BoundaryConditionType("ZERO_FLUX_NEUMANN_PAD");
    public final static WienerDeconvolutionImageFilter.BoundaryConditionType PERIODIC_PAD = new WienerDeconvolutionImageFilter.BoundaryConditionType("PERIODIC_PAD");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static BoundaryConditionType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + BoundaryConditionType.class + " with value " + swigValue);
    }

    private BoundaryConditionType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private BoundaryConditionType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private BoundaryConditionType(String swigName, BoundaryConditionType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static BoundaryConditionType[] swigValues = { ZERO_PAD, ZERO_FLUX_NEUMANN_PAD, PERIODIC_PAD };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

  public final static class OutputRegionModeType {
    public final static WienerDeconvolutionImageFilter.OutputRegionModeType SAME = new WienerDeconvolutionImageFilter.OutputRegionModeType("SAME");
    public final static WienerDeconvolutionImageFilter.OutputRegionModeType VALID = new WienerDeconvolutionImageFilter.OutputRegionModeType("VALID");

    public final int swigValue() {
      return swigValue;
    }

    public String toString() {
      return swigName;
    }

    public static OutputRegionModeType swigToEnum(int swigValue) {
      if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue)
        return swigValues[swigValue];
      for (int i = 0; i < swigValues.length; i++)
        if (swigValues[i].swigValue == swigValue)
          return swigValues[i];
      throw new IllegalArgumentException("No enum " + OutputRegionModeType.class + " with value " + swigValue);
    }

    private OutputRegionModeType(String swigName) {
      this.swigName = swigName;
      this.swigValue = swigNext++;
    }

    private OutputRegionModeType(String swigName, int swigValue) {
      this.swigName = swigName;
      this.swigValue = swigValue;
      swigNext = swigValue+1;
    }

    private OutputRegionModeType(String swigName, OutputRegionModeType swigEnum) {
      this.swigName = swigName;
      this.swigValue = swigEnum.swigValue;
      swigNext = this.swigValue+1;
    }

    private static OutputRegionModeType[] swigValues = { SAME, VALID };
    private static int swigNext = 0;
    private final int swigValue;
    private final String swigName;
  }

}
