/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Applies a linear transformation to the intensity levels of the input Image that are inside a user-defined interval. Values below this interval
are mapped to a constant. Values over the interval are mapped to
another constant.


IntensityWindowingImageFilter applies pixel-wise a linear transformation to the intensity values of
input image pixels. The linear transformation is defined by the user
in terms of the minimum and maximum values that the output image
should have and the lower and upper limits of the intensity window of
the input image. This operation is very common in visualization, and
can also be applied as a convenient preprocessing operation for image
segmentation.

All computations are performed in the precision of the input pixel's
RealType. Before assigning the computed value to the output pixel.


See:
 RescaleIntensityImageFilter

 itk::simple::IntensityWindowing for the procedural interface

 itk::IntensityWindowingImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkIntensityWindowingImageFilter.h
*/
public class IntensityWindowingImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected IntensityWindowingImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.IntensityWindowingImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(IntensityWindowingImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(IntensityWindowingImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::IntensityWindowingImageFilter::~IntensityWindowingImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_IntensityWindowingImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::IntensityWindowingImageFilter::IntensityWindowingImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  IntensityWindowingImageFilter() {
    this(SimpleITKJNI.new_IntensityWindowingImageFilter(), true);
  }

  /**
Self&amp; itk::simple::IntensityWindowingImageFilter::SetWindowMinimum(double WindowMinimum)

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public  void setWindowMinimum(double WindowMinimum) {
    SimpleITKJNI.IntensityWindowingImageFilter_setWindowMinimum(swigCPtr, this, WindowMinimum);
  }

  /**
double itk::simple::IntensityWindowingImageFilter::GetWindowMinimum() const

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public  double getWindowMinimum() {
    return SimpleITKJNI.IntensityWindowingImageFilter_getWindowMinimum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IntensityWindowingImageFilter::SetWindowMaximum(double WindowMaximum)

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public  void setWindowMaximum(double WindowMaximum) {
    SimpleITKJNI.IntensityWindowingImageFilter_setWindowMaximum(swigCPtr, this, WindowMaximum);
  }

  /**
double itk::simple::IntensityWindowingImageFilter::GetWindowMaximum() const

Set/Get the values of the maximum and minimum intensities of the input
intensity window.

*/
public  double getWindowMaximum() {
    return SimpleITKJNI.IntensityWindowingImageFilter_getWindowMaximum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IntensityWindowingImageFilter::SetOutputMinimum(double OutputMinimum)

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public  void setOutputMinimum(double OutputMinimum) {
    SimpleITKJNI.IntensityWindowingImageFilter_setOutputMinimum(swigCPtr, this, OutputMinimum);
  }

  /**
double itk::simple::IntensityWindowingImageFilter::GetOutputMinimum() const

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public  double getOutputMinimum() {
    return SimpleITKJNI.IntensityWindowingImageFilter_getOutputMinimum(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::IntensityWindowingImageFilter::SetOutputMaximum(double OutputMaximum)

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public  void setOutputMaximum(double OutputMaximum) {
    SimpleITKJNI.IntensityWindowingImageFilter_setOutputMaximum(swigCPtr, this, OutputMaximum);
  }

  /**
double itk::simple::IntensityWindowingImageFilter::GetOutputMaximum() const

Set/Get the values of the maximum and minimum intensities of the
output image.

*/
public  double getOutputMaximum() {
    return SimpleITKJNI.IntensityWindowingImageFilter_getOutputMaximum(swigCPtr, this);
  }

  /**
std::string itk::simple::IntensityWindowingImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.IntensityWindowingImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::IntensityWindowingImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.IntensityWindowingImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::IntensityWindowingImageFilter::Execute(Image &amp;&amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.IntensityWindowingImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
