/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.media;

import tim.prune.App;
import tim.prune.GenericFunction;
import tim.prune.I18nManager;
import tim.prune.cmd.ConnectMediaCmd;
import tim.prune.data.AudioClip;
import tim.prune.data.DataPoint;
import tim.prune.data.Photo;

public class ConnectToPointFunction
extends GenericFunction {
    public ConnectToPointFunction(App app) {
        super(app);
    }

    @Override
    public String getNameKey() {
        return "function.connecttopoint";
    }

    @Override
    public void begin() {
        DataPoint dataPoint = this._app.getTrackInfo().getCurrentPoint();
        Photo photo = this._app.getTrackInfo().getCurrentPhoto();
        AudioClip audioClip = this._app.getTrackInfo().getCurrentAudio();
        ConnectMediaCmd connectMediaCmd = new ConnectMediaCmd(dataPoint, photo, audioClip);
        connectMediaCmd.setDescription(this.getDescription(photo, audioClip));
        connectMediaCmd.setConfirmText(I18nManager.getText("confirm.media.connect"));
        this._app.execute(connectMediaCmd);
    }

    public String getDescription(Photo photo, AudioClip audioClip) {
        String string = photo == null ? null : photo.getName();
        String string2 = audioClip == null ? null : audioClip.getName();
        return I18nManager.getText("undo.connect", String.valueOf(this.denull(string)) + (string != null && string2 != null ? ", " : "") + this.denull(string2));
    }

    private String denull(String string) {
        return string == null ? "" : string;
    }
}

