/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.ui.exporter.plugin;

import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import org.gephi.io.exporter.plugin.ExporterSpreadsheet;
import org.gephi.io.exporter.spi.Exporter;
import org.gephi.io.exporter.spi.ExporterUI;
import org.gephi.ui.exporter.plugin.AbstractExporterSettings;
import org.gephi.ui.exporter.plugin.UIExporterSpreadsheetPanel;
import org.openide.util.NbBundle;

public class UIExporterSpreadsheet
implements ExporterUI {
    private final ExporterSpreadsheetSettings settings = new ExporterSpreadsheetSettings();
    private UIExporterSpreadsheetPanel panel;
    private ExporterSpreadsheet exporterSpreadsheet;

    public void setup(Exporter exporter) {
        this.exporterSpreadsheet = (ExporterSpreadsheet)exporter;
        this.settings.load(this.exporterSpreadsheet);
        if (this.panel != null) {
            this.panel.setup(this.exporterSpreadsheet);
        }
    }

    public void unsetup(boolean update) {
        if (update) {
            this.panel.unsetup(this.exporterSpreadsheet);
            this.settings.save(this.exporterSpreadsheet);
        }
        this.panel = null;
        this.exporterSpreadsheet = null;
    }

    public JPanel getPanel() {
        this.panel = new UIExporterSpreadsheetPanel();
        return this.panel;
    }

    public boolean isUIForExporter(Exporter exporter) {
        return exporter instanceof ExporterSpreadsheet;
    }

    public String getDisplayName() {
        return NbBundle.getMessage(UIExporterSpreadsheet.class, (String)"UIExporterSpreadsheet.name");
    }

    private static class ExporterSpreadsheetSettings
    extends AbstractExporterSettings {
        private static final String NORMALIZE = "Spreadsheet_normalize";
        private static final String EXPORT_COLORS = "Spreadsheet_exportColors";
        private static final String EXPORT_POSITION = "Spreadsheet_exportPosition";
        private static final String EXPORT_ATTRIBUTES = "Spreadsheet_exportAttributes";
        private static final String EXPORT_SIZE = "Spreadsheet_exportSize";
        private static final String EXPORT_DYNAMICS = "Spreadsheet_exportDynamics";
        private static final String SEPARATOR = "Spreadsheet_separator";
        private static final String DECIMAL_SEPARATOR = "Spreadsheet_decimalSeparator";
        private static final String TABLE = "Spreadsheet_table";
        private static final String EXCLUDED_NODE_COLUMNS = "Spreadsheet_excludedNodeColumns";
        private static final String EXCLUDED_EDGE_COLUMNS = "Spreadsheet_excludedEdgeColumns";
        private static final ExporterSpreadsheet DEFAULT = new ExporterSpreadsheet();

        private ExporterSpreadsheetSettings() {
        }

        private void save(ExporterSpreadsheet exporterSpreadsheet) {
            this.put(NORMALIZE, exporterSpreadsheet.isNormalize());
            this.put(EXPORT_COLORS, exporterSpreadsheet.isExportColors());
            this.put(EXPORT_POSITION, exporterSpreadsheet.isExportPosition());
            this.put(EXPORT_SIZE, exporterSpreadsheet.isExportSize());
            this.put(EXPORT_ATTRIBUTES, exporterSpreadsheet.isExportAttributes());
            this.put(EXPORT_DYNAMICS, exporterSpreadsheet.isExportDynamic());
            this.put(SEPARATOR, exporterSpreadsheet.getFieldDelimiter());
            this.put(TABLE, exporterSpreadsheet.getTableToExport().name());
            this.put(DECIMAL_SEPARATOR, exporterSpreadsheet.getDecimalFormatSymbols().getDecimalSeparator());
            if (exporterSpreadsheet.getTableToExport().equals((Object)ExporterSpreadsheet.ExportTable.NODES)) {
                this.put(EXCLUDED_NODE_COLUMNS, exporterSpreadsheet.getExcludedColumns().toArray(new String[0]));
            } else {
                this.put(EXCLUDED_EDGE_COLUMNS, exporterSpreadsheet.getExcludedColumns().toArray(new String[0]));
            }
        }

        private void load(ExporterSpreadsheet exporterSpreadsheet) {
            exporterSpreadsheet.setNormalize(this.get(NORMALIZE, DEFAULT.isNormalize()));
            exporterSpreadsheet.setExportColors(this.get(EXPORT_COLORS, DEFAULT.isExportColors()));
            exporterSpreadsheet.setExportAttributes(this.get(EXPORT_ATTRIBUTES, DEFAULT.isExportAttributes()));
            exporterSpreadsheet.setExportPosition(this.get(EXPORT_POSITION, DEFAULT.isExportPosition()));
            exporterSpreadsheet.setExportSize(this.get(EXPORT_SIZE, DEFAULT.isExportSize()));
            exporterSpreadsheet.setExportDynamic(this.get(EXPORT_DYNAMICS, DEFAULT.isExportDynamic()));
            exporterSpreadsheet.setFieldDelimiter(this.get(SEPARATOR, DEFAULT.getFieldDelimiter()));
            exporterSpreadsheet.setTableToExport(ExporterSpreadsheet.ExportTable.valueOf((String)this.get(TABLE, DEFAULT.getTableToExport().name())));
            DecimalFormatSymbols dfs = exporterSpreadsheet.getDecimalFormatSymbols();
            dfs.setDecimalSeparator(this.get(DECIMAL_SEPARATOR, DEFAULT.getDecimalFormatSymbols().getDecimalSeparator()));
            if (exporterSpreadsheet.getTableToExport().equals((Object)ExporterSpreadsheet.ExportTable.NODES)) {
                exporterSpreadsheet.setExcludedColumns(Arrays.stream(this.get(EXCLUDED_NODE_COLUMNS, DEFAULT.getExcludedColumns().toArray(new String[0]))).collect(Collectors.toSet()));
            } else {
                exporterSpreadsheet.setExcludedColumns(Arrays.stream(this.get(EXCLUDED_EDGE_COLUMNS, DEFAULT.getExcludedColumns().toArray(new String[0]))).collect(Collectors.toSet()));
            }
        }
    }
}

