/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.visualization.options;

import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.text.NumberFormatter;
import org.gephi.visualization.VizController;
import org.gephi.visualization.apiimpl.VizConfig;
import org.gephi.visualization.opengl.GraphicalConfiguration;
import org.gephi.visualization.options.OpenGLOptionsPanelController;
import org.jdesktop.swingx.JXTitledSeparator;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

final class OpenGLPanel
extends JPanel {
    private final OpenGLOptionsPanelController controller;
    private int antiAliasing = 0;
    private JComboBox antialisaingCombobox;
    private JCheckBox fpsCheckbox;
    private JXTitledSeparator jXTitledSeparator1;
    private JLabel labelAntialiasing;
    private JLabel labelShow;
    private JLabel labelOctreeWidth;
    private JTextArea openInfoText;
    private JPanel openglInfoPanel;
    private JButton resetButton;
    private JFormattedTextField octreeWidthTextField;

    OpenGLPanel(OpenGLOptionsPanelController controller) {
        this.controller = controller;
        this.initComponents();
        this.antialisaingCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OpenGLPanel.this.antiAliasing = OpenGLPanel.this.antialisaingCombobox.getSelectedIndex() > 0 ? (int)Math.pow(2.0, OpenGLPanel.this.antialisaingCombobox.getSelectedIndex()) : 0;
            }
        });
    }

    private void initComponents() {
        this.jXTitledSeparator1 = new JXTitledSeparator();
        this.labelAntialiasing = new JLabel();
        this.antialisaingCombobox = new JComboBox();
        this.labelShow = new JLabel();
        this.labelOctreeWidth = new JLabel();
        this.fpsCheckbox = new JCheckBox();
        this.resetButton = new JButton();
        this.openglInfoPanel = new JPanel();
        this.openInfoText = new JTextArea();
        NumberFormat format = NumberFormat.getInstance(Locale.ENGLISH);
        NumberFormatter formatter = new NumberFormatter(format);
        formatter.setValueClass(Integer.class);
        formatter.setAllowsInvalid(false);
        this.octreeWidthTextField = new JFormattedTextField(formatter);
        Mnemonics.setLocalizedText((JLabel)this.labelOctreeWidth, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.labelOctreeWidth.text"));
        this.jXTitledSeparator1.setTitle(NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.jXTitledSeparator1.title"));
        Mnemonics.setLocalizedText((JLabel)this.labelAntialiasing, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.labelAntialiasing.text"));
        this.antialisaingCombobox.setModel(new DefaultComboBoxModel<String>(new String[]{"0x", "2x", "4x", "8x", "16x"}));
        Mnemonics.setLocalizedText((JLabel)this.labelShow, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.labelShow.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.fpsCheckbox, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.fpsCheckbox.text"));
        this.fpsCheckbox.setMargin(new Insets(2, 0, 2, 2));
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)NbBundle.getMessage(OpenGLPanel.class, (String)"OpenGLPanel.resetButton.text"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenGLPanel.this.resetButtonActionPerformed(evt);
            }
        });
        this.openglInfoPanel.setLayout(new GridBagLayout());
        this.openInfoText.setColumns(5);
        this.openInfoText.setEditable(false);
        this.openInfoText.setFont(new Font("Monospaced", 0, 11));
        this.openInfoText.setRows(3);
        this.openInfoText.setText("Vendor\nModel\nVersion");
        this.openInfoText.setOpaque(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.openglInfoPanel.add((Component)this.openInfoText, gridBagConstraints);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent((Component)this.jXTitledSeparator1, -1, 679, Short.MAX_VALUE).addComponent(this.resetButton).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.labelOctreeWidth, -2, 52, -2).addComponent(this.labelShow, -2, 52, -2).addComponent(this.labelAntialiasing)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.octreeWidthTextField)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.fpsCheckbox)).addGroup(layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.antialisaingCombobox, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 192, Short.MAX_VALUE).addComponent(this.openglInfoPanel, -2, 196, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent((Component)this.jXTitledSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.openglInfoPanel, -2, 86, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelAntialiasing).addComponent(this.antialisaingCombobox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelShow, -1, -1, Short.MAX_VALUE).addComponent(this.fpsCheckbox)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.labelOctreeWidth, -1, -1, Short.MAX_VALUE).addComponent(this.octreeWidthTextField)))).addGap(18, 18, Short.MAX_VALUE).addComponent(this.resetButton).addContainerGap()));
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.antialiasing");
        NbPreferences.forModule(VizConfig.class).remove("VizConfig.showFPS");
        this.load();
    }

    void load() {
        this.antiAliasing = NbPreferences.forModule(VizConfig.class).getInt("VizConfig.antialiasing", 4);
        this.antialisaingCombobox.setSelectedIndex(this.antiAliasing == 0 ? 0 : Math.round((float)(Math.log(this.antiAliasing) / Math.log(2.0))));
        this.fpsCheckbox.setSelected(NbPreferences.forModule(VizConfig.class).getBoolean("VizConfig.showFPS", false));
        this.octreeWidthTextField.setText(String.valueOf(NbPreferences.forModule(VizConfig.class).getInt("VizConfig.octreeWidth", 50000)));
        GraphicalConfiguration gc = VizController.getInstance().getDrawable().getGraphicalConfiguration();
        if (gc != null) {
            this.openInfoText.setText(gc.getVendor() + "\n" + gc.getRenderer() + "\nOpenGL2 " + gc.getVersionStr());
        }
    }

    void store() {
        NbPreferences.forModule(VizConfig.class).putInt("VizConfig.antialiasing", this.antiAliasing);
        NbPreferences.forModule(VizConfig.class).putBoolean("VizConfig.showFPS", this.fpsCheckbox.isSelected());
        try {
            int width = NumberFormat.getInstance(Locale.ENGLISH).parse(this.octreeWidthTextField.getText()).intValue();
            NbPreferences.forModule(VizConfig.class).putInt("VizConfig.octreeWidth", width);
            VizController.getInstance().getVizConfig().setOctreeWidth(width);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        VizController.getInstance().getEngine().reinit();
    }

    boolean valid() {
        return true;
    }
}

