/*
 * Decompiled with CFR 0.152.
 */
package jogamp.newt.driver.egl.gbm;

import com.jogamp.common.nio.Buffers;
import com.jogamp.common.util.IOUtil;
import com.jogamp.nativewindow.AbstractGraphicsDevice;
import com.jogamp.nativewindow.NativeWindowException;
import com.jogamp.nativewindow.NativeWindowFactory;
import com.jogamp.nativewindow.util.PixelFormat;
import com.jogamp.newt.Display;
import com.jogamp.opengl.GLProfile;
import com.jogamp.opengl.util.PNGPixelRect;
import java.net.URLConnection;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import jogamp.nativewindow.drm.DRMLib;
import jogamp.nativewindow.drm.DRMUtil;
import jogamp.newt.DisplayImpl;
import jogamp.newt.NEWTJNILibLoader;
import jogamp.newt.PointerIconImpl;
import jogamp.newt.driver.egl.gbm.ScreenDriver;
import jogamp.newt.driver.egl.gbm.WindowDriver;
import jogamp.opengl.egl.EGLDisplayUtil;

public class DisplayDriver
extends DisplayImpl {
    static final boolean DEBUG_POINTER_ICON;
    PointerIconImpl defaultPointerIcon = null;
    private long gbmHandle = 0L;
    private static final PNGPixelRect defaultPointerIconImage;

    public static void initSingleton() {
    }

    @Override
    protected void createNativeImpl() {
        int n = DRMUtil.getDrmFd();
        if (0 > n) {
            throw new NativeWindowException("Failed to initialize DRM");
        }
        this.gbmHandle = DRMLib.gbm_create_device(n);
        this.aDevice = EGLDisplayUtil.eglCreateEGLGraphicsDevice(this.gbmHandle, "decon", 0);
        this.aDevice.open();
        this.defaultPointerIcon = null != defaultPointerIconImage ? (PointerIconImpl)this.createPointerIcon(defaultPointerIconImage, 0, 0) : null;
        if (DEBUG) {
            System.err.println("Display.createNativeImpl: " + this);
        }
        if (DEBUG_POINTER_ICON) {
            System.err.println("Display.createNativeImpl: defaultPointerIcon " + this.defaultPointerIcon);
        }
    }

    @Override
    protected void closeNativeImpl(AbstractGraphicsDevice abstractGraphicsDevice) {
        if (DEBUG) {
            System.err.println("Display.closeNativeImpl: " + this);
        }
        if (null != this.defaultPointerIcon) {
            this.defaultPointerIcon.destroy();
            this.defaultPointerIcon = null;
        }
        abstractGraphicsDevice.close();
        DRMLib.gbm_device_destroy(this.gbmHandle);
        this.gbmHandle = 0L;
    }

    final long getGBMHandle() {
        return this.gbmHandle;
    }

    @Override
    protected void dispatchMessagesNative() {
        DisplayDriver.DispatchMessages0();
    }

    @Override
    public final PixelFormat getNativePointerIconPixelFormat() {
        return PixelFormat.BGRA8888;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final long createPointerIconImpl(PixelFormat pixelFormat, int n, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        this.aDevice.lock();
        try {
            long l = DisplayDriver.CreatePointerIcon(this.gbmHandle, byteBuffer, n, n2, n3, n4);
            return l;
        }
        finally {
            this.aDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void destroyPointerIconImpl(long l, long l2) {
        AbstractGraphicsDevice abstractGraphicsDevice = this.aDevice;
        if (null != abstractGraphicsDevice) {
            abstractGraphicsDevice.lock();
            try {
                DisplayDriver.DestroyPointerIcon0(l2);
            }
            finally {
                abstractGraphicsDevice.unlock();
            }
        } else {
            DisplayDriver.DestroyPointerIcon0(l2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setPointerIcon(int n, long l, boolean bl, int n2, int n3, int n4, int n5) {
        this.aDevice.lock();
        try {
            boolean bl2 = DisplayDriver.SetPointerIcon0(DRMUtil.getDrmFd(), n, l, bl, n2, n3, n4, n5);
            return bl2;
        }
        finally {
            this.aDevice.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean movePointerIcon(int n, int n2, int n3) {
        this.aDevice.lock();
        try {
            boolean bl = DisplayDriver.MovePointerIcon0(DRMUtil.getDrmFd(), n, n2, n3);
            return bl;
        }
        finally {
            this.aDevice.unlock();
        }
    }

    private static native boolean initIDs();

    private static native void Shutdown0();

    private static native void DispatchMessages0();

    private static long CreatePointerIcon(long l, Buffer buffer, int n, int n2, int n3, int n4) {
        if (0 >= n || n > 64 || 0 >= n2 || n2 > 64) {
            throw new IllegalArgumentException("implementation only supports BGRA icons of size [1x1] -> [64x64]");
        }
        boolean bl = Buffers.isDirect((Object)buffer);
        return DisplayDriver.CreatePointerIcon0(l, bl ? buffer : Buffers.getArray((Object)buffer), bl ? Buffers.getDirectBufferByteOffset((Object)buffer) : Buffers.getIndirectBufferByteOffset((Object)buffer), bl, n, n2, n3, n4);
    }

    private static native long CreatePointerIcon0(long var0, Object var2, int var3, boolean var4, int var5, int var6, int var7, int var8);

    private static native void DestroyPointerIcon0(long var0);

    private static native boolean SetPointerIcon0(int var0, int var1, long var2, boolean var4, int var5, int var6, int var7, int var8);

    private static native boolean MovePointerIcon0(int var0, int var1, int var2, int var3);

    static {
        NEWTJNILibLoader.loadNEWTDrmGbm();
        GLProfile.initSingleton();
        if (!DisplayDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize egl.gbm Display jmethodIDs");
        }
        if (!ScreenDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize egl.gbm Screen jmethodIDs");
        }
        if (!WindowDriver.initIDs()) {
            throw new NativeWindowException("Failed to initialize egl.gbm Window jmethodIDs");
        }
        NativeWindowFactory.addCustomShutdownHook(false, new Runnable(){

            @Override
            public void run() {
                DisplayDriver.Shutdown0();
            }
        });
        PNGPixelRect pNGPixelRect = null;
        if (DisplayImpl.isPNGUtilAvailable()) {
            IOUtil.ClassResources classResources = new IOUtil.ClassResources(new String[]{"newt/data/pointer-grey-alpha-16x24.png"}, DisplayDriver.class.getClassLoader(), null);
            try {
                URLConnection uRLConnection = classResources.resolve(0);
                if (null != uRLConnection) {
                    pNGPixelRect = PNGPixelRect.read(uRLConnection.getInputStream(), PixelFormat.BGRA8888, false, 0, false);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        defaultPointerIconImage = pNGPixelRect;
        DEBUG_POINTER_ICON = Display.DEBUG_POINTER_ICON;
    }
}

