/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.graph.impl;

import java.awt.Color;
import org.gephi.graph.api.TextProperties;

public class TextPropertiesImpl
implements TextProperties {
    protected boolean visible = true;
    protected int rgba = -16777216;
    protected float size = 1.0f;
    protected String text;
    protected float width;
    protected float height;

    @Override
    public float getR() {
        return (float)(this.rgba >> 16 & 0xFF) / 255.0f;
    }

    @Override
    public float getG() {
        return (float)(this.rgba >> 8 & 0xFF) / 255.0f;
    }

    @Override
    public float getB() {
        return (float)(this.rgba & 0xFF) / 255.0f;
    }

    @Override
    public float getAlpha() {
        return (float)(this.rgba >> 24 & 0xFF) / 255.0f;
    }

    @Override
    public int getRGBA() {
        return this.rgba;
    }

    @Override
    public Color getColor() {
        return new Color(this.rgba, true);
    }

    @Override
    public float getSize() {
        return this.size;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        return this.height;
    }

    @Override
    public void setR(float r) {
        this.rgba = this.rgba & 0xFF00FFFF | (int)(r * 255.0f) << 16;
    }

    @Override
    public void setG(float g) {
        this.rgba = this.rgba & 0xFFFF00FF | (int)(g * 255.0f) << 8;
    }

    @Override
    public void setB(float b) {
        this.rgba = this.rgba & 0xFFFFFF00 | (int)(b * 255.0f);
    }

    @Override
    public void setAlpha(float a) {
        this.rgba = this.rgba & 0xFFFFFF | (int)(a * 255.0f) << 24;
    }

    @Override
    public void setColor(Color color) {
        this.rgba = color.getAlpha() << 24 | color.getRGB();
    }

    @Override
    public void setSize(float size) {
        this.size = size;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public void setText(String text) {
        this.text = text;
    }

    @Override
    public void setDimensions(float width, float height) {
        this.width = width;
        this.height = height;
    }

    public int deepHashCode() {
        int hash = 7;
        hash = 97 * hash + (this.visible ? 1 : 0);
        hash = 97 * hash + this.rgba;
        hash = 97 * hash + Float.floatToIntBits(this.size);
        hash = 97 * hash + Float.floatToIntBits(this.width);
        hash = 97 * hash + Float.floatToIntBits(this.height);
        hash = 97 * hash + (this.text != null ? this.text.hashCode() : 0);
        return hash;
    }

    public boolean deepEquals(TextPropertiesImpl obj) {
        if (obj == null) {
            return false;
        }
        if (this.visible != obj.visible) {
            return false;
        }
        if (this.rgba != obj.rgba) {
            return false;
        }
        if (Float.floatToIntBits(this.size) != Float.floatToIntBits(obj.size)) {
            return false;
        }
        if (Float.floatToIntBits(this.width) != Float.floatToIntBits(obj.width)) {
            return false;
        }
        if (Float.floatToIntBits(this.height) != Float.floatToIntBits(obj.height)) {
            return false;
        }
        return !(this.text == null ? obj.text != null : !this.text.equals(obj.text));
    }
}

