/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.datalab.plugin.manipulators.general;

import javax.swing.Icon;
import org.gephi.datalab.api.GraphElementsController;
import org.gephi.datalab.plugin.manipulators.general.AddNodeToGraph;
import org.gephi.datalab.plugin.manipulators.general.ui.AddEdgeToGraphUI;
import org.gephi.datalab.spi.ManipulatorUI;
import org.gephi.datalab.spi.general.GeneralActionsManipulator;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class AddEdgeToGraph
implements GeneralActionsManipulator {
    private Node source = null;
    private Node target = null;
    private boolean directed;
    private Object edgeTypeLabel = null;
    private GraphModel graphModel = null;

    public void execute() {
        if (this.source != null && this.target != null) {
            ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).createEdge(this.source, this.target, this.directed, this.edgeTypeLabel);
        }
    }

    public String getName() {
        return NbBundle.getMessage(AddNodeToGraph.class, (String)"AddEdgeToGraph.name");
    }

    public String getDescription() {
        return "";
    }

    public boolean canExecute() {
        return ((GraphElementsController)Lookup.getDefault().lookup(GraphElementsController.class)).getNodesCount() > 0;
    }

    public ManipulatorUI getUI() {
        GraphModel currentGraphModel = ((GraphController)Lookup.getDefault().lookup(GraphController.class)).getGraphModel();
        if (this.graphModel != null && this.graphModel != currentGraphModel) {
            this.directed = currentGraphModel.isDirected() || currentGraphModel.isMixed();
            this.graphModel = currentGraphModel;
            this.source = null;
        }
        return new AddEdgeToGraphUI();
    }

    public int getType() {
        return 0;
    }

    public int getPosition() {
        return 200;
    }

    public Icon getIcon() {
        return ImageUtilities.loadImageIcon((String)"DataLaboratoryPlugin/plus-white.png", (boolean)false);
    }

    public boolean isDirected() {
        return this.directed;
    }

    public void setDirected(boolean directed) {
        this.directed = directed;
    }

    public Node getSource() {
        return this.source;
    }

    public void setSource(Node source) {
        this.source = source;
    }

    public Node getTarget() {
        return this.target;
    }

    public void setTarget(Node target) {
        this.target = target;
    }

    public Object getEdgeTypeLabel() {
        return this.edgeTypeLabel;
    }

    public void setEdgeTypeLabel(Object edgeTypeLabel) {
        this.edgeTypeLabel = edgeTypeLabel;
    }
}

