/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.ui.swing;

import javax.swing.JComponent;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.ui.ValidationListener;
import org.netbeans.validation.api.ui.ValidationUI;
import org.netbeans.validation.api.ui.swing.SwingValidationGroup;

public abstract class AbstractValidationListener<CompType extends JComponent, T>
extends ValidationListener<CompType> {
    private final Validator<T> validator;

    public AbstractValidationListener(Class<CompType> type, CompType comp, ValidationUI ui, Validator<T> validator) {
        super(type, ui, comp);
        this.validator = validator;
    }

    protected String findComponentName(CompType comp) {
        return SwingValidationGroup.nameForComponent(comp);
    }

    protected abstract T getModelObject(CompType var1);

    protected void onValidate(CompType component, Problem validationResult) {
    }

    @Override
    protected final void performValidation(Problems ps) {
        JComponent comp = (JComponent)this.getTarget();
        if (!comp.isEnabled()) {
            return;
        }
        this.validator.validate(ps, SwingValidationGroup.nameForComponent(comp), this.getModelObject(comp));
        this.onValidate((JComponent)this.getTarget(), ps.getLeadProblem());
    }
}

