/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Slot;
import org.mozilla.javascript.SlotMap;

public class EmbeddedSlotMap
implements SlotMap {
    private Slot[] slots;
    private Slot firstAdded;
    private Slot lastAdded;
    private int count;
    private static final int INITIAL_SLOT_SIZE = 4;

    @Override
    public int size() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public Iterator<Slot> iterator() {
        return new Iter(this.firstAdded);
    }

    @Override
    public Slot query(Object object, int n) {
        if (this.slots == null) {
            return null;
        }
        int n2 = object != null ? object.hashCode() : n;
        int n3 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n2);
        Slot slot = this.slots[n3];
        while (slot != null) {
            if (n2 == slot.indexOrHash && Objects.equals(slot.name, object)) {
                return slot;
            }
            slot = slot.next;
        }
        return null;
    }

    @Override
    public Slot modify(Object object, int n, int n2) {
        int n3;
        int n4 = n3 = object != null ? object.hashCode() : n;
        if (this.slots != null) {
            int n5 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n3);
            Slot slot = this.slots[n5];
            while (!(slot == null || n3 == slot.indexOrHash && Objects.equals(slot.name, object))) {
                slot = slot.next;
            }
            if (slot != null) {
                return slot;
            }
        }
        return this.createSlot(object, n3, n2);
    }

    private Slot createSlot(Object object, int n, int n2) {
        Slot[] slotArray;
        if (this.count == 0) {
            this.slots = new Slot[4];
        }
        if (4 * (this.count + 1) > 3 * this.slots.length) {
            slotArray = new Slot[this.slots.length * 2];
            EmbeddedSlotMap.copyTable(this.slots, slotArray);
            this.slots = slotArray;
        }
        slotArray = new Slot(object, n, n2);
        this.insertNewSlot((Slot)slotArray);
        return slotArray;
    }

    @Override
    public void replace(Slot slot, Slot slot2) {
        Slot slot3;
        int n = EmbeddedSlotMap.getSlotIndex(this.slots.length, slot.indexOrHash);
        Slot slot4 = slot3 = this.slots[n];
        while (slot4 != null && slot4 != slot) {
            slot3 = slot4;
            slot4 = slot4.next;
        }
        assert (slot4 == slot);
        if (slot3 == slot) {
            this.slots[n] = slot2;
        } else {
            slot3.next = slot2;
        }
        slot2.next = slot.next;
        if (slot == this.firstAdded) {
            this.firstAdded = slot2;
        } else {
            Slot slot5 = this.firstAdded;
            while (slot5 != null && slot5.orderedNext != slot) {
                slot5 = slot5.orderedNext;
            }
            if (slot5 != null) {
                slot5.orderedNext = slot2;
            }
        }
        slot2.orderedNext = slot.orderedNext;
        if (slot == this.lastAdded) {
            this.lastAdded = slot2;
        }
    }

    @Override
    public void add(Slot slot) {
        if (this.slots == null) {
            this.slots = new Slot[4];
        }
        this.insertNewSlot(slot);
    }

    private void insertNewSlot(Slot slot) {
        ++this.count;
        if (this.lastAdded != null) {
            this.lastAdded.orderedNext = slot;
        }
        if (this.firstAdded == null) {
            this.firstAdded = slot;
        }
        this.lastAdded = slot;
        EmbeddedSlotMap.addKnownAbsentSlot(this.slots, slot);
    }

    @Override
    public void remove(Object object, int n) {
        int n2;
        int n3 = n2 = object != null ? object.hashCode() : n;
        if (this.count != 0) {
            Slot slot;
            int n4 = EmbeddedSlotMap.getSlotIndex(this.slots.length, n2);
            Slot slot2 = slot = this.slots[n4];
            while (!(slot2 == null || slot2.indexOrHash == n2 && Objects.equals(slot2.name, object))) {
                slot = slot2;
                slot2 = slot2.next;
            }
            if (slot2 != null) {
                if ((slot2.getAttributes() & 4) != 0) {
                    Context context = Context.getContext();
                    if (context.isStrictMode()) {
                        throw ScriptRuntime.typeErrorById("msg.delete.property.with.configurable.false", object);
                    }
                    return;
                }
                --this.count;
                if (slot == slot2) {
                    this.slots[n4] = slot2.next;
                } else {
                    slot.next = slot2.next;
                }
                if (slot2 == this.firstAdded) {
                    slot = null;
                    this.firstAdded = slot2.orderedNext;
                } else {
                    slot = this.firstAdded;
                    while (slot.orderedNext != slot2) {
                        slot = slot.orderedNext;
                    }
                    slot.orderedNext = slot2.orderedNext;
                }
                if (slot2 == this.lastAdded) {
                    this.lastAdded = slot;
                }
            }
        }
    }

    private static void copyTable(Slot[] slotArray, Slot[] slotArray2) {
        for (Slot slot : slotArray) {
            while (slot != null) {
                Slot slot2 = slot.next;
                slot.next = null;
                EmbeddedSlotMap.addKnownAbsentSlot(slotArray2, slot);
                slot = slot2;
            }
        }
    }

    private static void addKnownAbsentSlot(Slot[] slotArray, Slot slot) {
        int n = EmbeddedSlotMap.getSlotIndex(slotArray.length, slot.indexOrHash);
        Slot slot2 = slotArray[n];
        slotArray[n] = slot;
        slot.next = slot2;
    }

    private static int getSlotIndex(int n, int n2) {
        return n2 & n - 1;
    }

    private static final class Iter
    implements Iterator<Slot> {
        private Slot next;

        Iter(Slot slot) {
            this.next = slot;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Slot next() {
            Slot slot = this.next;
            if (slot == null) {
                throw new NoSuchElementException();
            }
            this.next = this.next.orderedNext;
            return slot;
        }
    }
}

