/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.parser;

import io.sf.carte.doc.style.css.nsac.SelectorList;
import java.io.Serializable;
import java.util.Locale;

public abstract class AnBExpression
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SelectorList selectorList = null;
    private int offset = 0;
    private int step = 0;
    private boolean haskeyword = false;

    protected AnBExpression() {
    }

    public int getStep() {
        return this.step;
    }

    public int getOffset() {
        return this.offset;
    }

    public SelectorList getSelectorList() {
        return this.selectorList;
    }

    public boolean isKeyword() {
        return this.haskeyword;
    }

    public void parse(String string) {
        String string2 = string;
        int n = string2.indexOf(" of ");
        if (n != -1) {
            this.selectorList = this.parseSelector(string2.substring(n + 4).trim());
            string2 = string2.substring(0, n);
        }
        string2 = string2.trim().toLowerCase(Locale.ROOT);
        this.offset = 0;
        if (string2.equals("even")) {
            this.step = 2;
            this.haskeyword = true;
            return;
        }
        if (string2.equals("odd")) {
            this.step = 2;
            this.offset = 1;
            this.haskeyword = true;
            return;
        }
        int n2 = string2.indexOf(110);
        int n3 = string2.length() - 1;
        if (n3 == -1) {
            this.reportError(string);
        }
        if (n2 != -1) {
            if (n3 == n2 + 1) {
                this.reportError(string);
            } else {
                if (n3 != n2) {
                    String string3 = string2.substring(n2 + 1);
                    if ((string3 = AnBExpression.removeSpacesBeforeFirstDigit(string3)) == null) {
                        this.reportError(string);
                    }
                    try {
                        this.offset = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.reportError(string);
                    }
                }
                if (n2 == 0) {
                    this.step = 1;
                } else if (n2 == 1) {
                    char c = string2.charAt(0);
                    if (c == '+') {
                        this.step = 1;
                    } else if (c == '-') {
                        this.step = -1;
                    } else if (AnBExpression.isDigit(c)) {
                        this.step = Integer.parseInt(string2.substring(0, n2));
                    } else {
                        this.reportError(string);
                    }
                } else {
                    try {
                        this.step = Integer.parseInt(string2.substring(0, n2));
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.reportError(string);
                    }
                }
            }
        } else {
            this.step = 0;
            try {
                this.offset = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                this.reportError(string);
            }
        }
    }

    private static String removeSpacesBeforeFirstDigit(String string) {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '-') {
                if (bl3) break;
                bl3 = true;
                bl = true;
                continue;
            }
            if (c == ' ') {
                bl2 = true;
                continue;
            }
            if (Character.isDigit(c)) {
                if (!bl2) {
                    return string;
                }
                if (bl) {
                    return "-" + string.subSequence(i, n);
                }
                if (!bl3) continue;
                return string.substring(i, n);
            }
            if (c != '+' || bl3) break;
            bl3 = true;
        }
        return null;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    void reportError(String string) {
        throw new IllegalArgumentException("Wrong expression " + string);
    }

    protected abstract SelectorList parseSelector(String var1);
}

