/*
 * Decompiled with CFR 0.152.
 */
package de.sciss.syntaxpane.actions;

import de.sciss.syntaxpane.SyntaxDocument;
import de.sciss.syntaxpane.Token;
import de.sciss.syntaxpane.actions.ActionUtils;
import de.sciss.syntaxpane.actions.DefaultSyntaxAction;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class JUnindentAction
extends DefaultSyntaxAction {
    public JUnindentAction() {
        super("JUNINDENT");
    }

    @Override
    public void actionPerformed(JTextComponent target, SyntaxDocument sDoc, int dot, ActionEvent e) {
        int pos = target.getCaretPosition();
        int start = sDoc.getParagraphElement(pos).getStartOffset();
        String line = ActionUtils.getLine(target);
        if (ActionUtils.isEmptyOrBlanks(line)) {
            try {
                sDoc.insertString(pos, "}", null);
                Token t = sDoc.getPairFor(sDoc.getTokenAt(pos));
                if (null != t) {
                    String pairLine = ActionUtils.getLineAt(target, t.start);
                    String indent = ActionUtils.getIndent(pairLine);
                    sDoc.replace(start, line.length() + 1, indent + "}", null);
                }
            }
            catch (BadLocationException ble) {
                target.replaceSelection("}");
            }
        } else {
            target.replaceSelection("}");
        }
    }
}

