'' FreeBASIC binding for mingw-w64-v4.0.4
''
'' based on the C header files:
''   Copyright (C) the Wine project
''
''   This library is free software; you can redistribute it and/or
''   modify it under the terms of the GNU Lesser General Public
''   License as published by the Free Software Foundation; either
''   version 2.1 of the License, or (at your option) any later version.
''
''   This library is distributed in the hope that it will be useful,
''   but WITHOUT ANY WARRANTY; without even the implied warranty of
''   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
''   Lesser General Public License for more details.
''
''   You should have received a copy of the GNU Lesser General Public
''   License along with this library; if not, write to the Free Software
''   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA
''
'' translated to FreeBASIC by:
''   FreeBASIC development team

#pragma once

#inclib "ddraw"
#inclib "dxguid"

#include once "objbase.bi"

extern "Windows"

#define __DDRAW_INCLUDED__
const DIRECTDRAW_VERSION = &h0700
extern CLSID_DirectDraw as const GUID
extern CLSID_DirectDraw7 as const GUID
extern CLSID_DirectDrawClipper as const GUID
extern IID_IDirectDraw as const GUID
extern IID_IDirectDraw2 as const GUID
extern IID_IDirectDraw3 as const GUID
extern IID_IDirectDraw4 as const GUID
extern IID_IDirectDraw7 as const GUID
extern IID_IDirectDrawSurface as const GUID
extern IID_IDirectDrawSurface2 as const GUID
extern IID_IDirectDrawSurface3 as const GUID
extern IID_IDirectDrawSurface4 as const GUID
extern IID_IDirectDrawSurface7 as const GUID
extern IID_IDirectDrawPalette as const GUID
extern IID_IDirectDrawClipper as const GUID
extern IID_IDirectDrawColorControl as const GUID
extern IID_IDirectDrawGammaControl as const GUID

type LPDIRECTDRAW as IDirectDraw ptr
type LPDIRECTDRAW2 as IDirectDraw2 ptr
type LPDIRECTDRAW3 as IDirectDraw3 ptr
type LPDIRECTDRAW4 as IDirectDraw4 ptr
type LPDIRECTDRAW7 as IDirectDraw7 ptr
type LPDIRECTDRAWCLIPPER as IDirectDrawClipper ptr
type LPDIRECTDRAWPALETTE as IDirectDrawPalette ptr
type LPDIRECTDRAWSURFACE as IDirectDrawSurface ptr
type LPDIRECTDRAWSURFACE2 as IDirectDrawSurface2 ptr
type LPDIRECTDRAWSURFACE3 as IDirectDrawSurface3 ptr
type LPDIRECTDRAWSURFACE4 as IDirectDrawSurface4 ptr
type IDirectDrawSurface7 as IDirectDrawSurface7_
type LPDIRECTDRAWSURFACE7 as IDirectDrawSurface7 ptr
type LPDIRECTDRAWCOLORCONTROL as IDirectDrawColorControl ptr
type LPDIRECTDRAWGAMMACONTROL as IDirectDrawGammaControl ptr

const DDENUMRET_CANCEL = 0
const DDENUMRET_OK = 1
const DD_OK = S_OK
const DD_FALSE = S_FALSE
const _FACDD = &h876
#define DDERR_ALREADYINITIALIZED MAKE_DDHRESULT(5)
#define DDERR_CANNOTATTACHSURFACE MAKE_DDHRESULT(10)
#define DDERR_CANNOTDETACHSURFACE MAKE_DDHRESULT(20)
#define DDERR_CURRENTLYNOTAVAIL MAKE_DDHRESULT(40)
#define DDERR_EXCEPTION MAKE_DDHRESULT(55)
#define DDERR_GENERIC E_FAIL
#define DDERR_HEIGHTALIGN MAKE_DDHRESULT(90)
#define DDERR_INCOMPATIBLEPRIMARY MAKE_DDHRESULT(95)
#define DDERR_INVALIDCAPS MAKE_DDHRESULT(100)
#define DDERR_INVALIDCLIPLIST MAKE_DDHRESULT(110)
#define DDERR_INVALIDMODE MAKE_DDHRESULT(120)
#define DDERR_INVALIDOBJECT MAKE_DDHRESULT(130)
#define DDERR_INVALIDPARAMS E_INVALIDARG
#define DDERR_INVALIDPIXELFORMAT MAKE_DDHRESULT(145)
#define DDERR_INVALIDRECT MAKE_DDHRESULT(150)
#define DDERR_LOCKEDSURFACES MAKE_DDHRESULT(160)
#define DDERR_NO3D MAKE_DDHRESULT(170)
#define DDERR_NOALPHAHW MAKE_DDHRESULT(180)
#define DDERR_NOSTEREOHARDWARE MAKE_DDHRESULT(181)
#define DDERR_NOSURFACELEFT MAKE_DDHRESULT(182)
#define DDERR_NOCLIPLIST MAKE_DDHRESULT(205)
#define DDERR_NOCOLORCONVHW MAKE_DDHRESULT(210)
#define DDERR_NOCOOPERATIVELEVELSET MAKE_DDHRESULT(212)
#define DDERR_NOCOLORKEY MAKE_DDHRESULT(215)
#define DDERR_NOCOLORKEYHW MAKE_DDHRESULT(220)
#define DDERR_NODIRECTDRAWSUPPORT MAKE_DDHRESULT(222)
#define DDERR_NOEXCLUSIVEMODE MAKE_DDHRESULT(225)
#define DDERR_NOFLIPHW MAKE_DDHRESULT(230)
#define DDERR_NOGDI MAKE_DDHRESULT(240)
#define DDERR_NOMIRRORHW MAKE_DDHRESULT(250)
#define DDERR_NOTFOUND MAKE_DDHRESULT(255)
#define DDERR_NOOVERLAYHW MAKE_DDHRESULT(260)
#define DDERR_OVERLAPPINGRECTS MAKE_DDHRESULT(270)
#define DDERR_NORASTEROPHW MAKE_DDHRESULT(280)
#define DDERR_NOROTATIONHW MAKE_DDHRESULT(290)
#define DDERR_NOSTRETCHHW MAKE_DDHRESULT(310)
#define DDERR_NOT4BITCOLOR MAKE_DDHRESULT(316)
#define DDERR_NOT4BITCOLORINDEX MAKE_DDHRESULT(317)
#define DDERR_NOT8BITCOLOR MAKE_DDHRESULT(320)
#define DDERR_NOTEXTUREHW MAKE_DDHRESULT(330)
#define DDERR_NOVSYNCHW MAKE_DDHRESULT(335)
#define DDERR_NOZBUFFERHW MAKE_DDHRESULT(340)
#define DDERR_NOZOVERLAYHW MAKE_DDHRESULT(350)
#define DDERR_OUTOFCAPS MAKE_DDHRESULT(360)
#define DDERR_OUTOFMEMORY E_OUTOFMEMORY
#define DDERR_OUTOFVIDEOMEMORY MAKE_DDHRESULT(380)
#define DDERR_OVERLAYCANTCLIP MAKE_DDHRESULT(382)
#define DDERR_OVERLAYCOLORKEYONLYONEACTIVE MAKE_DDHRESULT(384)
#define DDERR_PALETTEBUSY MAKE_DDHRESULT(387)
#define DDERR_COLORKEYNOTSET MAKE_DDHRESULT(400)
#define DDERR_SURFACEALREADYATTACHED MAKE_DDHRESULT(410)
#define DDERR_SURFACEALREADYDEPENDENT MAKE_DDHRESULT(420)
#define DDERR_SURFACEBUSY MAKE_DDHRESULT(430)
#define DDERR_CANTLOCKSURFACE MAKE_DDHRESULT(435)
#define DDERR_SURFACEISOBSCURED MAKE_DDHRESULT(440)
#define DDERR_SURFACELOST MAKE_DDHRESULT(450)
#define DDERR_SURFACENOTATTACHED MAKE_DDHRESULT(460)
#define DDERR_TOOBIGHEIGHT MAKE_DDHRESULT(470)
#define DDERR_TOOBIGSIZE MAKE_DDHRESULT(480)
#define DDERR_TOOBIGWIDTH MAKE_DDHRESULT(490)
#define DDERR_UNSUPPORTED E_NOTIMPL
#define DDERR_UNSUPPORTEDFORMAT MAKE_DDHRESULT(510)
#define DDERR_UNSUPPORTEDMASK MAKE_DDHRESULT(520)
#define DDERR_INVALIDSTREAM MAKE_DDHRESULT(521)
#define DDERR_VERTICALBLANKINPROGRESS MAKE_DDHRESULT(537)
#define DDERR_WASSTILLDRAWING MAKE_DDHRESULT(540)
#define DDERR_DDSCAPSCOMPLEXREQUIRED MAKE_DDHRESULT(542)
#define DDERR_XALIGN MAKE_DDHRESULT(560)
#define DDERR_INVALIDDIRECTDRAWGUID MAKE_DDHRESULT(561)
#define DDERR_DIRECTDRAWALREADYCREATED MAKE_DDHRESULT(562)
#define DDERR_NODIRECTDRAWHW MAKE_DDHRESULT(563)
#define DDERR_PRIMARYSURFACEALREADYEXISTS MAKE_DDHRESULT(564)
#define DDERR_NOEMULATION MAKE_DDHRESULT(565)
#define DDERR_REGIONTOOSMALL MAKE_DDHRESULT(566)
#define DDERR_CLIPPERISUSINGHWND MAKE_DDHRESULT(567)
#define DDERR_NOCLIPPERATTACHED MAKE_DDHRESULT(568)
#define DDERR_NOHWND MAKE_DDHRESULT(569)
#define DDERR_HWNDSUBCLASSED MAKE_DDHRESULT(570)
#define DDERR_HWNDALREADYSET MAKE_DDHRESULT(571)
#define DDERR_NOPALETTEATTACHED MAKE_DDHRESULT(572)
#define DDERR_NOPALETTEHW MAKE_DDHRESULT(573)
#define DDERR_BLTFASTCANTCLIP MAKE_DDHRESULT(574)
#define DDERR_NOBLTHW MAKE_DDHRESULT(575)
#define DDERR_NODDROPSHW MAKE_DDHRESULT(576)
#define DDERR_OVERLAYNOTVISIBLE MAKE_DDHRESULT(577)
#define DDERR_NOOVERLAYDEST MAKE_DDHRESULT(578)
#define DDERR_INVALIDPOSITION MAKE_DDHRESULT(579)
#define DDERR_NOTAOVERLAYSURFACE MAKE_DDHRESULT(580)
#define DDERR_EXCLUSIVEMODEALREADYSET MAKE_DDHRESULT(581)
#define DDERR_NOTFLIPPABLE MAKE_DDHRESULT(582)
#define DDERR_CANTDUPLICATE MAKE_DDHRESULT(583)
#define DDERR_NOTLOCKED MAKE_DDHRESULT(584)
#define DDERR_CANTCREATEDC MAKE_DDHRESULT(585)
#define DDERR_NODC MAKE_DDHRESULT(586)
#define DDERR_WRONGMODE MAKE_DDHRESULT(587)
#define DDERR_IMPLICITLYCREATED MAKE_DDHRESULT(588)
#define DDERR_NOTPALETTIZED MAKE_DDHRESULT(589)
#define DDERR_UNSUPPORTEDMODE MAKE_DDHRESULT(590)
#define DDERR_NOMIPMAPHW MAKE_DDHRESULT(591)
#define DDERR_INVALIDSURFACETYPE MAKE_DDHRESULT(592)
#define DDERR_NOOPTIMIZEHW MAKE_DDHRESULT(600)
#define DDERR_NOTLOADED MAKE_DDHRESULT(601)
#define DDERR_NOFOCUSWINDOW MAKE_DDHRESULT(602)
#define DDERR_NOTONMIPMAPSUBLEVEL MAKE_DDHRESULT(603)
#define DDERR_DCALREADYCREATED MAKE_DDHRESULT(620)
#define DDERR_NONONLOCALVIDMEM MAKE_DDHRESULT(630)
#define DDERR_CANTPAGELOCK MAKE_DDHRESULT(640)
#define DDERR_CANTPAGEUNLOCK MAKE_DDHRESULT(660)
#define DDERR_NOTPAGELOCKED MAKE_DDHRESULT(680)
#define DDERR_MOREDATA MAKE_DDHRESULT(690)
#define DDERR_EXPIRED MAKE_DDHRESULT(691)
#define DDERR_TESTFINISHED MAKE_DDHRESULT(692)
#define DDERR_NEWMODE MAKE_DDHRESULT(693)
#define DDERR_D3DNOTINITIALIZED MAKE_DDHRESULT(694)
#define DDERR_VIDEONOTACTIVE MAKE_DDHRESULT(695)
#define DDERR_NOMONITORINFORMATION MAKE_DDHRESULT(696)
#define DDERR_NODRIVERSUPPORT MAKE_DDHRESULT(697)
#define DDERR_DEVICEDOESNTOWNSURFACE MAKE_DDHRESULT(699)
#define DDERR_NOTINITIALIZED CO_E_NOTINITIALIZED
const DDBLT_ALPHADEST = &h00000001
const DDBLT_ALPHADESTCONSTOVERRIDE = &h00000002
const DDBLT_ALPHADESTNEG = &h00000004
const DDBLT_ALPHADESTSURFACEOVERRIDE = &h00000008
const DDBLT_ALPHAEDGEBLEND = &h00000010
const DDBLT_ALPHASRC = &h00000020
const DDBLT_ALPHASRCCONSTOVERRIDE = &h00000040
const DDBLT_ALPHASRCNEG = &h00000080
const DDBLT_ALPHASRCSURFACEOVERRIDE = &h00000100
const DDBLT_ASYNC = &h00000200
const DDBLT_COLORFILL = &h00000400
const DDBLT_DDFX = &h00000800
const DDBLT_DDROPS = &h00001000
const DDBLT_KEYDEST = &h00002000
const DDBLT_KEYDESTOVERRIDE = &h00004000
const DDBLT_KEYSRC = &h00008000
const DDBLT_KEYSRCOVERRIDE = &h00010000
const DDBLT_ROP = &h00020000
const DDBLT_ROTATIONANGLE = &h00040000
const DDBLT_ZBUFFER = &h00080000
const DDBLT_ZBUFFERDESTCONSTOVERRIDE = &h00100000
const DDBLT_ZBUFFERDESTOVERRIDE = &h00200000
const DDBLT_ZBUFFERSRCCONSTOVERRIDE = &h00400000
const DDBLT_ZBUFFERSRCOVERRIDE = &h00800000
const DDBLT_WAIT = &h01000000
const DDBLT_DEPTHFILL = &h02000000
const DDBLT_DONOTWAIT = &h08000000
const DDBLTFAST_NOCOLORKEY = &h00000000
const DDBLTFAST_SRCCOLORKEY = &h00000001
const DDBLTFAST_DESTCOLORKEY = &h00000002
const DDBLTFAST_WAIT = &h00000010
const DDBLTFAST_DONOTWAIT = &h00000020
const DDFLIP_WAIT = &h00000001
const DDFLIP_EVEN = &h00000002
const DDFLIP_ODD = &h00000004
const DDFLIP_NOVSYNC = &h00000008
const DDFLIP_STEREO = &h00000010
const DDFLIP_DONOTWAIT = &h00000020
const DDFLIP_INTERVAL2 = &h02000000
const DDFLIP_INTERVAL3 = &h03000000
const DDFLIP_INTERVAL4 = &h04000000
const DDGBS_CANBLT = &h00000001
const DDGBS_ISBLTDONE = &h00000002
const DDGFS_CANFLIP = 1
const DDGFS_ISFLIPDONE = 2
const DDSPD_IUNKNOWNPOINTER = 1
const DDSPD_VOLATILE = 2
const DDSCAPS_RESERVED1 = &h00000001
const DDSCAPS_ALPHA = &h00000002
const DDSCAPS_BACKBUFFER = &h00000004
const DDSCAPS_COMPLEX = &h00000008
const DDSCAPS_FLIP = &h00000010
const DDSCAPS_FRONTBUFFER = &h00000020
const DDSCAPS_OFFSCREENPLAIN = &h00000040
const DDSCAPS_OVERLAY = &h00000080
const DDSCAPS_PALETTE = &h00000100
const DDSCAPS_PRIMARYSURFACE = &h00000200
const DDSCAPS_PRIMARYSURFACELEFT = &h00000400
const DDSCAPS_SYSTEMMEMORY = &h00000800
const DDSCAPS_TEXTURE = &h00001000
const DDSCAPS_3DDEVICE = &h00002000
const DDSCAPS_VIDEOMEMORY = &h00004000
const DDSCAPS_VISIBLE = &h00008000
const DDSCAPS_WRITEONLY = &h00010000
const DDSCAPS_ZBUFFER = &h00020000
const DDSCAPS_OWNDC = &h00040000
const DDSCAPS_LIVEVIDEO = &h00080000
const DDSCAPS_HWCODEC = &h00100000
const DDSCAPS_MODEX = &h00200000
const DDSCAPS_MIPMAP = &h00400000
const DDSCAPS_RESERVED2 = &h00800000
const DDSCAPS_ALLOCONLOAD = &h04000000
const DDSCAPS_VIDEOPORT = &h08000000
const DDSCAPS_LOCALVIDMEM = &h10000000
const DDSCAPS_NONLOCALVIDMEM = &h20000000
const DDSCAPS_STANDARDVGAMODE = &h40000000
const DDSCAPS_OPTIMIZED = &h80000000

type _DDSCAPS
	dwCaps as DWORD
end type

type DDSCAPS as _DDSCAPS
type LPDDSCAPS as _DDSCAPS ptr
const DDSCAPS2_HARDWAREDEINTERLACE = &h00000002
const DDSCAPS2_HINTDYNAMIC = &h00000004
const DDSCAPS2_HINTSTATIC = &h00000008
const DDSCAPS2_TEXTUREMANAGE = &h00000010
const DDSCAPS2_RESERVED1 = &h00000020
const DDSCAPS2_RESERVED2 = &h00000040
const DDSCAPS2_OPAQUE = &h00000080
const DDSCAPS2_HINTANTIALIASING = &h00000100
const DDSCAPS2_CUBEMAP = &h00000200
const DDSCAPS2_CUBEMAP_POSITIVEX = &h00000400
const DDSCAPS2_CUBEMAP_NEGATIVEX = &h00000800
const DDSCAPS2_CUBEMAP_POSITIVEY = &h00001000
const DDSCAPS2_CUBEMAP_NEGATIVEY = &h00002000
const DDSCAPS2_CUBEMAP_POSITIVEZ = &h00004000
const DDSCAPS2_CUBEMAP_NEGATIVEZ = &h00008000
const DDSCAPS2_CUBEMAP_ALLFACES = ((((DDSCAPS2_CUBEMAP_POSITIVEX or DDSCAPS2_CUBEMAP_NEGATIVEX) or DDSCAPS2_CUBEMAP_POSITIVEY) or DDSCAPS2_CUBEMAP_NEGATIVEY) or DDSCAPS2_CUBEMAP_POSITIVEZ) or DDSCAPS2_CUBEMAP_NEGATIVEZ
const DDSCAPS2_MIPMAPSUBLEVEL = &h00010000
const DDSCAPS2_D3DTEXTUREMANAGE = &h00020000
const DDSCAPS2_DONOTPERSIST = &h00040000
const DDSCAPS2_STEREOSURFACELEFT = &h00080000
const DDSCAPS2_VOLUME = &h00200000

type _DDSCAPS2
	dwCaps as DWORD
	dwCaps2 as DWORD
	dwCaps3 as DWORD

	union
		dwCaps4 as DWORD
		dwVolumeDepth as DWORD
	end union
end type

type DDSCAPS2 as _DDSCAPS2
type LPDDSCAPS2 as _DDSCAPS2 ptr

type _DDSCAPSEX
	dwCaps2 as DWORD
	dwCaps3 as DWORD

	union
		dwCaps4 as DWORD
		dwVolumeDepth as DWORD
	end union
end type

type DDSCAPSEX as _DDSCAPSEX
type LPDDSCAPSEX as _DDSCAPSEX ptr
const DD_ROP_SPACE = 256 / 32

type _DDCAPS_DX7
	dwSize as DWORD
	dwCaps as DWORD
	dwCaps2 as DWORD
	dwCKeyCaps as DWORD
	dwFXCaps as DWORD
	dwFXAlphaCaps as DWORD
	dwPalCaps as DWORD
	dwSVCaps as DWORD
	dwAlphaBltConstBitDepths as DWORD
	dwAlphaBltPixelBitDepths as DWORD
	dwAlphaBltSurfaceBitDepths as DWORD
	dwAlphaOverlayConstBitDepths as DWORD
	dwAlphaOverlayPixelBitDepths as DWORD
	dwAlphaOverlaySurfaceBitDepths as DWORD
	dwZBufferBitDepths as DWORD
	dwVidMemTotal as DWORD
	dwVidMemFree as DWORD
	dwMaxVisibleOverlays as DWORD
	dwCurrVisibleOverlays as DWORD
	dwNumFourCCCodes as DWORD
	dwAlignBoundarySrc as DWORD
	dwAlignSizeSrc as DWORD
	dwAlignBoundaryDest as DWORD
	dwAlignSizeDest as DWORD
	dwAlignStrideAlign as DWORD
	dwRops(0 to (256 / 32) - 1) as DWORD
	ddsOldCaps as DDSCAPS
	dwMinOverlayStretch as DWORD
	dwMaxOverlayStretch as DWORD
	dwMinLiveVideoStretch as DWORD
	dwMaxLiveVideoStretch as DWORD
	dwMinHwCodecStretch as DWORD
	dwMaxHwCodecStretch as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
	dwReserved3 as DWORD
	dwSVBCaps as DWORD
	dwSVBCKeyCaps as DWORD
	dwSVBFXCaps as DWORD
	dwSVBRops(0 to (256 / 32) - 1) as DWORD
	dwVSBCaps as DWORD
	dwVSBCKeyCaps as DWORD
	dwVSBFXCaps as DWORD
	dwVSBRops(0 to (256 / 32) - 1) as DWORD
	dwSSBCaps as DWORD
	dwSSBCKeyCaps as DWORD
	dwSSBFXCaps as DWORD
	dwSSBRops(0 to (256 / 32) - 1) as DWORD
	dwMaxVideoPorts as DWORD
	dwCurrVideoPorts as DWORD
	dwSVBCaps2 as DWORD
	dwNLVBCaps as DWORD
	dwNLVBCaps2 as DWORD
	dwNLVBCKeyCaps as DWORD
	dwNLVBFXCaps as DWORD
	dwNLVBRops(0 to (256 / 32) - 1) as DWORD
	ddsCaps as DDSCAPS2
end type

type DDCAPS_DX7 as _DDCAPS_DX7
type LPDDCAPS_DX7 as _DDCAPS_DX7 ptr

type _DDCAPS_DX6
	dwSize as DWORD
	dwCaps as DWORD
	dwCaps2 as DWORD
	dwCKeyCaps as DWORD
	dwFXCaps as DWORD
	dwFXAlphaCaps as DWORD
	dwPalCaps as DWORD
	dwSVCaps as DWORD
	dwAlphaBltConstBitDepths as DWORD
	dwAlphaBltPixelBitDepths as DWORD
	dwAlphaBltSurfaceBitDepths as DWORD
	dwAlphaOverlayConstBitDepths as DWORD
	dwAlphaOverlayPixelBitDepths as DWORD
	dwAlphaOverlaySurfaceBitDepths as DWORD
	dwZBufferBitDepths as DWORD
	dwVidMemTotal as DWORD
	dwVidMemFree as DWORD
	dwMaxVisibleOverlays as DWORD
	dwCurrVisibleOverlays as DWORD
	dwNumFourCCCodes as DWORD
	dwAlignBoundarySrc as DWORD
	dwAlignSizeSrc as DWORD
	dwAlignBoundaryDest as DWORD
	dwAlignSizeDest as DWORD
	dwAlignStrideAlign as DWORD
	dwRops(0 to (256 / 32) - 1) as DWORD
	ddsOldCaps as DDSCAPS
	dwMinOverlayStretch as DWORD
	dwMaxOverlayStretch as DWORD
	dwMinLiveVideoStretch as DWORD
	dwMaxLiveVideoStretch as DWORD
	dwMinHwCodecStretch as DWORD
	dwMaxHwCodecStretch as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
	dwReserved3 as DWORD
	dwSVBCaps as DWORD
	dwSVBCKeyCaps as DWORD
	dwSVBFXCaps as DWORD
	dwSVBRops(0 to (256 / 32) - 1) as DWORD
	dwVSBCaps as DWORD
	dwVSBCKeyCaps as DWORD
	dwVSBFXCaps as DWORD
	dwVSBRops(0 to (256 / 32) - 1) as DWORD
	dwSSBCaps as DWORD
	dwSSBCKeyCaps as DWORD
	dwSSBFXCaps as DWORD
	dwSSBRops(0 to (256 / 32) - 1) as DWORD
	dwMaxVideoPorts as DWORD
	dwCurrVideoPorts as DWORD
	dwSVBCaps2 as DWORD
	dwNLVBCaps as DWORD
	dwNLVBCaps2 as DWORD
	dwNLVBCKeyCaps as DWORD
	dwNLVBFXCaps as DWORD
	dwNLVBRops(0 to (256 / 32) - 1) as DWORD
	ddsCaps as DDSCAPS2
end type

type DDCAPS_DX6 as _DDCAPS_DX6
type LPDDCAPS_DX6 as _DDCAPS_DX6 ptr

type _DDCAPS_DX5
	dwSize as DWORD
	dwCaps as DWORD
	dwCaps2 as DWORD
	dwCKeyCaps as DWORD
	dwFXCaps as DWORD
	dwFXAlphaCaps as DWORD
	dwPalCaps as DWORD
	dwSVCaps as DWORD
	dwAlphaBltConstBitDepths as DWORD
	dwAlphaBltPixelBitDepths as DWORD
	dwAlphaBltSurfaceBitDepths as DWORD
	dwAlphaOverlayConstBitDepths as DWORD
	dwAlphaOverlayPixelBitDepths as DWORD
	dwAlphaOverlaySurfaceBitDepths as DWORD
	dwZBufferBitDepths as DWORD
	dwVidMemTotal as DWORD
	dwVidMemFree as DWORD
	dwMaxVisibleOverlays as DWORD
	dwCurrVisibleOverlays as DWORD
	dwNumFourCCCodes as DWORD
	dwAlignBoundarySrc as DWORD
	dwAlignSizeSrc as DWORD
	dwAlignBoundaryDest as DWORD
	dwAlignSizeDest as DWORD
	dwAlignStrideAlign as DWORD
	dwRops(0 to (256 / 32) - 1) as DWORD
	ddsCaps as DDSCAPS
	dwMinOverlayStretch as DWORD
	dwMaxOverlayStretch as DWORD
	dwMinLiveVideoStretch as DWORD
	dwMaxLiveVideoStretch as DWORD
	dwMinHwCodecStretch as DWORD
	dwMaxHwCodecStretch as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
	dwReserved3 as DWORD
	dwSVBCaps as DWORD
	dwSVBCKeyCaps as DWORD
	dwSVBFXCaps as DWORD
	dwSVBRops(0 to (256 / 32) - 1) as DWORD
	dwVSBCaps as DWORD
	dwVSBCKeyCaps as DWORD
	dwVSBFXCaps as DWORD
	dwVSBRops(0 to (256 / 32) - 1) as DWORD
	dwSSBCaps as DWORD
	dwSSBCKeyCaps as DWORD
	dwSSBFXCaps as DWORD
	dwSSBRops(0 to (256 / 32) - 1) as DWORD
	dwMaxVideoPorts as DWORD
	dwCurrVideoPorts as DWORD
	dwSVBCaps2 as DWORD
	dwNLVBCaps as DWORD
	dwNLVBCaps2 as DWORD
	dwNLVBCKeyCaps as DWORD
	dwNLVBFXCaps as DWORD
	dwNLVBRops(0 to (256 / 32) - 1) as DWORD
end type

type DDCAPS_DX5 as _DDCAPS_DX5
type LPDDCAPS_DX5 as _DDCAPS_DX5 ptr

type _DDCAPS_DX3
	dwSize as DWORD
	dwCaps as DWORD
	dwCaps2 as DWORD
	dwCKeyCaps as DWORD
	dwFXCaps as DWORD
	dwFXAlphaCaps as DWORD
	dwPalCaps as DWORD
	dwSVCaps as DWORD
	dwAlphaBltConstBitDepths as DWORD
	dwAlphaBltPixelBitDepths as DWORD
	dwAlphaBltSurfaceBitDepths as DWORD
	dwAlphaOverlayConstBitDepths as DWORD
	dwAlphaOverlayPixelBitDepths as DWORD
	dwAlphaOverlaySurfaceBitDepths as DWORD
	dwZBufferBitDepths as DWORD
	dwVidMemTotal as DWORD
	dwVidMemFree as DWORD
	dwMaxVisibleOverlays as DWORD
	dwCurrVisibleOverlays as DWORD
	dwNumFourCCCodes as DWORD
	dwAlignBoundarySrc as DWORD
	dwAlignSizeSrc as DWORD
	dwAlignBoundaryDest as DWORD
	dwAlignSizeDest as DWORD
	dwAlignStrideAlign as DWORD
	dwRops(0 to (256 / 32) - 1) as DWORD
	ddsCaps as DDSCAPS
	dwMinOverlayStretch as DWORD
	dwMaxOverlayStretch as DWORD
	dwMinLiveVideoStretch as DWORD
	dwMaxLiveVideoStretch as DWORD
	dwMinHwCodecStretch as DWORD
	dwMaxHwCodecStretch as DWORD
	dwReserved1 as DWORD
	dwReserved2 as DWORD
	dwReserved3 as DWORD
	dwSVBCaps as DWORD
	dwSVBCKeyCaps as DWORD
	dwSVBFXCaps as DWORD
	dwSVBRops(0 to (256 / 32) - 1) as DWORD
	dwVSBCaps as DWORD
	dwVSBCKeyCaps as DWORD
	dwVSBFXCaps as DWORD
	dwVSBRops(0 to (256 / 32) - 1) as DWORD
	dwSSBCaps as DWORD
	dwSSBCKeyCaps as DWORD
	dwSSBFXCaps as DWORD
	dwSSBRops(0 to (256 / 32) - 1) as DWORD
	dwReserved4 as DWORD
	dwReserved5 as DWORD
	dwReserved6 as DWORD
end type

type DDCAPS_DX3 as _DDCAPS_DX3
type LPDDCAPS_DX3 as _DDCAPS_DX3 ptr
type DDCAPS as DDCAPS_DX7
type LPDDCAPS as DDCAPS ptr

const DDCAPS_3D = &h00000001
const DDCAPS_ALIGNBOUNDARYDEST = &h00000002
const DDCAPS_ALIGNSIZEDEST = &h00000004
const DDCAPS_ALIGNBOUNDARYSRC = &h00000008
const DDCAPS_ALIGNSIZESRC = &h00000010
const DDCAPS_ALIGNSTRIDE = &h00000020
const DDCAPS_BLT = &h00000040
const DDCAPS_BLTQUEUE = &h00000080
const DDCAPS_BLTFOURCC = &h00000100
const DDCAPS_BLTSTRETCH = &h00000200
const DDCAPS_GDI = &h00000400
const DDCAPS_OVERLAY = &h00000800
const DDCAPS_OVERLAYCANTCLIP = &h00001000
const DDCAPS_OVERLAYFOURCC = &h00002000
const DDCAPS_OVERLAYSTRETCH = &h00004000
const DDCAPS_PALETTE = &h00008000
const DDCAPS_PALETTEVSYNC = &h00010000
const DDCAPS_READSCANLINE = &h00020000
const DDCAPS_STEREOVIEW = &h00040000
const DDCAPS_VBI = &h00080000
const DDCAPS_ZBLTS = &h00100000
const DDCAPS_ZOVERLAYS = &h00200000
const DDCAPS_COLORKEY = &h00400000
const DDCAPS_ALPHA = &h00800000
const DDCAPS_COLORKEYHWASSIST = &h01000000
const DDCAPS_NOHARDWARE = &h02000000
const DDCAPS_BLTCOLORFILL = &h04000000
const DDCAPS_BANKSWITCHED = &h08000000
const DDCAPS_BLTDEPTHFILL = &h10000000
const DDCAPS_CANCLIP = &h20000000
const DDCAPS_CANCLIPSTRETCHED = &h40000000
const DDCAPS_CANBLTSYSMEM = &h80000000
const DDCAPS2_CERTIFIED = &h00000001
const DDCAPS2_NO2DDURING3DSCENE = &h00000002
const DDCAPS2_VIDEOPORT = &h00000004
const DDCAPS2_AUTOFLIPOVERLAY = &h00000008
const DDCAPS2_CANBOBINTERLEAVED = &h00000010
const DDCAPS2_CANBOBNONINTERLEAVED = &h00000020
const DDCAPS2_COLORCONTROLOVERLAY = &h00000040
const DDCAPS2_COLORCONTROLPRIMARY = &h00000080
const DDCAPS2_CANDROPZ16BIT = &h00000100
const DDCAPS2_NONLOCALVIDMEM = &h00000200
const DDCAPS2_NONLOCALVIDMEMCAPS = &h00000400
const DDCAPS2_NOPAGELOCKREQUIRED = &h00000800
const DDCAPS2_WIDESURFACES = &h00001000
const DDCAPS2_CANFLIPODDEVEN = &h00002000
const DDCAPS2_CANBOBHARDWARE = &h00004000
const DDCAPS2_COPYFOURCC = &h00008000
const DDCAPS2_PRIMARYGAMMA = &h00020000
const DDCAPS2_CANRENDERWINDOWED = &h00080000
const DDCAPS2_CANCALIBRATEGAMMA = &h00100000
const DDCAPS2_FLIPINTERVAL = &h00200000
const DDCAPS2_FLIPNOVSYNC = &h00400000
const DDCAPS2_CANMANAGETEXTURE = &h00800000
const DDCAPS2_TEXMANINNONLOCALVIDMEM = &h01000000
const DDCAPS2_STEREO = &h02000000
const DDCAPS2_SYSTONONLOCAL_AS_SYSTOLOCAL = &h04000000
const DDCKEY_COLORSPACE = &h00000001
const DDCKEY_DESTBLT = &h00000002
const DDCKEY_DESTOVERLAY = &h00000004
const DDCKEY_SRCBLT = &h00000008
const DDCKEY_SRCOVERLAY = &h00000010

type _DDCOLORKEY
	dwColorSpaceLowValue as DWORD
	dwColorSpaceHighValue as DWORD
end type

type DDCOLORKEY as _DDCOLORKEY
type LPDDCOLORKEY as _DDCOLORKEY ptr
const DDCKEYCAPS_DESTBLT = &h00000001
const DDCKEYCAPS_DESTBLTCLRSPACE = &h00000002
const DDCKEYCAPS_DESTBLTCLRSPACEYUV = &h00000004
const DDCKEYCAPS_DESTBLTYUV = &h00000008
const DDCKEYCAPS_DESTOVERLAY = &h00000010
const DDCKEYCAPS_DESTOVERLAYCLRSPACE = &h00000020
const DDCKEYCAPS_DESTOVERLAYCLRSPACEYUV = &h00000040
const DDCKEYCAPS_DESTOVERLAYONEACTIVE = &h00000080
const DDCKEYCAPS_DESTOVERLAYYUV = &h00000100
const DDCKEYCAPS_SRCBLT = &h00000200
const DDCKEYCAPS_SRCBLTCLRSPACE = &h00000400
const DDCKEYCAPS_SRCBLTCLRSPACEYUV = &h00000800
const DDCKEYCAPS_SRCBLTYUV = &h00001000
const DDCKEYCAPS_SRCOVERLAY = &h00002000
const DDCKEYCAPS_SRCOVERLAYCLRSPACE = &h00004000
const DDCKEYCAPS_SRCOVERLAYCLRSPACEYUV = &h00008000
const DDCKEYCAPS_SRCOVERLAYONEACTIVE = &h00010000
const DDCKEYCAPS_SRCOVERLAYYUV = &h00020000
const DDCKEYCAPS_NOCOSTOVERLAY = &h00040000

type _DDPIXELFORMAT
	dwSize as DWORD
	dwFlags as DWORD
	dwFourCC as DWORD

	union
		dwRGBBitCount as DWORD
		dwYUVBitCount as DWORD
		dwZBufferBitDepth as DWORD
		dwAlphaBitDepth as DWORD
		dwLuminanceBitCount as DWORD
		dwBumpBitCount as DWORD
	end union

	union
		dwRBitMask as DWORD
		dwYBitMask as DWORD
		dwStencilBitDepth as DWORD
		dwLuminanceBitMask as DWORD
		dwBumpDuBitMask as DWORD
	end union

	union
		dwGBitMask as DWORD
		dwUBitMask as DWORD
		dwZBitMask as DWORD
		dwBumpDvBitMask as DWORD
	end union

	union
		dwBBitMask as DWORD
		dwVBitMask as DWORD
		dwStencilBitMask as DWORD
		dwBumpLuminanceBitMask as DWORD
	end union

	union
		dwRGBAlphaBitMask as DWORD
		dwYUVAlphaBitMask as DWORD
		dwLuminanceAlphaBitMask as DWORD
		dwRGBZBitMask as DWORD
		dwYUVZBitMask as DWORD
	end union
end type

type DDPIXELFORMAT as _DDPIXELFORMAT
type LPDDPIXELFORMAT as _DDPIXELFORMAT ptr
const DDFXCAPS_BLTALPHA = &h00000001
const DDFXCAPS_OVERLAYALPHA = &h00000004
const DDFXCAPS_BLTARITHSTRETCHYN = &h00000010
const DDFXCAPS_BLTARITHSTRETCHY = &h00000020
const DDFXCAPS_BLTMIRRORLEFTRIGHT = &h00000040
const DDFXCAPS_BLTMIRRORUPDOWN = &h00000080
const DDFXCAPS_BLTROTATION = &h00000100
const DDFXCAPS_BLTROTATION90 = &h00000200
const DDFXCAPS_BLTSHRINKX = &h00000400
const DDFXCAPS_BLTSHRINKXN = &h00000800
const DDFXCAPS_BLTSHRINKY = &h00001000
const DDFXCAPS_BLTSHRINKYN = &h00002000
const DDFXCAPS_BLTSTRETCHX = &h00004000
const DDFXCAPS_BLTSTRETCHXN = &h00008000
const DDFXCAPS_BLTSTRETCHY = &h00010000
const DDFXCAPS_BLTSTRETCHYN = &h00020000
const DDFXCAPS_OVERLAYARITHSTRETCHY = &h00040000
const DDFXCAPS_OVERLAYARITHSTRETCHYN = &h00000008
const DDFXCAPS_OVERLAYSHRINKX = &h00080000
const DDFXCAPS_OVERLAYSHRINKXN = &h00100000
const DDFXCAPS_OVERLAYSHRINKY = &h00200000
const DDFXCAPS_OVERLAYSHRINKYN = &h00400000
const DDFXCAPS_OVERLAYSTRETCHX = &h00800000
const DDFXCAPS_OVERLAYSTRETCHXN = &h01000000
const DDFXCAPS_OVERLAYSTRETCHY = &h02000000
const DDFXCAPS_OVERLAYSTRETCHYN = &h04000000
const DDFXCAPS_OVERLAYMIRRORLEFTRIGHT = &h08000000
const DDFXCAPS_OVERLAYMIRRORUPDOWN = &h10000000
const DDFXCAPS_OVERLAYFILTER = DDFXCAPS_OVERLAYARITHSTRETCHY
const DDFXALPHACAPS_BLTALPHAEDGEBLEND = &h00000001
const DDFXALPHACAPS_BLTALPHAPIXELS = &h00000002
const DDFXALPHACAPS_BLTALPHAPIXELSNEG = &h00000004
const DDFXALPHACAPS_BLTALPHASURFACES = &h00000008
const DDFXALPHACAPS_BLTALPHASURFACESNEG = &h00000010
const DDFXALPHACAPS_OVERLAYALPHAEDGEBLEND = &h00000020
const DDFXALPHACAPS_OVERLAYALPHAPIXELS = &h00000040
const DDFXALPHACAPS_OVERLAYALPHAPIXELSNEG = &h00000080
const DDFXALPHACAPS_OVERLAYALPHASURFACES = &h00000100
const DDFXALPHACAPS_OVERLAYALPHASURFACESNEG = &h00000200
const DDPCAPS_4BIT = &h00000001
const DDPCAPS_8BITENTRIES = &h00000002
const DDPCAPS_8BIT = &h00000004
const DDPCAPS_INITIALIZE = &h00000008
const DDPCAPS_PRIMARYSURFACE = &h00000010
const DDPCAPS_PRIMARYSURFACELEFT = &h00000020
const DDPCAPS_ALLOW256 = &h00000040
const DDPCAPS_VSYNC = &h00000080
const DDPCAPS_1BIT = &h00000100
const DDPCAPS_2BIT = &h00000200
const DDPCAPS_ALPHA = &h00000400
const DDSVCAPS_RESERVED1 = &h00000001
const DDSVCAPS_RESERVED2 = &h00000002
const DDSVCAPS_RESERVED3 = &h00000004
const DDSVCAPS_RESERVED4 = &h00000008
const DDSVCAPS_STEREOSEQUENTIAL = &h00000010
const DDBD_1 = &h00004000
const DDBD_2 = &h00002000
const DDBD_4 = &h00001000
const DDBD_8 = &h00000800
const DDBD_16 = &h00000400
const DDBD_24 = &h00000200
const DDBD_32 = &h00000100
const DDOVERFX_ARITHSTRETCHY = &h00000001
const DDOVERFX_MIRRORLEFTRIGHT = &h00000002
const DDOVERFX_MIRRORUPDOWN = &h00000004
const DDOVER_ALPHADEST = &h00000001
const DDOVER_ALPHADESTCONSTOVERRIDE = &h00000002
const DDOVER_ALPHADESTNEG = &h00000004
const DDOVER_ALPHADESTSURFACEOVERRIDE = &h00000008
const DDOVER_ALPHAEDGEBLEND = &h00000010
const DDOVER_ALPHASRC = &h00000020
const DDOVER_ALPHASRCCONSTOVERRIDE = &h00000040
const DDOVER_ALPHASRCNEG = &h00000080
const DDOVER_ALPHASRCSURFACEOVERRIDE = &h00000100
const DDOVER_HIDE = &h00000200
const DDOVER_KEYDEST = &h00000400
const DDOVER_KEYDESTOVERRIDE = &h00000800
const DDOVER_KEYSRC = &h00001000
const DDOVER_KEYSRCOVERRIDE = &h00002000
const DDOVER_SHOW = &h00004000
const DDOVER_ADDDIRTYRECT = &h00008000
const DDOVER_REFRESHDIRTYRECTS = &h00010000
const DDOVER_REFRESHALL = &h00020000
const DDOVER_DDFX = &h00080000
const DDOVER_AUTOFLIP = &h00100000
const DDOVER_BOB = &h00200000
const DDOVER_OVERRIDEBOBWEAVE = &h00400000
const DDOVER_INTERLEAVED = &h00800000
const DDPF_ALPHAPIXELS = &h00000001
const DDPF_ALPHA = &h00000002
const DDPF_FOURCC = &h00000004
const DDPF_PALETTEINDEXED4 = &h00000008
const DDPF_PALETTEINDEXEDTO8 = &h00000010
const DDPF_PALETTEINDEXED8 = &h00000020
const DDPF_RGB = &h00000040
const DDPF_COMPRESSED = &h00000080
const DDPF_RGBTOYUV = &h00000100
const DDPF_YUV = &h00000200
const DDPF_ZBUFFER = &h00000400
const DDPF_PALETTEINDEXED1 = &h00000800
const DDPF_PALETTEINDEXED2 = &h00001000
const DDPF_ZPIXELS = &h00002000
const DDPF_STENCILBUFFER = &h00004000
const DDPF_ALPHAPREMULT = &h00008000
const DDPF_LUMINANCE = &h00020000
const DDPF_BUMPLUMINANCE = &h00040000
const DDPF_BUMPDUDV = &h00080000
const DDSCL_FULLSCREEN = &h00000001
const DDSCL_ALLOWREBOOT = &h00000002
const DDSCL_NOWINDOWCHANGES = &h00000004
const DDSCL_NORMAL = &h00000008
const DDSCL_EXCLUSIVE = &h00000010
const DDSCL_ALLOWMODEX = &h00000040
const DDSCL_SETFOCUSWINDOW = &h00000080
const DDSCL_SETDEVICEWINDOW = &h00000100
const DDSCL_CREATEDEVICEWINDOW = &h00000200
const DDSCL_MULTITHREADED = &h00000400
const DDSCL_FPUSETUP = &h00000800
const DDSCL_FPUPRESERVE = &h00001000
const DDSD_CAPS = &h00000001
const DDSD_HEIGHT = &h00000002
const DDSD_WIDTH = &h00000004
const DDSD_PITCH = &h00000008
const DDSD_BACKBUFFERCOUNT = &h00000020
const DDSD_ZBUFFERBITDEPTH = &h00000040
const DDSD_ALPHABITDEPTH = &h00000080
const DDSD_LPSURFACE = &h00000800
const DDSD_PIXELFORMAT = &h00001000
const DDSD_CKDESTOVERLAY = &h00002000
const DDSD_CKDESTBLT = &h00004000
const DDSD_CKSRCOVERLAY = &h00008000
const DDSD_CKSRCBLT = &h00010000
const DDSD_MIPMAPCOUNT = &h00020000
const DDSD_REFRESHRATE = &h00040000
const DDSD_LINEARSIZE = &h00080000
const DDSD_TEXTURESTAGE = &h00100000
const DDSD_FVF = &h00200000
const DDSD_SRCVBHANDLE = &h00400000
const DDSD_DEPTH = &h00800000
const DDSD_ALL = &h00fff9ee
const DDENUMSURFACES_ALL = &h00000001
const DDENUMSURFACES_MATCH = &h00000002
const DDENUMSURFACES_NOMATCH = &h00000004
const DDENUMSURFACES_CANBECREATED = &h00000008
const DDENUMSURFACES_DOESEXIST = &h00000010
const DDSDM_STANDARDVGAMODE = &h00000001
const DDEDM_REFRESHRATES = &h00000001
const DDEDM_STANDARDVGAMODES = &h00000002
const DDWAITVB_BLOCKBEGIN = &h00000001
const DDWAITVB_BLOCKBEGINEVENT = &h00000002
const DDWAITVB_BLOCKEND = &h00000004

type _DDSURFACEDESC
	dwSize as DWORD
	dwFlags as DWORD
	dwHeight as DWORD
	dwWidth as DWORD

	union
		lPitch as LONG
		dwLinearSize as DWORD
	end union

	dwBackBufferCount as DWORD

	union
		dwMipMapCount as DWORD
		dwZBufferBitDepth as DWORD
		dwRefreshRate as DWORD
	end union

	dwAlphaBitDepth as DWORD
	dwReserved as DWORD
	lpSurface as LPVOID
	ddckCKDestOverlay as DDCOLORKEY
	ddckCKDestBlt as DDCOLORKEY
	ddckCKSrcOverlay as DDCOLORKEY
	ddckCKSrcBlt as DDCOLORKEY
	ddpfPixelFormat as DDPIXELFORMAT
	ddsCaps as DDSCAPS
end type

type DDSURFACEDESC as _DDSURFACEDESC
type LPDDSURFACEDESC as _DDSURFACEDESC ptr

type _DDSURFACEDESC2
	dwSize as DWORD
	dwFlags as DWORD
	dwHeight as DWORD
	dwWidth as DWORD

	union
		lPitch as LONG
		dwLinearSize as DWORD
	end union

	union
		dwBackBufferCount as DWORD
		dwDepth as DWORD
	end union

	union
		dwMipMapCount as DWORD
		dwRefreshRate as DWORD
		dwSrcVBHandle as DWORD
	end union

	dwAlphaBitDepth as DWORD
	dwReserved as DWORD
	lpSurface as LPVOID

	union
		ddckCKDestOverlay as DDCOLORKEY
		dwEmptyFaceColor as DWORD
	end union

	ddckCKDestBlt as DDCOLORKEY
	ddckCKSrcOverlay as DDCOLORKEY
	ddckCKSrcBlt as DDCOLORKEY

	union
		ddpfPixelFormat as DDPIXELFORMAT
		dwFVF as DWORD
	end union

	ddsCaps as DDSCAPS2
	dwTextureStage as DWORD
end type

type DDSURFACEDESC2 as _DDSURFACEDESC2
type LPDDSURFACEDESC2 as _DDSURFACEDESC2 ptr

type _DDARGB
	blue as UBYTE
	green as UBYTE
	red as UBYTE
	alpha as UBYTE
end type

type DDARGB as _DDARGB
type LPDDARGB as _DDARGB ptr

type _DDRGBA
	red as UBYTE
	green as UBYTE
	blue as UBYTE
	alpha as UBYTE
end type

type DDRGBA as _DDRGBA
type LPDDRGBA as _DDRGBA ptr
const DDCOLOR_BRIGHTNESS = &h00000001
const DDCOLOR_CONTRAST = &h00000002
const DDCOLOR_HUE = &h00000004
const DDCOLOR_SATURATION = &h00000008
const DDCOLOR_SHARPNESS = &h00000010
const DDCOLOR_GAMMA = &h00000020
const DDCOLOR_COLORENABLE = &h00000040

type DDCOLORCONTROL
	dwSize as DWORD
	dwFlags as DWORD
	lBrightness as LONG
	lContrast as LONG
	lHue as LONG
	lSaturation as LONG
	lSharpness as LONG
	lGamma as LONG
	lColorEnable as LONG
	dwReserved1 as DWORD
end type

type LPDDCOLORCONTROL as DDCOLORCONTROL ptr

type DDGAMMARAMP
	red(0 to 255) as WORD
	green(0 to 255) as WORD
	blue(0 to 255) as WORD
end type

type LPDDGAMMARAMP as DDGAMMARAMP ptr
type LPDDENUMCALLBACKA as function(byval as GUID ptr, byval as LPSTR, byval as LPSTR, byval as LPVOID) as BOOL
type LPDDENUMCALLBACKW as function(byval as GUID ptr, byval as LPWSTR, byval as LPWSTR, byval as LPVOID) as BOOL

#ifdef UNICODE
	type LPDDENUMCALLBACK as LPDDENUMCALLBACKW
#else
	type LPDDENUMCALLBACK as LPDDENUMCALLBACKA
#endif

type LPDDENUMMODESCALLBACK as function(byval as LPDDSURFACEDESC, byval as LPVOID) as HRESULT
type LPDDENUMMODESCALLBACK2 as function(byval as LPDDSURFACEDESC2, byval as LPVOID) as HRESULT
type LPDDENUMSURFACESCALLBACK as function(byval as LPDIRECTDRAWSURFACE, byval as LPDDSURFACEDESC, byval as LPVOID) as HRESULT
type LPDDENUMSURFACESCALLBACK2 as function(byval as LPDIRECTDRAWSURFACE4, byval as LPDDSURFACEDESC2, byval as LPVOID) as HRESULT
type LPDDENUMSURFACESCALLBACK7 as function(byval as LPDIRECTDRAWSURFACE7, byval as LPDDSURFACEDESC2, byval as LPVOID) as HRESULT
type LPDDENUMCALLBACKEXA as function(byval as GUID ptr, byval as LPSTR, byval as LPSTR, byval as LPVOID, byval as HMONITOR) as BOOL
type LPDDENUMCALLBACKEXW as function(byval as GUID ptr, byval as LPWSTR, byval as LPWSTR, byval as LPVOID, byval as HMONITOR) as BOOL

#ifdef UNICODE
	type LPDDENUMCALLBACKEX as LPDDENUMCALLBACKEXW
#else
	type LPDDENUMCALLBACKEX as LPDDENUMCALLBACKEXA
#endif

declare function DirectDrawEnumerateA(byval as LPDDENUMCALLBACKA, byval as LPVOID) as HRESULT
declare function DirectDrawEnumerateW(byval as LPDDENUMCALLBACKW, byval as LPVOID) as HRESULT

#ifdef UNICODE
	declare function DirectDrawEnumerate alias "DirectDrawEnumerateW"(byval as LPDDENUMCALLBACKW, byval as LPVOID) as HRESULT
#else
	declare function DirectDrawEnumerate alias "DirectDrawEnumerateA"(byval as LPDDENUMCALLBACKA, byval as LPVOID) as HRESULT
#endif

declare function DirectDrawEnumerateExA(byval lpCallback as LPDDENUMCALLBACKEXA, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT
declare function DirectDrawEnumerateExW(byval lpCallback as LPDDENUMCALLBACKEXW, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT

#ifdef UNICODE
	declare function DirectDrawEnumerateEx alias "DirectDrawEnumerateExW"(byval lpCallback as LPDDENUMCALLBACKEXW, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT
#else
	declare function DirectDrawEnumerateEx alias "DirectDrawEnumerateExA"(byval lpCallback as LPDDENUMCALLBACKEXA, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT
#endif

type LPDIRECTDRAWENUMERATEEXA as function(byval lpCallback as LPDDENUMCALLBACKEXA, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT
type LPDIRECTDRAWENUMERATEEXW as function(byval lpCallback as LPDDENUMCALLBACKEXW, byval lpContext as LPVOID, byval dwFlags as DWORD) as HRESULT

#ifdef UNICODE
	type LPDIRECTDRAWENUMERATEEX as LPDIRECTDRAWENUMERATEEXW
#else
	type LPDIRECTDRAWENUMERATEEX as LPDIRECTDRAWENUMERATEEXA
#endif

const DDENUM_ATTACHEDSECONDARYDEVICES = &h00000001
const DDENUM_DETACHEDSECONDARYDEVICES = &h00000002
const DDENUM_NONDISPLAYDEVICES = &h00000004
const DDCREATE_HARDWAREONLY = 1
const DDCREATE_EMULATIONONLY = 2

type _DDBLTFX
	dwSize as DWORD
	dwDDFX as DWORD
	dwROP as DWORD
	dwDDROP as DWORD
	dwRotationAngle as DWORD
	dwZBufferOpCode as DWORD
	dwZBufferLow as DWORD
	dwZBufferHigh as DWORD
	dwZBufferBaseDest as DWORD
	dwZDestConstBitDepth as DWORD

	union
		dwZDestConst as DWORD
		lpDDSZBufferDest as LPDIRECTDRAWSURFACE
	end union

	dwZSrcConstBitDepth as DWORD

	union
		dwZSrcConst as DWORD
		lpDDSZBufferSrc as LPDIRECTDRAWSURFACE
	end union

	dwAlphaEdgeBlendBitDepth as DWORD
	dwAlphaEdgeBlend as DWORD
	dwReserved as DWORD
	dwAlphaDestConstBitDepth as DWORD

	union
		dwAlphaDestConst as DWORD
		lpDDSAlphaDest as LPDIRECTDRAWSURFACE
	end union

	dwAlphaSrcConstBitDepth as DWORD

	union
		dwAlphaSrcConst as DWORD
		lpDDSAlphaSrc as LPDIRECTDRAWSURFACE
	end union

	union
		dwFillColor as DWORD
		dwFillDepth as DWORD
		dwFillPixel as DWORD
		lpDDSPattern as LPDIRECTDRAWSURFACE
	end union

	ddckDestColorkey as DDCOLORKEY
	ddckSrcColorkey as DDCOLORKEY
end type

type DDBLTFX as _DDBLTFX
type LPDDBLTFX as _DDBLTFX ptr
const DDBLTFX_ARITHSTRETCHY = &h00000001
const DDBLTFX_MIRRORLEFTRIGHT = &h00000002
const DDBLTFX_MIRRORUPDOWN = &h00000004
const DDBLTFX_NOTEARING = &h00000008
const DDBLTFX_ROTATE180 = &h00000010
const DDBLTFX_ROTATE270 = &h00000020
const DDBLTFX_ROTATE90 = &h00000040
const DDBLTFX_ZBUFFERRANGE = &h00000080
const DDBLTFX_ZBUFFERBASEDEST = &h00000100

type _DDOVERLAYFX
	dwSize as DWORD
	dwAlphaEdgeBlendBitDepth as DWORD
	dwAlphaEdgeBlend as DWORD
	dwReserved as DWORD
	dwAlphaDestConstBitDepth as DWORD

	union
		dwAlphaDestConst as DWORD
		lpDDSAlphaDest as LPDIRECTDRAWSURFACE
	end union

	dwAlphaSrcConstBitDepth as DWORD

	union
		dwAlphaSrcConst as DWORD
		lpDDSAlphaSrc as LPDIRECTDRAWSURFACE
	end union

	dckDestColorkey as DDCOLORKEY
	dckSrcColorkey as DDCOLORKEY
	dwDDFX as DWORD
	dwFlags as DWORD
end type

type DDOVERLAYFX as _DDOVERLAYFX
type LPDDOVERLAYFX as _DDOVERLAYFX ptr

type _DDBLTBATCH
	lprDest as LPRECT
	lpDDSSrc as LPDIRECTDRAWSURFACE
	lprSrc as LPRECT
	dwFlags as DWORD
	lpDDBltFx as LPDDBLTFX
end type

type DDBLTBATCH as _DDBLTBATCH
type LPDDBLTBATCH as _DDBLTBATCH ptr
const MAX_DDDEVICEID_STRING = 512
const DDGDI_GETHOSTIDENTIFIER = 1

type tagDDDEVICEIDENTIFIER
	szDriver as zstring * 512
	szDescription as zstring * 512
	liDriverVersion as LARGE_INTEGER
	dwVendorId as DWORD
	dwDeviceId as DWORD
	dwSubSysId as DWORD
	dwRevision as DWORD
	guidDeviceIdentifier as GUID
end type

type DDDEVICEIDENTIFIER as tagDDDEVICEIDENTIFIER
type LPDDDEVICEIDENTIFIER as tagDDDEVICEIDENTIFIER ptr

type tagDDDEVICEIDENTIFIER2
	szDriver as zstring * 512
	szDescription as zstring * 512
	liDriverVersion as LARGE_INTEGER
	dwVendorId as DWORD
	dwDeviceId as DWORD
	dwSubSysId as DWORD
	dwRevision as DWORD
	guidDeviceIdentifier as GUID
	dwWHQLLevel as DWORD
end type

type DDDEVICEIDENTIFIER2 as tagDDDEVICEIDENTIFIER2
type LPDDDEVICEIDENTIFIER2 as tagDDDEVICEIDENTIFIER2 ptr
type IDirectDrawPaletteVtbl as IDirectDrawPaletteVtbl_

type IDirectDrawPalette
	lpVtbl as IDirectDrawPaletteVtbl ptr
end type

type IDirectDrawPaletteVtbl_
	QueryInterface as function(byval This as IDirectDrawPalette ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawPalette ptr) as ULONG
	Release as function(byval This as IDirectDrawPalette ptr) as ULONG
	GetCaps as function(byval This as IDirectDrawPalette ptr, byval lpdwCaps as LPDWORD) as HRESULT
	GetEntries as function(byval This as IDirectDrawPalette ptr, byval dwFlags as DWORD, byval dwBase as DWORD, byval dwNumEntries as DWORD, byval lpEntries as LPPALETTEENTRY) as HRESULT
	Initialize as function(byval This as IDirectDrawPalette ptr, byval lpDD as LPDIRECTDRAW, byval dwFlags as DWORD, byval lpDDColorTable as LPPALETTEENTRY) as HRESULT
	SetEntries as function(byval This as IDirectDrawPalette ptr, byval dwFlags as DWORD, byval dwStartingEntry as DWORD, byval dwCount as DWORD, byval lpEntries as LPPALETTEENTRY) as HRESULT
end type

#define IDirectDrawPalette_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawPalette_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawPalette_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawPalette_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawPalette_GetEntries(p, a, b, c, d) (p)->lpVtbl->GetEntries(p, a, b, c, d)
#define IDirectDrawPalette_Initialize(p, a, b, c) (p)->lpVtbl->Initialize(p, a, b, c)
#define IDirectDrawPalette_SetEntries(p, a, b, c, d) (p)->lpVtbl->SetEntries(p, a, b, c, d)
type IDirectDrawClipperVtbl as IDirectDrawClipperVtbl_

type IDirectDrawClipper
	lpVtbl as IDirectDrawClipperVtbl ptr
end type

type IDirectDrawClipperVtbl_
	QueryInterface as function(byval This as IDirectDrawClipper ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawClipper ptr) as ULONG
	Release as function(byval This as IDirectDrawClipper ptr) as ULONG
	GetClipList as function(byval This as IDirectDrawClipper ptr, byval lpRect as LPRECT, byval lpClipList as LPRGNDATA, byval lpdwSize as LPDWORD) as HRESULT
	GetHWnd as function(byval This as IDirectDrawClipper ptr, byval lphWnd as HWND ptr) as HRESULT
	Initialize as function(byval This as IDirectDrawClipper ptr, byval lpDD as LPDIRECTDRAW, byval dwFlags as DWORD) as HRESULT
	IsClipListChanged as function(byval This as IDirectDrawClipper ptr, byval lpbChanged as BOOL ptr) as HRESULT
	SetClipList as function(byval This as IDirectDrawClipper ptr, byval lpClipList as LPRGNDATA, byval dwFlags as DWORD) as HRESULT
	SetHWnd as function(byval This as IDirectDrawClipper ptr, byval dwFlags as DWORD, byval hWnd as HWND) as HRESULT
end type

#define IDirectDrawClipper_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawClipper_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawClipper_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawClipper_GetClipList(p, a, b, c) (p)->lpVtbl->GetClipList(p, a, b, c)
#define IDirectDrawClipper_GetHWnd(p, a) (p)->lpVtbl->GetHWnd(p, a)
#define IDirectDrawClipper_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawClipper_IsClipListChanged(p, a) (p)->lpVtbl->IsClipListChanged(p, a)
#define IDirectDrawClipper_SetClipList(p, a, b) (p)->lpVtbl->SetClipList(p, a, b)
#define IDirectDrawClipper_SetHWnd(p, a, b) (p)->lpVtbl->SetHWnd(p, a, b)
type IDirectDrawVtbl as IDirectDrawVtbl_

type IDirectDraw
	lpVtbl as IDirectDrawVtbl ptr
end type

type IDirectDrawVtbl_
	QueryInterface as function(byval This as IDirectDraw ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDraw ptr) as ULONG
	Release as function(byval This as IDirectDraw ptr) as ULONG
	Compact as function(byval This as IDirectDraw ptr) as HRESULT
	CreateClipper as function(byval This as IDirectDraw ptr, byval dwFlags as DWORD, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreatePalette as function(byval This as IDirectDraw ptr, byval dwFlags as DWORD, byval lpColorTable as LPPALETTEENTRY, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreateSurface as function(byval This as IDirectDraw ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lplpDDSurface as LPDIRECTDRAWSURFACE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	DuplicateSurface as function(byval This as IDirectDraw ptr, byval lpDDSurface as LPDIRECTDRAWSURFACE, byval lplpDupDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	EnumDisplayModes as function(byval This as IDirectDraw ptr, byval dwFlags as DWORD, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumModesCallback as LPDDENUMMODESCALLBACK) as HRESULT
	EnumSurfaces as function(byval This as IDirectDraw ptr, byval dwFlags as DWORD, byval lpDDSD as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	FlipToGDISurface as function(byval This as IDirectDraw ptr) as HRESULT
	GetCaps as function(byval This as IDirectDraw ptr, byval lpDDDriverCaps as LPDDCAPS, byval lpDDHELCaps as LPDDCAPS) as HRESULT
	GetDisplayMode as function(byval This as IDirectDraw ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	GetFourCCCodes as function(byval This as IDirectDraw ptr, byval lpNumCodes as LPDWORD, byval lpCodes as LPDWORD) as HRESULT
	GetGDISurface as function(byval This as IDirectDraw ptr, byval lplpGDIDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	GetMonitorFrequency as function(byval This as IDirectDraw ptr, byval lpdwFrequency as LPDWORD) as HRESULT
	GetScanLine as function(byval This as IDirectDraw ptr, byval lpdwScanLine as LPDWORD) as HRESULT
	GetVerticalBlankStatus as function(byval This as IDirectDraw ptr, byval lpbIsInVB as BOOL ptr) as HRESULT
	Initialize as function(byval This as IDirectDraw ptr, byval lpGUID as GUID ptr) as HRESULT
	RestoreDisplayMode as function(byval This as IDirectDraw ptr) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectDraw ptr, byval hWnd as HWND, byval dwFlags as DWORD) as HRESULT
	SetDisplayMode as function(byval This as IDirectDraw ptr, byval dwWidth as DWORD, byval dwHeight as DWORD, byval dwBPP as DWORD) as HRESULT
	WaitForVerticalBlank as function(byval This as IDirectDraw ptr, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
end type

#define IDirectDraw_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDraw_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDraw_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDraw_Compact(p) (p)->lpVtbl->Compact(p)
#define IDirectDraw_CreateClipper(p, a, b, c) (p)->lpVtbl->CreateClipper(p, a, b, c)
#define IDirectDraw_CreatePalette(p, a, b, c, d) (p)->lpVtbl->CreatePalette(p, a, b, c, d)
#define IDirectDraw_CreateSurface(p, a, b, c) (p)->lpVtbl->CreateSurface(p, a, b, c)
#define IDirectDraw_DuplicateSurface(p, a, b) (p)->lpVtbl->DuplicateSurface(p, a, b)
#define IDirectDraw_EnumDisplayModes(p, a, b, c, d) (p)->lpVtbl->EnumDisplayModes(p, a, b, c, d)
#define IDirectDraw_EnumSurfaces(p, a, b, c, d) (p)->lpVtbl->EnumSurfaces(p, a, b, c, d)
#define IDirectDraw_FlipToGDISurface(p) (p)->lpVtbl->FlipToGDISurface(p)
#define IDirectDraw_GetCaps(p, a, b) (p)->lpVtbl->GetCaps(p, a, b)
#define IDirectDraw_GetDisplayMode(p, a) (p)->lpVtbl->GetDisplayMode(p, a)
#define IDirectDraw_GetFourCCCodes(p, a, b) (p)->lpVtbl->GetFourCCCodes(p, a, b)
#define IDirectDraw_GetGDISurface(p, a) (p)->lpVtbl->GetGDISurface(p, a)
#define IDirectDraw_GetMonitorFrequency(p, a) (p)->lpVtbl->GetMonitorFrequency(p, a)
#define IDirectDraw_GetScanLine(p, a) (p)->lpVtbl->GetScanLine(p, a)
#define IDirectDraw_GetVerticalBlankStatus(p, a) (p)->lpVtbl->GetVerticalBlankStatus(p, a)
#define IDirectDraw_Initialize(p, a) (p)->lpVtbl->Initialize(p, a)
#define IDirectDraw_RestoreDisplayMode(p) (p)->lpVtbl->RestoreDisplayMode(p)
#define IDirectDraw_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectDraw_SetDisplayMode(p, a, b, c) (p)->lpVtbl->SetDisplayMode(p, a, b, c)
#define IDirectDraw_WaitForVerticalBlank(p, a, b) (p)->lpVtbl->WaitForVerticalBlank(p, a, b)
const DDLOCK_SURFACEMEMORYPTR = &h00000000
const DDLOCK_WAIT = &h00000001
const DDLOCK_EVENT = &h00000002
const DDLOCK_READONLY = &h00000010
const DDLOCK_WRITEONLY = &h00000020
const DDLOCK_NOSYSLOCK = &h00000800
const DDLOCK_NOOVERWRITE = &h00001000
const DDLOCK_DISCARDCONTENTS = &h00002000
const DDLOCK_OKTOSWAP = &h00002000
const DDLOCK_DONOTWAIT = &h00004000
const DDLOCK_HASVOLUMETEXTUREBOXRECT = &h00008000
const DDLOCK_NODIRTYUPDATE = &h00010000
type IDirectDraw2Vtbl as IDirectDraw2Vtbl_

type IDirectDraw2
	lpVtbl as IDirectDraw2Vtbl ptr
end type

type IDirectDraw2Vtbl_
	QueryInterface as function(byval This as IDirectDraw2 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDraw2 ptr) as ULONG
	Release as function(byval This as IDirectDraw2 ptr) as ULONG
	Compact as function(byval This as IDirectDraw2 ptr) as HRESULT
	CreateClipper as function(byval This as IDirectDraw2 ptr, byval dwFlags as DWORD, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreatePalette as function(byval This as IDirectDraw2 ptr, byval dwFlags as DWORD, byval lpColorTable as LPPALETTEENTRY, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreateSurface as function(byval This as IDirectDraw2 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lplpDDSurface as LPDIRECTDRAWSURFACE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	DuplicateSurface as function(byval This as IDirectDraw2 ptr, byval lpDDSurface as LPDIRECTDRAWSURFACE, byval lplpDupDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	EnumDisplayModes as function(byval This as IDirectDraw2 ptr, byval dwFlags as DWORD, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumModesCallback as LPDDENUMMODESCALLBACK) as HRESULT
	EnumSurfaces as function(byval This as IDirectDraw2 ptr, byval dwFlags as DWORD, byval lpDDSD as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	FlipToGDISurface as function(byval This as IDirectDraw2 ptr) as HRESULT
	GetCaps as function(byval This as IDirectDraw2 ptr, byval lpDDDriverCaps as LPDDCAPS, byval lpDDHELCaps as LPDDCAPS) as HRESULT
	GetDisplayMode as function(byval This as IDirectDraw2 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	GetFourCCCodes as function(byval This as IDirectDraw2 ptr, byval lpNumCodes as LPDWORD, byval lpCodes as LPDWORD) as HRESULT
	GetGDISurface as function(byval This as IDirectDraw2 ptr, byval lplpGDIDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	GetMonitorFrequency as function(byval This as IDirectDraw2 ptr, byval lpdwFrequency as LPDWORD) as HRESULT
	GetScanLine as function(byval This as IDirectDraw2 ptr, byval lpdwScanLine as LPDWORD) as HRESULT
	GetVerticalBlankStatus as function(byval This as IDirectDraw2 ptr, byval lpbIsInVB as BOOL ptr) as HRESULT
	Initialize as function(byval This as IDirectDraw2 ptr, byval lpGUID as GUID ptr) as HRESULT
	RestoreDisplayMode as function(byval This as IDirectDraw2 ptr) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectDraw2 ptr, byval hWnd as HWND, byval dwFlags as DWORD) as HRESULT
	SetDisplayMode as function(byval This as IDirectDraw2 ptr, byval dwWidth as DWORD, byval dwHeight as DWORD, byval dwBPP as DWORD, byval dwRefreshRate as DWORD, byval dwFlags as DWORD) as HRESULT
	WaitForVerticalBlank as function(byval This as IDirectDraw2 ptr, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	GetAvailableVidMem as function(byval This as IDirectDraw2 ptr, byval lpDDCaps as LPDDSCAPS, byval lpdwTotal as LPDWORD, byval lpdwFree as LPDWORD) as HRESULT
end type

#define IDirectDraw2_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDraw2_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDraw2_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDraw2_Compact(p) (p)->lpVtbl->Compact(p)
#define IDirectDraw2_CreateClipper(p, a, b, c) (p)->lpVtbl->CreateClipper(p, a, b, c)
#define IDirectDraw2_CreatePalette(p, a, b, c, d) (p)->lpVtbl->CreatePalette(p, a, b, c, d)
#define IDirectDraw2_CreateSurface(p, a, b, c) (p)->lpVtbl->CreateSurface(p, a, b, c)
#define IDirectDraw2_DuplicateSurface(p, a, b) (p)->lpVtbl->DuplicateSurface(p, a, b)
#define IDirectDraw2_EnumDisplayModes(p, a, b, c, d) (p)->lpVtbl->EnumDisplayModes(p, a, b, c, d)
#define IDirectDraw2_EnumSurfaces(p, a, b, c, d) (p)->lpVtbl->EnumSurfaces(p, a, b, c, d)
#define IDirectDraw2_FlipToGDISurface(p) (p)->lpVtbl->FlipToGDISurface(p)
#define IDirectDraw2_GetCaps(p, a, b) (p)->lpVtbl->GetCaps(p, a, b)
#define IDirectDraw2_GetDisplayMode(p, a) (p)->lpVtbl->GetDisplayMode(p, a)
#define IDirectDraw2_GetFourCCCodes(p, a, b) (p)->lpVtbl->GetFourCCCodes(p, a, b)
#define IDirectDraw2_GetGDISurface(p, a) (p)->lpVtbl->GetGDISurface(p, a)
#define IDirectDraw2_GetMonitorFrequency(p, a) (p)->lpVtbl->GetMonitorFrequency(p, a)
#define IDirectDraw2_GetScanLine(p, a) (p)->lpVtbl->GetScanLine(p, a)
#define IDirectDraw2_GetVerticalBlankStatus(p, a) (p)->lpVtbl->GetVerticalBlankStatus(p, a)
#define IDirectDraw2_Initialize(p, a) (p)->lpVtbl->Initialize(p, a)
#define IDirectDraw2_RestoreDisplayMode(p) (p)->lpVtbl->RestoreDisplayMode(p)
#define IDirectDraw2_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectDraw2_SetDisplayMode(p, a, b, c, d, e) (p)->lpVtbl->SetDisplayMode(p, a, b, c, d, e)
#define IDirectDraw2_WaitForVerticalBlank(p, a, b) (p)->lpVtbl->WaitForVerticalBlank(p, a, b)
#define IDirectDraw2_GetAvailableVidMem(p, a, b, c) (p)->lpVtbl->GetAvailableVidMem(p, a, b, c)
type IDirectDraw3Vtbl as IDirectDraw3Vtbl_

type IDirectDraw3
	lpVtbl as IDirectDraw3Vtbl ptr
end type

type IDirectDraw3Vtbl_
	QueryInterface as function(byval This as IDirectDraw3 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDraw3 ptr) as ULONG
	Release as function(byval This as IDirectDraw3 ptr) as ULONG
	Compact as function(byval This as IDirectDraw3 ptr) as HRESULT
	CreateClipper as function(byval This as IDirectDraw3 ptr, byval dwFlags as DWORD, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreatePalette as function(byval This as IDirectDraw3 ptr, byval dwFlags as DWORD, byval lpColorTable as LPPALETTEENTRY, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreateSurface as function(byval This as IDirectDraw3 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lplpDDSurface as LPDIRECTDRAWSURFACE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	DuplicateSurface as function(byval This as IDirectDraw3 ptr, byval lpDDSurface as LPDIRECTDRAWSURFACE, byval lplpDupDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	EnumDisplayModes as function(byval This as IDirectDraw3 ptr, byval dwFlags as DWORD, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumModesCallback as LPDDENUMMODESCALLBACK) as HRESULT
	EnumSurfaces as function(byval This as IDirectDraw3 ptr, byval dwFlags as DWORD, byval lpDDSD as LPDDSURFACEDESC, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	FlipToGDISurface as function(byval This as IDirectDraw3 ptr) as HRESULT
	GetCaps as function(byval This as IDirectDraw3 ptr, byval lpDDDriverCaps as LPDDCAPS, byval lpDDHELCaps as LPDDCAPS) as HRESULT
	GetDisplayMode as function(byval This as IDirectDraw3 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	GetFourCCCodes as function(byval This as IDirectDraw3 ptr, byval lpNumCodes as LPDWORD, byval lpCodes as LPDWORD) as HRESULT
	GetGDISurface as function(byval This as IDirectDraw3 ptr, byval lplpGDIDDSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	GetMonitorFrequency as function(byval This as IDirectDraw3 ptr, byval lpdwFrequency as LPDWORD) as HRESULT
	GetScanLine as function(byval This as IDirectDraw3 ptr, byval lpdwScanLine as LPDWORD) as HRESULT
	GetVerticalBlankStatus as function(byval This as IDirectDraw3 ptr, byval lpbIsInVB as BOOL ptr) as HRESULT
	Initialize as function(byval This as IDirectDraw3 ptr, byval lpGUID as GUID ptr) as HRESULT
	RestoreDisplayMode as function(byval This as IDirectDraw3 ptr) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectDraw3 ptr, byval hWnd as HWND, byval dwFlags as DWORD) as HRESULT
	SetDisplayMode as function(byval This as IDirectDraw3 ptr, byval dwWidth as DWORD, byval dwHeight as DWORD, byval dwBPP as DWORD, byval dwRefreshRate as DWORD, byval dwFlags as DWORD) as HRESULT
	WaitForVerticalBlank as function(byval This as IDirectDraw3 ptr, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	GetAvailableVidMem as function(byval This as IDirectDraw3 ptr, byval lpDDCaps as LPDDSCAPS, byval lpdwTotal as LPDWORD, byval lpdwFree as LPDWORD) as HRESULT
	GetSurfaceFromDC as function(byval This as IDirectDraw3 ptr, byval hdc as HDC, byval pSurf as LPDIRECTDRAWSURFACE ptr) as HRESULT
end type

#define IDirectDraw3_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDraw3_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDraw3_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDraw3_Compact(p) (p)->lpVtbl->Compact(p)
#define IDirectDraw3_CreateClipper(p, a, b, c) (p)->lpVtbl->CreateClipper(p, a, b, c)
#define IDirectDraw3_CreatePalette(p, a, b, c, d) (p)->lpVtbl->CreatePalette(p, a, b, c, d)
#define IDirectDraw3_CreateSurface(p, a, b, c) (p)->lpVtbl->CreateSurface(p, a, b, c)
#define IDirectDraw3_DuplicateSurface(p, a, b) (p)->lpVtbl->DuplicateSurface(p, a, b)
#define IDirectDraw3_EnumDisplayModes(p, a, b, c, d) (p)->lpVtbl->EnumDisplayModes(p, a, b, c, d)
#define IDirectDraw3_EnumSurfaces(p, a, b, c, d) (p)->lpVtbl->EnumSurfaces(p, a, b, c, d)
#define IDirectDraw3_FlipToGDISurface(p) (p)->lpVtbl->FlipToGDISurface(p)
#define IDirectDraw3_GetCaps(p, a, b) (p)->lpVtbl->GetCaps(p, a, b)
#define IDirectDraw3_GetDisplayMode(p, a) (p)->lpVtbl->GetDisplayMode(p, a)
#define IDirectDraw3_GetFourCCCodes(p, a, b) (p)->lpVtbl->GetFourCCCodes(p, a, b)
#define IDirectDraw3_GetGDISurface(p, a) (p)->lpVtbl->GetGDISurface(p, a)
#define IDirectDraw3_GetMonitorFrequency(p, a) (p)->lpVtbl->GetMonitorFrequency(p, a)
#define IDirectDraw3_GetScanLine(p, a) (p)->lpVtbl->GetScanLine(p, a)
#define IDirectDraw3_GetVerticalBlankStatus(p, a) (p)->lpVtbl->GetVerticalBlankStatus(p, a)
#define IDirectDraw3_Initialize(p, a) (p)->lpVtbl->Initialize(p, a)
#define IDirectDraw3_RestoreDisplayMode(p) (p)->lpVtbl->RestoreDisplayMode(p)
#define IDirectDraw3_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectDraw3_SetDisplayMode(p, a, b, c, d, e) (p)->lpVtbl->SetDisplayMode(p, a, b, c, d, e)
#define IDirectDraw3_WaitForVerticalBlank(p, a, b) (p)->lpVtbl->WaitForVerticalBlank(p, a, b)
#define IDirectDraw3_GetAvailableVidMem(p, a, b, c) (p)->lpVtbl->GetAvailableVidMem(p, a, b, c)
#define IDirectDraw3_GetSurfaceFromDC(p, a, b) (p)->lpVtbl->GetSurfaceFromDC(p, a, b)
type IDirectDraw4Vtbl as IDirectDraw4Vtbl_

type IDirectDraw4
	lpVtbl as IDirectDraw4Vtbl ptr
end type

type IDirectDraw4Vtbl_
	QueryInterface as function(byval This as IDirectDraw4 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDraw4 ptr) as ULONG
	Release as function(byval This as IDirectDraw4 ptr) as ULONG
	Compact as function(byval This as IDirectDraw4 ptr) as HRESULT
	CreateClipper as function(byval This as IDirectDraw4 ptr, byval dwFlags as DWORD, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreatePalette as function(byval This as IDirectDraw4 ptr, byval dwFlags as DWORD, byval lpColorTable as LPPALETTEENTRY, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreateSurface as function(byval This as IDirectDraw4 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval lplpDDSurface as LPDIRECTDRAWSURFACE4 ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	DuplicateSurface as function(byval This as IDirectDraw4 ptr, byval lpDDSurface as LPDIRECTDRAWSURFACE4, byval lplpDupDDSurface as LPDIRECTDRAWSURFACE4 ptr) as HRESULT
	EnumDisplayModes as function(byval This as IDirectDraw4 ptr, byval dwFlags as DWORD, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval lpContext as LPVOID, byval lpEnumModesCallback as LPDDENUMMODESCALLBACK2) as HRESULT
	EnumSurfaces as function(byval This as IDirectDraw4 ptr, byval dwFlags as DWORD, byval lpDDSD as LPDDSURFACEDESC2, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK2) as HRESULT
	FlipToGDISurface as function(byval This as IDirectDraw4 ptr) as HRESULT
	GetCaps as function(byval This as IDirectDraw4 ptr, byval lpDDDriverCaps as LPDDCAPS, byval lpDDHELCaps as LPDDCAPS) as HRESULT
	GetDisplayMode as function(byval This as IDirectDraw4 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	GetFourCCCodes as function(byval This as IDirectDraw4 ptr, byval lpNumCodes as LPDWORD, byval lpCodes as LPDWORD) as HRESULT
	GetGDISurface as function(byval This as IDirectDraw4 ptr, byval lplpGDIDDSurface as LPDIRECTDRAWSURFACE4 ptr) as HRESULT
	GetMonitorFrequency as function(byval This as IDirectDraw4 ptr, byval lpdwFrequency as LPDWORD) as HRESULT
	GetScanLine as function(byval This as IDirectDraw4 ptr, byval lpdwScanLine as LPDWORD) as HRESULT
	GetVerticalBlankStatus as function(byval This as IDirectDraw4 ptr, byval lpbIsInVB as BOOL ptr) as HRESULT
	Initialize as function(byval This as IDirectDraw4 ptr, byval lpGUID as GUID ptr) as HRESULT
	RestoreDisplayMode as function(byval This as IDirectDraw4 ptr) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectDraw4 ptr, byval hWnd as HWND, byval dwFlags as DWORD) as HRESULT
	SetDisplayMode as function(byval This as IDirectDraw4 ptr, byval dwWidth as DWORD, byval dwHeight as DWORD, byval dwBPP as DWORD, byval dwRefreshRate as DWORD, byval dwFlags as DWORD) as HRESULT
	WaitForVerticalBlank as function(byval This as IDirectDraw4 ptr, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	GetAvailableVidMem as function(byval This as IDirectDraw4 ptr, byval lpDDCaps as LPDDSCAPS2, byval lpdwTotal as LPDWORD, byval lpdwFree as LPDWORD) as HRESULT
	GetSurfaceFromDC as function(byval This as IDirectDraw4 ptr, byval hdc as HDC, byval pSurf as LPDIRECTDRAWSURFACE4 ptr) as HRESULT
	RestoreAllSurfaces as function(byval This as IDirectDraw4 ptr) as HRESULT
	TestCooperativeLevel as function(byval This as IDirectDraw4 ptr) as HRESULT
	GetDeviceIdentifier as function(byval This as IDirectDraw4 ptr, byval pDDDI as LPDDDEVICEIDENTIFIER, byval dwFlags as DWORD) as HRESULT
end type

#define IDirectDraw4_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDraw4_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDraw4_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDraw4_Compact(p) (p)->lpVtbl->Compact(p)
#define IDirectDraw4_CreateClipper(p, a, b, c) (p)->lpVtbl->CreateClipper(p, a, b, c)
#define IDirectDraw4_CreatePalette(p, a, b, c, d) (p)->lpVtbl->CreatePalette(p, a, b, c, d)
#define IDirectDraw4_CreateSurface(p, a, b, c) (p)->lpVtbl->CreateSurface(p, a, b, c)
#define IDirectDraw4_DuplicateSurface(p, a, b) (p)->lpVtbl->DuplicateSurface(p, a, b)
#define IDirectDraw4_EnumDisplayModes(p, a, b, c, d) (p)->lpVtbl->EnumDisplayModes(p, a, b, c, d)
#define IDirectDraw4_EnumSurfaces(p, a, b, c, d) (p)->lpVtbl->EnumSurfaces(p, a, b, c, d)
#define IDirectDraw4_FlipToGDISurface(p) (p)->lpVtbl->FlipToGDISurface(p)
#define IDirectDraw4_GetCaps(p, a, b) (p)->lpVtbl->GetCaps(p, a, b)
#define IDirectDraw4_GetDisplayMode(p, a) (p)->lpVtbl->GetDisplayMode(p, a)
#define IDirectDraw4_GetFourCCCodes(p, a, b) (p)->lpVtbl->GetFourCCCodes(p, a, b)
#define IDirectDraw4_GetGDISurface(p, a) (p)->lpVtbl->GetGDISurface(p, a)
#define IDirectDraw4_GetMonitorFrequency(p, a) (p)->lpVtbl->GetMonitorFrequency(p, a)
#define IDirectDraw4_GetScanLine(p, a) (p)->lpVtbl->GetScanLine(p, a)
#define IDirectDraw4_GetVerticalBlankStatus(p, a) (p)->lpVtbl->GetVerticalBlankStatus(p, a)
#define IDirectDraw4_Initialize(p, a) (p)->lpVtbl->Initialize(p, a)
#define IDirectDraw4_RestoreDisplayMode(p) (p)->lpVtbl->RestoreDisplayMode(p)
#define IDirectDraw4_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectDraw4_SetDisplayMode(p, a, b, c, d, e) (p)->lpVtbl->SetDisplayMode(p, a, b, c, d, e)
#define IDirectDraw4_WaitForVerticalBlank(p, a, b) (p)->lpVtbl->WaitForVerticalBlank(p, a, b)
#define IDirectDraw4_GetAvailableVidMem(p, a, b, c) (p)->lpVtbl->GetAvailableVidMem(p, a, b, c)
#define IDirectDraw4_GetSurfaceFromDC(p, a, b) (p)->lpVtbl->GetSurfaceFromDC(p, a, b)
#define IDirectDraw4_RestoreAllSurfaces(p) (p)->lpVtbl->RestoreAllSurfaces(p)
#define IDirectDraw4_TestCooperativeLevel(p) (p)->lpVtbl->TestCooperativeLevel(p)
#define IDirectDraw4_GetDeviceIdentifier(p, a, b) (p)->lpVtbl->GetDeviceIdentifier(p, a, b)
type IDirectDraw7Vtbl as IDirectDraw7Vtbl_

type IDirectDraw7
	lpVtbl as IDirectDraw7Vtbl ptr
end type

type IDirectDraw7Vtbl_
	QueryInterface as function(byval This as IDirectDraw7 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDraw7 ptr) as ULONG
	Release as function(byval This as IDirectDraw7 ptr) as ULONG
	Compact as function(byval This as IDirectDraw7 ptr) as HRESULT
	CreateClipper as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreatePalette as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval lpColorTable as LPPALETTEENTRY, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	CreateSurface as function(byval This as IDirectDraw7 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval lplpDDSurface as LPDIRECTDRAWSURFACE7 ptr, byval pUnkOuter as IUnknown ptr) as HRESULT
	DuplicateSurface as function(byval This as IDirectDraw7 ptr, byval lpDDSurface as LPDIRECTDRAWSURFACE7, byval lplpDupDDSurface as LPDIRECTDRAWSURFACE7 ptr) as HRESULT
	EnumDisplayModes as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval lpContext as LPVOID, byval lpEnumModesCallback as LPDDENUMMODESCALLBACK2) as HRESULT
	EnumSurfaces as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval lpDDSD as LPDDSURFACEDESC2, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK7) as HRESULT
	FlipToGDISurface as function(byval This as IDirectDraw7 ptr) as HRESULT
	GetCaps as function(byval This as IDirectDraw7 ptr, byval lpDDDriverCaps as LPDDCAPS, byval lpDDHELCaps as LPDDCAPS) as HRESULT
	GetDisplayMode as function(byval This as IDirectDraw7 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	GetFourCCCodes as function(byval This as IDirectDraw7 ptr, byval lpNumCodes as LPDWORD, byval lpCodes as LPDWORD) as HRESULT
	GetGDISurface as function(byval This as IDirectDraw7 ptr, byval lplpGDIDDSurface as LPDIRECTDRAWSURFACE7 ptr) as HRESULT
	GetMonitorFrequency as function(byval This as IDirectDraw7 ptr, byval lpdwFrequency as LPDWORD) as HRESULT
	GetScanLine as function(byval This as IDirectDraw7 ptr, byval lpdwScanLine as LPDWORD) as HRESULT
	GetVerticalBlankStatus as function(byval This as IDirectDraw7 ptr, byval lpbIsInVB as BOOL ptr) as HRESULT
	Initialize as function(byval This as IDirectDraw7 ptr, byval lpGUID as GUID ptr) as HRESULT
	RestoreDisplayMode as function(byval This as IDirectDraw7 ptr) as HRESULT
	SetCooperativeLevel as function(byval This as IDirectDraw7 ptr, byval hWnd as HWND, byval dwFlags as DWORD) as HRESULT
	SetDisplayMode as function(byval This as IDirectDraw7 ptr, byval dwWidth as DWORD, byval dwHeight as DWORD, byval dwBPP as DWORD, byval dwRefreshRate as DWORD, byval dwFlags as DWORD) as HRESULT
	WaitForVerticalBlank as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	GetAvailableVidMem as function(byval This as IDirectDraw7 ptr, byval lpDDCaps as LPDDSCAPS2, byval lpdwTotal as LPDWORD, byval lpdwFree as LPDWORD) as HRESULT
	GetSurfaceFromDC as function(byval This as IDirectDraw7 ptr, byval hdc as HDC, byval pSurf as LPDIRECTDRAWSURFACE7 ptr) as HRESULT
	RestoreAllSurfaces as function(byval This as IDirectDraw7 ptr) as HRESULT
	TestCooperativeLevel as function(byval This as IDirectDraw7 ptr) as HRESULT
	GetDeviceIdentifier as function(byval This as IDirectDraw7 ptr, byval pDDDI as LPDDDEVICEIDENTIFIER2, byval dwFlags as DWORD) as HRESULT
	StartModeTest as function(byval This as IDirectDraw7 ptr, byval pModes as LPSIZE, byval dwNumModes as DWORD, byval dwFlags as DWORD) as HRESULT
	EvaluateMode as function(byval This as IDirectDraw7 ptr, byval dwFlags as DWORD, byval pTimeout as DWORD ptr) as HRESULT
end type

#define IDirectDraw7_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDraw7_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDraw7_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDraw7_Compact(p) (p)->lpVtbl->Compact(p)
#define IDirectDraw7_CreateClipper(p, a, b, c) (p)->lpVtbl->CreateClipper(p, a, b, c)
#define IDirectDraw7_CreatePalette(p, a, b, c, d) (p)->lpVtbl->CreatePalette(p, a, b, c, d)
#define IDirectDraw7_CreateSurface(p, a, b, c) (p)->lpVtbl->CreateSurface(p, a, b, c)
#define IDirectDraw7_DuplicateSurface(p, a, b) (p)->lpVtbl->DuplicateSurface(p, a, b)
#define IDirectDraw7_EnumDisplayModes(p, a, b, c, d) (p)->lpVtbl->EnumDisplayModes(p, a, b, c, d)
#define IDirectDraw7_EnumSurfaces(p, a, b, c, d) (p)->lpVtbl->EnumSurfaces(p, a, b, c, d)
#define IDirectDraw7_FlipToGDISurface(p) (p)->lpVtbl->FlipToGDISurface(p)
#define IDirectDraw7_GetCaps(p, a, b) (p)->lpVtbl->GetCaps(p, a, b)
#define IDirectDraw7_GetDisplayMode(p, a) (p)->lpVtbl->GetDisplayMode(p, a)
#define IDirectDraw7_GetFourCCCodes(p, a, b) (p)->lpVtbl->GetFourCCCodes(p, a, b)
#define IDirectDraw7_GetGDISurface(p, a) (p)->lpVtbl->GetGDISurface(p, a)
#define IDirectDraw7_GetMonitorFrequency(p, a) (p)->lpVtbl->GetMonitorFrequency(p, a)
#define IDirectDraw7_GetScanLine(p, a) (p)->lpVtbl->GetScanLine(p, a)
#define IDirectDraw7_GetVerticalBlankStatus(p, a) (p)->lpVtbl->GetVerticalBlankStatus(p, a)
#define IDirectDraw7_Initialize(p, a) (p)->lpVtbl->Initialize(p, a)
#define IDirectDraw7_RestoreDisplayMode(p) (p)->lpVtbl->RestoreDisplayMode(p)
#define IDirectDraw7_SetCooperativeLevel(p, a, b) (p)->lpVtbl->SetCooperativeLevel(p, a, b)
#define IDirectDraw7_SetDisplayMode(p, a, b, c, d, e) (p)->lpVtbl->SetDisplayMode(p, a, b, c, d, e)
#define IDirectDraw7_WaitForVerticalBlank(p, a, b) (p)->lpVtbl->WaitForVerticalBlank(p, a, b)
#define IDirectDraw7_GetAvailableVidMem(p, a, b, c) (p)->lpVtbl->GetAvailableVidMem(p, a, b, c)
#define IDirectDraw7_GetSurfaceFromDC(p, a, b) (p)->lpVtbl->GetSurfaceFromDC(p, a, b)
#define IDirectDraw7_RestoreAllSurfaces(p) (p)->lpVtbl->RestoreAllSurfaces(p)
#define IDirectDraw7_TestCooperativeLevel(p) (p)->lpVtbl->TestCooperativeLevel(p)
#define IDirectDraw7_GetDeviceIdentifier(p, a, b) (p)->lpVtbl->GetDeviceIdentifier(p, a, b)
#define IDirectDraw7_StartModeTest(p, a, b, c) (p)->lpVtbl->StartModeTest(p, a, b, c)
#define IDirectDraw7_EvaluateMode(p, a, b) (p)->lpVtbl->EvaluateMode(p, a, b)
type IDirectDrawSurfaceVtbl as IDirectDrawSurfaceVtbl_

type IDirectDrawSurface
	lpVtbl as IDirectDrawSurfaceVtbl ptr
end type

type IDirectDrawSurfaceVtbl_
	QueryInterface as function(byval This as IDirectDrawSurface ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawSurface ptr) as ULONG
	Release as function(byval This as IDirectDrawSurface ptr) as ULONG
	AddAttachedSurface as function(byval This as IDirectDrawSurface ptr, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE) as HRESULT
	AddOverlayDirtyRect as function(byval This as IDirectDrawSurface ptr, byval lpRect as LPRECT) as HRESULT
	Blt as function(byval This as IDirectDrawSurface ptr, byval lpDestRect as LPRECT, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE, byval lpSrcRect as LPRECT, byval dwFlags as DWORD, byval lpDDBltFx as LPDDBLTFX) as HRESULT
	BltBatch as function(byval This as IDirectDrawSurface ptr, byval lpDDBltBatch as LPDDBLTBATCH, byval dwCount as DWORD, byval dwFlags as DWORD) as HRESULT
	BltFast as function(byval This as IDirectDrawSurface ptr, byval dwX as DWORD, byval dwY as DWORD, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE, byval lpSrcRect as LPRECT, byval dwTrans as DWORD) as HRESULT
	DeleteAttachedSurface as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE) as HRESULT
	EnumAttachedSurfaces as function(byval This as IDirectDrawSurface ptr, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	EnumOverlayZOrders as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD, byval lpContext as LPVOID, byval lpfnCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	Flip as function(byval This as IDirectDrawSurface ptr, byval lpDDSurfaceTargetOverride as LPDIRECTDRAWSURFACE, byval dwFlags as DWORD) as HRESULT
	GetAttachedSurface as function(byval This as IDirectDrawSurface ptr, byval lpDDSCaps as LPDDSCAPS, byval lplpDDAttachedSurface as LPDIRECTDRAWSURFACE ptr) as HRESULT
	GetBltStatus as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD) as HRESULT
	GetCaps as function(byval This as IDirectDrawSurface ptr, byval lpDDSCaps as LPDDSCAPS) as HRESULT
	GetClipper as function(byval This as IDirectDrawSurface ptr, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr) as HRESULT
	GetColorKey as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	GetDC as function(byval This as IDirectDrawSurface ptr, byval lphDC as HDC ptr) as HRESULT
	GetFlipStatus as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD) as HRESULT
	GetOverlayPosition as function(byval This as IDirectDrawSurface ptr, byval lplX as LPLONG, byval lplY as LPLONG) as HRESULT
	GetPalette as function(byval This as IDirectDrawSurface ptr, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr) as HRESULT
	GetPixelFormat as function(byval This as IDirectDrawSurface ptr, byval lpDDPixelFormat as LPDDPIXELFORMAT) as HRESULT
	GetSurfaceDesc as function(byval This as IDirectDrawSurface ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	Initialize as function(byval This as IDirectDrawSurface ptr, byval lpDD as LPDIRECTDRAW, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	IsLost as function(byval This as IDirectDrawSurface ptr) as HRESULT
	Lock as function(byval This as IDirectDrawSurface ptr, byval lpDestRect as LPRECT, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	ReleaseDC as function(byval This as IDirectDrawSurface ptr, byval hDC as HDC) as HRESULT
	Restore as function(byval This as IDirectDrawSurface ptr) as HRESULT
	SetClipper as function(byval This as IDirectDrawSurface ptr, byval lpDDClipper as LPDIRECTDRAWCLIPPER) as HRESULT
	SetColorKey as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	SetOverlayPosition as function(byval This as IDirectDrawSurface ptr, byval lX as LONG, byval lY as LONG) as HRESULT
	SetPalette as function(byval This as IDirectDrawSurface ptr, byval lpDDPalette as LPDIRECTDRAWPALETTE) as HRESULT
	Unlock as function(byval This as IDirectDrawSurface ptr, byval lpSurfaceData as LPVOID) as HRESULT
	UpdateOverlay as function(byval This as IDirectDrawSurface ptr, byval lpSrcRect as LPRECT, byval lpDDDestSurface as LPDIRECTDRAWSURFACE, byval lpDestRect as LPRECT, byval dwFlags as DWORD, byval lpDDOverlayFx as LPDDOVERLAYFX) as HRESULT
	UpdateOverlayDisplay as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD) as HRESULT
	UpdateOverlayZOrder as function(byval This as IDirectDrawSurface ptr, byval dwFlags as DWORD, byval lpDDSReference as LPDIRECTDRAWSURFACE) as HRESULT
end type

#define IDirectDrawSurface_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawSurface_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawSurface_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawSurface_AddAttachedSurface(p, a) (p)->lpVtbl->AddAttachedSurface(p, a)
#define IDirectDrawSurface_AddOverlayDirtyRect(p, a) (p)->lpVtbl->AddOverlayDirtyRect(p, a)
#define IDirectDrawSurface_Blt(p, a, b, c, d, e) (p)->lpVtbl->Blt(p, a, b, c, d, e)
#define IDirectDrawSurface_BltBatch(p, a, b, c) (p)->lpVtbl->BltBatch(p, a, b, c)
#define IDirectDrawSurface_BltFast(p, a, b, c, d, e) (p)->lpVtbl->BltFast(p, a, b, c, d, e)
#define IDirectDrawSurface_DeleteAttachedSurface(p, a, b) (p)->lpVtbl->DeleteAttachedSurface(p, a, b)
#define IDirectDrawSurface_EnumAttachedSurfaces(p, a, b) (p)->lpVtbl->EnumAttachedSurfaces(p, a, b)
#define IDirectDrawSurface_EnumOverlayZOrders(p, a, b, c) (p)->lpVtbl->EnumOverlayZOrders(p, a, b, c)
#define IDirectDrawSurface_Flip(p, a, b) (p)->lpVtbl->Flip(p, a, b)
#define IDirectDrawSurface_GetAttachedSurface(p, a, b) (p)->lpVtbl->GetAttachedSurface(p, a, b)
#define IDirectDrawSurface_GetBltStatus(p, a) (p)->lpVtbl->GetBltStatus(p, a)
#define IDirectDrawSurface_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawSurface_GetClipper(p, a) (p)->lpVtbl->GetClipper(p, a)
#define IDirectDrawSurface_GetColorKey(p, a, b) (p)->lpVtbl->GetColorKey(p, a, b)
#define IDirectDrawSurface_GetDC(p, a) (p)->lpVtbl->GetDC(p, a)
#define IDirectDrawSurface_GetFlipStatus(p, a) (p)->lpVtbl->GetFlipStatus(p, a)
#define IDirectDrawSurface_GetOverlayPosition(p, a, b) (p)->lpVtbl->GetOverlayPosition(p, a, b)
#define IDirectDrawSurface_GetPalette(p, a) (p)->lpVtbl->GetPalette(p, a)
#define IDirectDrawSurface_GetPixelFormat(p, a) (p)->lpVtbl->GetPixelFormat(p, a)
#define IDirectDrawSurface_GetSurfaceDesc(p, a) (p)->lpVtbl->GetSurfaceDesc(p, a)
#define IDirectDrawSurface_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawSurface_IsLost(p) (p)->lpVtbl->IsLost(p)
#define IDirectDrawSurface_Lock(p, a, b, c, d) (p)->lpVtbl->Lock(p, a, b, c, d)
#define IDirectDrawSurface_ReleaseDC(p, a) (p)->lpVtbl->ReleaseDC(p, a)
#define IDirectDrawSurface_Restore(p) (p)->lpVtbl->Restore(p)
#define IDirectDrawSurface_SetClipper(p, a) (p)->lpVtbl->SetClipper(p, a)
#define IDirectDrawSurface_SetColorKey(p, a, b) (p)->lpVtbl->SetColorKey(p, a, b)
#define IDirectDrawSurface_SetOverlayPosition(p, a, b) (p)->lpVtbl->SetOverlayPosition(p, a, b)
#define IDirectDrawSurface_SetPalette(p, a) (p)->lpVtbl->SetPalette(p, a)
#define IDirectDrawSurface_Unlock(p, a) (p)->lpVtbl->Unlock(p, a)
#define IDirectDrawSurface_UpdateOverlay(p, a, b, c, d, e) (p)->lpVtbl->UpdateOverlay(p, a, b, c, d, e)
#define IDirectDrawSurface_UpdateOverlayDisplay(p, a) (p)->lpVtbl->UpdateOverlayDisplay(p, a)
#define IDirectDrawSurface_UpdateOverlayZOrder(p, a, b) (p)->lpVtbl->UpdateOverlayZOrder(p, a, b)
type IDirectDrawSurface2Vtbl as IDirectDrawSurface2Vtbl_

type IDirectDrawSurface2
	lpVtbl as IDirectDrawSurface2Vtbl ptr
end type

type IDirectDrawSurface2Vtbl_
	QueryInterface as function(byval This as IDirectDrawSurface2 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawSurface2 ptr) as ULONG
	Release as function(byval This as IDirectDrawSurface2 ptr) as ULONG
	AddAttachedSurface as function(byval This as IDirectDrawSurface2 ptr, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE2) as HRESULT
	AddOverlayDirtyRect as function(byval This as IDirectDrawSurface2 ptr, byval lpRect as LPRECT) as HRESULT
	Blt as function(byval This as IDirectDrawSurface2 ptr, byval lpDestRect as LPRECT, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE2, byval lpSrcRect as LPRECT, byval dwFlags as DWORD, byval lpDDBltFx as LPDDBLTFX) as HRESULT
	BltBatch as function(byval This as IDirectDrawSurface2 ptr, byval lpDDBltBatch as LPDDBLTBATCH, byval dwCount as DWORD, byval dwFlags as DWORD) as HRESULT
	BltFast as function(byval This as IDirectDrawSurface2 ptr, byval dwX as DWORD, byval dwY as DWORD, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE2, byval lpSrcRect as LPRECT, byval dwTrans as DWORD) as HRESULT
	DeleteAttachedSurface as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE2) as HRESULT
	EnumAttachedSurfaces as function(byval This as IDirectDrawSurface2 ptr, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	EnumOverlayZOrders as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD, byval lpContext as LPVOID, byval lpfnCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	Flip as function(byval This as IDirectDrawSurface2 ptr, byval lpDDSurfaceTargetOverride as LPDIRECTDRAWSURFACE2, byval dwFlags as DWORD) as HRESULT
	GetAttachedSurface as function(byval This as IDirectDrawSurface2 ptr, byval lpDDSCaps as LPDDSCAPS, byval lplpDDAttachedSurface as LPDIRECTDRAWSURFACE2 ptr) as HRESULT
	GetBltStatus as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD) as HRESULT
	GetCaps as function(byval This as IDirectDrawSurface2 ptr, byval lpDDSCaps as LPDDSCAPS) as HRESULT
	GetClipper as function(byval This as IDirectDrawSurface2 ptr, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr) as HRESULT
	GetColorKey as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	GetDC as function(byval This as IDirectDrawSurface2 ptr, byval lphDC as HDC ptr) as HRESULT
	GetFlipStatus as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD) as HRESULT
	GetOverlayPosition as function(byval This as IDirectDrawSurface2 ptr, byval lplX as LPLONG, byval lplY as LPLONG) as HRESULT
	GetPalette as function(byval This as IDirectDrawSurface2 ptr, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr) as HRESULT
	GetPixelFormat as function(byval This as IDirectDrawSurface2 ptr, byval lpDDPixelFormat as LPDDPIXELFORMAT) as HRESULT
	GetSurfaceDesc as function(byval This as IDirectDrawSurface2 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	Initialize as function(byval This as IDirectDrawSurface2 ptr, byval lpDD as LPDIRECTDRAW, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	IsLost as function(byval This as IDirectDrawSurface2 ptr) as HRESULT
	Lock as function(byval This as IDirectDrawSurface2 ptr, byval lpDestRect as LPRECT, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	ReleaseDC as function(byval This as IDirectDrawSurface2 ptr, byval hDC as HDC) as HRESULT
	Restore as function(byval This as IDirectDrawSurface2 ptr) as HRESULT
	SetClipper as function(byval This as IDirectDrawSurface2 ptr, byval lpDDClipper as LPDIRECTDRAWCLIPPER) as HRESULT
	SetColorKey as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	SetOverlayPosition as function(byval This as IDirectDrawSurface2 ptr, byval lX as LONG, byval lY as LONG) as HRESULT
	SetPalette as function(byval This as IDirectDrawSurface2 ptr, byval lpDDPalette as LPDIRECTDRAWPALETTE) as HRESULT
	Unlock as function(byval This as IDirectDrawSurface2 ptr, byval lpSurfaceData as LPVOID) as HRESULT
	UpdateOverlay as function(byval This as IDirectDrawSurface2 ptr, byval lpSrcRect as LPRECT, byval lpDDDestSurface as LPDIRECTDRAWSURFACE2, byval lpDestRect as LPRECT, byval dwFlags as DWORD, byval lpDDOverlayFx as LPDDOVERLAYFX) as HRESULT
	UpdateOverlayDisplay as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD) as HRESULT
	UpdateOverlayZOrder as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD, byval lpDDSReference as LPDIRECTDRAWSURFACE2) as HRESULT
	GetDDInterface as function(byval This as IDirectDrawSurface2 ptr, byval lplpDD as LPVOID ptr) as HRESULT
	PageLock as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD) as HRESULT
	PageUnlock as function(byval This as IDirectDrawSurface2 ptr, byval dwFlags as DWORD) as HRESULT
end type

#define IDirectDrawSurface2_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawSurface2_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawSurface2_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawSurface2_AddAttachedSurface(p, a) (p)->lpVtbl->AddAttachedSurface(p, a)
#define IDirectDrawSurface2_AddOverlayDirtyRect(p, a) (p)->lpVtbl->AddOverlayDirtyRect(p, a)
#define IDirectDrawSurface2_Blt(p, a, b, c, d, e) (p)->lpVtbl->Blt(p, a, b, c, d, e)
#define IDirectDrawSurface2_BltBatch(p, a, b, c) (p)->lpVtbl->BltBatch(p, a, b, c)
#define IDirectDrawSurface2_BltFast(p, a, b, c, d, e) (p)->lpVtbl->BltFast(p, a, b, c, d, e)
#define IDirectDrawSurface2_DeleteAttachedSurface(p, a, b) (p)->lpVtbl->DeleteAttachedSurface(p, a, b)
#define IDirectDrawSurface2_EnumAttachedSurfaces(p, a, b) (p)->lpVtbl->EnumAttachedSurfaces(p, a, b)
#define IDirectDrawSurface2_EnumOverlayZOrders(p, a, b, c) (p)->lpVtbl->EnumOverlayZOrders(p, a, b, c)
#define IDirectDrawSurface2_Flip(p, a, b) (p)->lpVtbl->Flip(p, a, b)
#define IDirectDrawSurface2_GetAttachedSurface(p, a, b) (p)->lpVtbl->GetAttachedSurface(p, a, b)
#define IDirectDrawSurface2_GetBltStatus(p, a) (p)->lpVtbl->GetBltStatus(p, a)
#define IDirectDrawSurface2_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawSurface2_GetClipper(p, a) (p)->lpVtbl->GetClipper(p, a)
#define IDirectDrawSurface2_GetColorKey(p, a, b) (p)->lpVtbl->GetColorKey(p, a, b)
#define IDirectDrawSurface2_GetDC(p, a) (p)->lpVtbl->GetDC(p, a)
#define IDirectDrawSurface2_GetFlipStatus(p, a) (p)->lpVtbl->GetFlipStatus(p, a)
#define IDirectDrawSurface2_GetOverlayPosition(p, a, b) (p)->lpVtbl->GetOverlayPosition(p, a, b)
#define IDirectDrawSurface2_GetPalette(p, a) (p)->lpVtbl->GetPalette(p, a)
#define IDirectDrawSurface2_GetPixelFormat(p, a) (p)->lpVtbl->GetPixelFormat(p, a)
#define IDirectDrawSurface2_GetSurfaceDesc(p, a) (p)->lpVtbl->GetSurfaceDesc(p, a)
#define IDirectDrawSurface2_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawSurface2_IsLost(p) (p)->lpVtbl->IsLost(p)
#define IDirectDrawSurface2_Lock(p, a, b, c, d) (p)->lpVtbl->Lock(p, a, b, c, d)
#define IDirectDrawSurface2_ReleaseDC(p, a) (p)->lpVtbl->ReleaseDC(p, a)
#define IDirectDrawSurface2_Restore(p) (p)->lpVtbl->Restore(p)
#define IDirectDrawSurface2_SetClipper(p, a) (p)->lpVtbl->SetClipper(p, a)
#define IDirectDrawSurface2_SetColorKey(p, a, b) (p)->lpVtbl->SetColorKey(p, a, b)
#define IDirectDrawSurface2_SetOverlayPosition(p, a, b) (p)->lpVtbl->SetOverlayPosition(p, a, b)
#define IDirectDrawSurface2_SetPalette(p, a) (p)->lpVtbl->SetPalette(p, a)
#define IDirectDrawSurface2_Unlock(p, a) (p)->lpVtbl->Unlock(p, a)
#define IDirectDrawSurface2_UpdateOverlay(p, a, b, c, d, e) (p)->lpVtbl->UpdateOverlay(p, a, b, c, d, e)
#define IDirectDrawSurface2_UpdateOverlayDisplay(p, a) (p)->lpVtbl->UpdateOverlayDisplay(p, a)
#define IDirectDrawSurface2_UpdateOverlayZOrder(p, a, b) (p)->lpVtbl->UpdateOverlayZOrder(p, a, b)
#define IDirectDrawSurface2_GetDDInterface(p, a) (p)->lpVtbl->GetDDInterface(p, a)
#define IDirectDrawSurface2_PageLock(p, a) (p)->lpVtbl->PageLock(p, a)
#define IDirectDrawSurface2_PageUnlock(p, a) (p)->lpVtbl->PageUnlock(p, a)
type IDirectDrawSurface3Vtbl as IDirectDrawSurface3Vtbl_

type IDirectDrawSurface3
	lpVtbl as IDirectDrawSurface3Vtbl ptr
end type

type IDirectDrawSurface3Vtbl_
	QueryInterface as function(byval This as IDirectDrawSurface3 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawSurface3 ptr) as ULONG
	Release as function(byval This as IDirectDrawSurface3 ptr) as ULONG
	AddAttachedSurface as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE3) as HRESULT
	AddOverlayDirtyRect as function(byval This as IDirectDrawSurface3 ptr, byval lpRect as LPRECT) as HRESULT
	Blt as function(byval This as IDirectDrawSurface3 ptr, byval lpDestRect as LPRECT, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE3, byval lpSrcRect as LPRECT, byval dwFlags as DWORD, byval lpDDBltFx as LPDDBLTFX) as HRESULT
	BltBatch as function(byval This as IDirectDrawSurface3 ptr, byval lpDDBltBatch as LPDDBLTBATCH, byval dwCount as DWORD, byval dwFlags as DWORD) as HRESULT
	BltFast as function(byval This as IDirectDrawSurface3 ptr, byval dwX as DWORD, byval dwY as DWORD, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE3, byval lpSrcRect as LPRECT, byval dwTrans as DWORD) as HRESULT
	DeleteAttachedSurface as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE3) as HRESULT
	EnumAttachedSurfaces as function(byval This as IDirectDrawSurface3 ptr, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	EnumOverlayZOrders as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD, byval lpContext as LPVOID, byval lpfnCallback as LPDDENUMSURFACESCALLBACK) as HRESULT
	Flip as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSurfaceTargetOverride as LPDIRECTDRAWSURFACE3, byval dwFlags as DWORD) as HRESULT
	GetAttachedSurface as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSCaps as LPDDSCAPS, byval lplpDDAttachedSurface as LPDIRECTDRAWSURFACE3 ptr) as HRESULT
	GetBltStatus as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD) as HRESULT
	GetCaps as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSCaps as LPDDSCAPS) as HRESULT
	GetClipper as function(byval This as IDirectDrawSurface3 ptr, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr) as HRESULT
	GetColorKey as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	GetDC as function(byval This as IDirectDrawSurface3 ptr, byval lphDC as HDC ptr) as HRESULT
	GetFlipStatus as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD) as HRESULT
	GetOverlayPosition as function(byval This as IDirectDrawSurface3 ptr, byval lplX as LPLONG, byval lplY as LPLONG) as HRESULT
	GetPalette as function(byval This as IDirectDrawSurface3 ptr, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr) as HRESULT
	GetPixelFormat as function(byval This as IDirectDrawSurface3 ptr, byval lpDDPixelFormat as LPDDPIXELFORMAT) as HRESULT
	GetSurfaceDesc as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	Initialize as function(byval This as IDirectDrawSurface3 ptr, byval lpDD as LPDIRECTDRAW, byval lpDDSurfaceDesc as LPDDSURFACEDESC) as HRESULT
	IsLost as function(byval This as IDirectDrawSurface3 ptr) as HRESULT
	Lock as function(byval This as IDirectDrawSurface3 ptr, byval lpDestRect as LPRECT, byval lpDDSurfaceDesc as LPDDSURFACEDESC, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	ReleaseDC as function(byval This as IDirectDrawSurface3 ptr, byval hDC as HDC) as HRESULT
	Restore as function(byval This as IDirectDrawSurface3 ptr) as HRESULT
	SetClipper as function(byval This as IDirectDrawSurface3 ptr, byval lpDDClipper as LPDIRECTDRAWCLIPPER) as HRESULT
	SetColorKey as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	SetOverlayPosition as function(byval This as IDirectDrawSurface3 ptr, byval lX as LONG, byval lY as LONG) as HRESULT
	SetPalette as function(byval This as IDirectDrawSurface3 ptr, byval lpDDPalette as LPDIRECTDRAWPALETTE) as HRESULT
	Unlock as function(byval This as IDirectDrawSurface3 ptr, byval lpSurfaceData as LPVOID) as HRESULT
	UpdateOverlay as function(byval This as IDirectDrawSurface3 ptr, byval lpSrcRect as LPRECT, byval lpDDDestSurface as LPDIRECTDRAWSURFACE3, byval lpDestRect as LPRECT, byval dwFlags as DWORD, byval lpDDOverlayFx as LPDDOVERLAYFX) as HRESULT
	UpdateOverlayDisplay as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD) as HRESULT
	UpdateOverlayZOrder as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD, byval lpDDSReference as LPDIRECTDRAWSURFACE3) as HRESULT
	GetDDInterface as function(byval This as IDirectDrawSurface3 ptr, byval lplpDD as LPVOID ptr) as HRESULT
	PageLock as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD) as HRESULT
	PageUnlock as function(byval This as IDirectDrawSurface3 ptr, byval dwFlags as DWORD) as HRESULT
	SetSurfaceDesc as function(byval This as IDirectDrawSurface3 ptr, byval lpDDSD as LPDDSURFACEDESC, byval dwFlags as DWORD) as HRESULT
end type

#define IDirectDrawSurface3_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawSurface3_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawSurface3_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawSurface3_AddAttachedSurface(p, a) (p)->lpVtbl->AddAttachedSurface(p, a)
#define IDirectDrawSurface3_AddOverlayDirtyRect(p, a) (p)->lpVtbl->AddOverlayDirtyRect(p, a)
#define IDirectDrawSurface3_Blt(p, a, b, c, d, e) (p)->lpVtbl->Blt(p, a, b, c, d, e)
#define IDirectDrawSurface3_BltBatch(p, a, b, c) (p)->lpVtbl->BltBatch(p, a, b, c)
#define IDirectDrawSurface3_BltFast(p, a, b, c, d, e) (p)->lpVtbl->BltFast(p, a, b, c, d, e)
#define IDirectDrawSurface3_DeleteAttachedSurface(p, a, b) (p)->lpVtbl->DeleteAttachedSurface(p, a, b)
#define IDirectDrawSurface3_EnumAttachedSurfaces(p, a, b) (p)->lpVtbl->EnumAttachedSurfaces(p, a, b)
#define IDirectDrawSurface3_EnumOverlayZOrders(p, a, b, c) (p)->lpVtbl->EnumOverlayZOrders(p, a, b, c)
#define IDirectDrawSurface3_Flip(p, a, b) (p)->lpVtbl->Flip(p, a, b)
#define IDirectDrawSurface3_GetAttachedSurface(p, a, b) (p)->lpVtbl->GetAttachedSurface(p, a, b)
#define IDirectDrawSurface3_GetBltStatus(p, a) (p)->lpVtbl->GetBltStatus(p, a)
#define IDirectDrawSurface3_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawSurface3_GetClipper(p, a) (p)->lpVtbl->GetClipper(p, a)
#define IDirectDrawSurface3_GetColorKey(p, a, b) (p)->lpVtbl->GetColorKey(p, a, b)
#define IDirectDrawSurface3_GetDC(p, a) (p)->lpVtbl->GetDC(p, a)
#define IDirectDrawSurface3_GetFlipStatus(p, a) (p)->lpVtbl->GetFlipStatus(p, a)
#define IDirectDrawSurface3_GetOverlayPosition(p, a, b) (p)->lpVtbl->GetOverlayPosition(p, a, b)
#define IDirectDrawSurface3_GetPalette(p, a) (p)->lpVtbl->GetPalette(p, a)
#define IDirectDrawSurface3_GetPixelFormat(p, a) (p)->lpVtbl->GetPixelFormat(p, a)
#define IDirectDrawSurface3_GetSurfaceDesc(p, a) (p)->lpVtbl->GetSurfaceDesc(p, a)
#define IDirectDrawSurface3_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawSurface3_IsLost(p) (p)->lpVtbl->IsLost(p)
#define IDirectDrawSurface3_Lock(p, a, b, c, d) (p)->lpVtbl->Lock(p, a, b, c, d)
#define IDirectDrawSurface3_ReleaseDC(p, a) (p)->lpVtbl->ReleaseDC(p, a)
#define IDirectDrawSurface3_Restore(p) (p)->lpVtbl->Restore(p)
#define IDirectDrawSurface3_SetClipper(p, a) (p)->lpVtbl->SetClipper(p, a)
#define IDirectDrawSurface3_SetColorKey(p, a, b) (p)->lpVtbl->SetColorKey(p, a, b)
#define IDirectDrawSurface3_SetOverlayPosition(p, a, b) (p)->lpVtbl->SetOverlayPosition(p, a, b)
#define IDirectDrawSurface3_SetPalette(p, a) (p)->lpVtbl->SetPalette(p, a)
#define IDirectDrawSurface3_Unlock(p, a) (p)->lpVtbl->Unlock(p, a)
#define IDirectDrawSurface3_UpdateOverlay(p, a, b, c, d, e) (p)->lpVtbl->UpdateOverlay(p, a, b, c, d, e)
#define IDirectDrawSurface3_UpdateOverlayDisplay(p, a) (p)->lpVtbl->UpdateOverlayDisplay(p, a)
#define IDirectDrawSurface3_UpdateOverlayZOrder(p, a, b) (p)->lpVtbl->UpdateOverlayZOrder(p, a, b)
#define IDirectDrawSurface3_GetDDInterface(p, a) (p)->lpVtbl->GetDDInterface(p, a)
#define IDirectDrawSurface3_PageLock(p, a) (p)->lpVtbl->PageLock(p, a)
#define IDirectDrawSurface3_PageUnlock(p, a) (p)->lpVtbl->PageUnlock(p, a)
#define IDirectDrawSurface3_SetSurfaceDesc(p, a, b) (p)->lpVtbl->SetSurfaceDesc(p, a, b)
type IDirectDrawSurface4Vtbl as IDirectDrawSurface4Vtbl_

type IDirectDrawSurface4
	lpVtbl as IDirectDrawSurface4Vtbl ptr
end type

type IDirectDrawSurface4Vtbl_
	QueryInterface as function(byval This as IDirectDrawSurface4 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawSurface4 ptr) as ULONG
	Release as function(byval This as IDirectDrawSurface4 ptr) as ULONG
	AddAttachedSurface as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE4) as HRESULT
	AddOverlayDirtyRect as function(byval This as IDirectDrawSurface4 ptr, byval lpRect as LPRECT) as HRESULT
	Blt as function(byval This as IDirectDrawSurface4 ptr, byval lpDestRect as LPRECT, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE4, byval lpSrcRect as LPRECT, byval dwFlags as DWORD, byval lpDDBltFx as LPDDBLTFX) as HRESULT
	BltBatch as function(byval This as IDirectDrawSurface4 ptr, byval lpDDBltBatch as LPDDBLTBATCH, byval dwCount as DWORD, byval dwFlags as DWORD) as HRESULT
	BltFast as function(byval This as IDirectDrawSurface4 ptr, byval dwX as DWORD, byval dwY as DWORD, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE4, byval lpSrcRect as LPRECT, byval dwTrans as DWORD) as HRESULT
	DeleteAttachedSurface as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE4) as HRESULT
	EnumAttachedSurfaces as function(byval This as IDirectDrawSurface4 ptr, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK2) as HRESULT
	EnumOverlayZOrders as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD, byval lpContext as LPVOID, byval lpfnCallback as LPDDENUMSURFACESCALLBACK2) as HRESULT
	Flip as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSurfaceTargetOverride as LPDIRECTDRAWSURFACE4, byval dwFlags as DWORD) as HRESULT
	GetAttachedSurface as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSCaps as LPDDSCAPS2, byval lplpDDAttachedSurface as LPDIRECTDRAWSURFACE4 ptr) as HRESULT
	GetBltStatus as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD) as HRESULT
	GetCaps as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSCaps as LPDDSCAPS2) as HRESULT
	GetClipper as function(byval This as IDirectDrawSurface4 ptr, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr) as HRESULT
	GetColorKey as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	GetDC as function(byval This as IDirectDrawSurface4 ptr, byval lphDC as HDC ptr) as HRESULT
	GetFlipStatus as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD) as HRESULT
	GetOverlayPosition as function(byval This as IDirectDrawSurface4 ptr, byval lplX as LPLONG, byval lplY as LPLONG) as HRESULT
	GetPalette as function(byval This as IDirectDrawSurface4 ptr, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr) as HRESULT
	GetPixelFormat as function(byval This as IDirectDrawSurface4 ptr, byval lpDDPixelFormat as LPDDPIXELFORMAT) as HRESULT
	GetSurfaceDesc as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	Initialize as function(byval This as IDirectDrawSurface4 ptr, byval lpDD as LPDIRECTDRAW, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	IsLost as function(byval This as IDirectDrawSurface4 ptr) as HRESULT
	Lock as function(byval This as IDirectDrawSurface4 ptr, byval lpDestRect as LPRECT, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	ReleaseDC as function(byval This as IDirectDrawSurface4 ptr, byval hDC as HDC) as HRESULT
	Restore as function(byval This as IDirectDrawSurface4 ptr) as HRESULT
	SetClipper as function(byval This as IDirectDrawSurface4 ptr, byval lpDDClipper as LPDIRECTDRAWCLIPPER) as HRESULT
	SetColorKey as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	SetOverlayPosition as function(byval This as IDirectDrawSurface4 ptr, byval lX as LONG, byval lY as LONG) as HRESULT
	SetPalette as function(byval This as IDirectDrawSurface4 ptr, byval lpDDPalette as LPDIRECTDRAWPALETTE) as HRESULT
	Unlock as function(byval This as IDirectDrawSurface4 ptr, byval lpSurfaceData as LPRECT) as HRESULT
	UpdateOverlay as function(byval This as IDirectDrawSurface4 ptr, byval lpSrcRect as LPRECT, byval lpDDDestSurface as LPDIRECTDRAWSURFACE4, byval lpDestRect as LPRECT, byval dwFlags as DWORD, byval lpDDOverlayFx as LPDDOVERLAYFX) as HRESULT
	UpdateOverlayDisplay as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD) as HRESULT
	UpdateOverlayZOrder as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD, byval lpDDSReference as LPDIRECTDRAWSURFACE4) as HRESULT
	GetDDInterface as function(byval This as IDirectDrawSurface4 ptr, byval lplpDD as LPVOID ptr) as HRESULT
	PageLock as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD) as HRESULT
	PageUnlock as function(byval This as IDirectDrawSurface4 ptr, byval dwFlags as DWORD) as HRESULT
	SetSurfaceDesc as function(byval This as IDirectDrawSurface4 ptr, byval lpDDSD as LPDDSURFACEDESC2, byval dwFlags as DWORD) as HRESULT
	SetPrivateData as function(byval This as IDirectDrawSurface4 ptr, byval tag as const GUID const ptr, byval pData as LPVOID, byval cbSize as DWORD, byval dwFlags as DWORD) as HRESULT
	GetPrivateData as function(byval This as IDirectDrawSurface4 ptr, byval tag as const GUID const ptr, byval pBuffer as LPVOID, byval pcbBufferSize as LPDWORD) as HRESULT
	FreePrivateData as function(byval This as IDirectDrawSurface4 ptr, byval tag as const GUID const ptr) as HRESULT
	GetUniquenessValue as function(byval This as IDirectDrawSurface4 ptr, byval pValue as LPDWORD) as HRESULT
	ChangeUniquenessValue as function(byval This as IDirectDrawSurface4 ptr) as HRESULT
end type

#define IDirectDrawSurface4_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawSurface4_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawSurface4_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawSurface4_AddAttachedSurface(p, a) (p)->lpVtbl->AddAttachedSurface(p, a)
#define IDirectDrawSurface4_AddOverlayDirtyRect(p, a) (p)->lpVtbl->AddOverlayDirtyRect(p, a)
#define IDirectDrawSurface4_Blt(p, a, b, c, d, e) (p)->lpVtbl->Blt(p, a, b, c, d, e)
#define IDirectDrawSurface4_BltBatch(p, a, b, c) (p)->lpVtbl->BltBatch(p, a, b, c)
#define IDirectDrawSurface4_BltFast(p, a, b, c, d, e) (p)->lpVtbl->BltFast(p, a, b, c, d, e)
#define IDirectDrawSurface4_DeleteAttachedSurface(p, a, b) (p)->lpVtbl->DeleteAttachedSurface(p, a, b)
#define IDirectDrawSurface4_EnumAttachedSurfaces(p, a, b) (p)->lpVtbl->EnumAttachedSurfaces(p, a, b)
#define IDirectDrawSurface4_EnumOverlayZOrders(p, a, b, c) (p)->lpVtbl->EnumOverlayZOrders(p, a, b, c)
#define IDirectDrawSurface4_Flip(p, a, b) (p)->lpVtbl->Flip(p, a, b)
#define IDirectDrawSurface4_GetAttachedSurface(p, a, b) (p)->lpVtbl->GetAttachedSurface(p, a, b)
#define IDirectDrawSurface4_GetBltStatus(p, a) (p)->lpVtbl->GetBltStatus(p, a)
#define IDirectDrawSurface4_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawSurface4_GetClipper(p, a) (p)->lpVtbl->GetClipper(p, a)
#define IDirectDrawSurface4_GetColorKey(p, a, b) (p)->lpVtbl->GetColorKey(p, a, b)
#define IDirectDrawSurface4_GetDC(p, a) (p)->lpVtbl->GetDC(p, a)
#define IDirectDrawSurface4_GetFlipStatus(p, a) (p)->lpVtbl->GetFlipStatus(p, a)
#define IDirectDrawSurface4_GetOverlayPosition(p, a, b) (p)->lpVtbl->GetOverlayPosition(p, a, b)
#define IDirectDrawSurface4_GetPalette(p, a) (p)->lpVtbl->GetPalette(p, a)
#define IDirectDrawSurface4_GetPixelFormat(p, a) (p)->lpVtbl->GetPixelFormat(p, a)
#define IDirectDrawSurface4_GetSurfaceDesc(p, a) (p)->lpVtbl->GetSurfaceDesc(p, a)
#define IDirectDrawSurface4_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawSurface4_IsLost(p) (p)->lpVtbl->IsLost(p)
#define IDirectDrawSurface4_Lock(p, a, b, c, d) (p)->lpVtbl->Lock(p, a, b, c, d)
#define IDirectDrawSurface4_ReleaseDC(p, a) (p)->lpVtbl->ReleaseDC(p, a)
#define IDirectDrawSurface4_Restore(p) (p)->lpVtbl->Restore(p)
#define IDirectDrawSurface4_SetClipper(p, a) (p)->lpVtbl->SetClipper(p, a)
#define IDirectDrawSurface4_SetColorKey(p, a, b) (p)->lpVtbl->SetColorKey(p, a, b)
#define IDirectDrawSurface4_SetOverlayPosition(p, a, b) (p)->lpVtbl->SetOverlayPosition(p, a, b)
#define IDirectDrawSurface4_SetPalette(p, a) (p)->lpVtbl->SetPalette(p, a)
#define IDirectDrawSurface4_Unlock(p, a) (p)->lpVtbl->Unlock(p, a)
#define IDirectDrawSurface4_UpdateOverlay(p, a, b, c, d, e) (p)->lpVtbl->UpdateOverlay(p, a, b, c, d, e)
#define IDirectDrawSurface4_UpdateOverlayDisplay(p, a) (p)->lpVtbl->UpdateOverlayDisplay(p, a)
#define IDirectDrawSurface4_UpdateOverlayZOrder(p, a, b) (p)->lpVtbl->UpdateOverlayZOrder(p, a, b)
#define IDirectDrawSurface4_GetDDInterface(p, a) (p)->lpVtbl->GetDDInterface(p, a)
#define IDirectDrawSurface4_PageLock(p, a) (p)->lpVtbl->PageLock(p, a)
#define IDirectDrawSurface4_PageUnlock(p, a) (p)->lpVtbl->PageUnlock(p, a)
#define IDirectDrawSurface4_SetSurfaceDesc(p, a, b) (p)->lpVtbl->SetSurfaceDesc(p, a, b)
#define IDirectDrawSurface4_SetPrivateData(p, a, b, c, d) (p)->lpVtbl->SetPrivateData(p, a, b, c, d)
#define IDirectDrawSurface4_GetPrivateData(p, a, b, c) (p)->lpVtbl->GetPrivateData(p, a, b, c)
#define IDirectDrawSurface4_FreePrivateData(p, a) (p)->lpVtbl->FreePrivateData(p, a)
#define IDirectDrawSurface4_GetUniquenessValue(p, a) (p)->lpVtbl->GetUniquenessValue(p, a)
#define IDirectDrawSurface4_ChangeUniquenessValue(p) (p)->lpVtbl->ChangeUniquenessValue(p)
type IDirectDrawSurface7Vtbl as IDirectDrawSurface7Vtbl_

type IDirectDrawSurface7_
	lpVtbl as IDirectDrawSurface7Vtbl ptr
end type

type IDirectDrawSurface7Vtbl_
	QueryInterface as function(byval This as IDirectDrawSurface7 ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawSurface7 ptr) as ULONG
	Release as function(byval This as IDirectDrawSurface7 ptr) as ULONG
	AddAttachedSurface as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE7) as HRESULT
	AddOverlayDirtyRect as function(byval This as IDirectDrawSurface7 ptr, byval lpRect as LPRECT) as HRESULT
	Blt as function(byval This as IDirectDrawSurface7 ptr, byval lpDestRect as LPRECT, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE7, byval lpSrcRect as LPRECT, byval dwFlags as DWORD, byval lpDDBltFx as LPDDBLTFX) as HRESULT
	BltBatch as function(byval This as IDirectDrawSurface7 ptr, byval lpDDBltBatch as LPDDBLTBATCH, byval dwCount as DWORD, byval dwFlags as DWORD) as HRESULT
	BltFast as function(byval This as IDirectDrawSurface7 ptr, byval dwX as DWORD, byval dwY as DWORD, byval lpDDSrcSurface as LPDIRECTDRAWSURFACE7, byval lpSrcRect as LPRECT, byval dwTrans as DWORD) as HRESULT
	DeleteAttachedSurface as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD, byval lpDDSAttachedSurface as LPDIRECTDRAWSURFACE7) as HRESULT
	EnumAttachedSurfaces as function(byval This as IDirectDrawSurface7 ptr, byval lpContext as LPVOID, byval lpEnumSurfacesCallback as LPDDENUMSURFACESCALLBACK7) as HRESULT
	EnumOverlayZOrders as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD, byval lpContext as LPVOID, byval lpfnCallback as LPDDENUMSURFACESCALLBACK7) as HRESULT
	Flip as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSurfaceTargetOverride as LPDIRECTDRAWSURFACE7, byval dwFlags as DWORD) as HRESULT
	GetAttachedSurface as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSCaps as LPDDSCAPS2, byval lplpDDAttachedSurface as LPDIRECTDRAWSURFACE7 ptr) as HRESULT
	GetBltStatus as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD) as HRESULT
	GetCaps as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSCaps as LPDDSCAPS2) as HRESULT
	GetClipper as function(byval This as IDirectDrawSurface7 ptr, byval lplpDDClipper as LPDIRECTDRAWCLIPPER ptr) as HRESULT
	GetColorKey as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	GetDC as function(byval This as IDirectDrawSurface7 ptr, byval lphDC as HDC ptr) as HRESULT
	GetFlipStatus as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD) as HRESULT
	GetOverlayPosition as function(byval This as IDirectDrawSurface7 ptr, byval lplX as LPLONG, byval lplY as LPLONG) as HRESULT
	GetPalette as function(byval This as IDirectDrawSurface7 ptr, byval lplpDDPalette as LPDIRECTDRAWPALETTE ptr) as HRESULT
	GetPixelFormat as function(byval This as IDirectDrawSurface7 ptr, byval lpDDPixelFormat as LPDDPIXELFORMAT) as HRESULT
	GetSurfaceDesc as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	Initialize as function(byval This as IDirectDrawSurface7 ptr, byval lpDD as LPDIRECTDRAW, byval lpDDSurfaceDesc as LPDDSURFACEDESC2) as HRESULT
	IsLost as function(byval This as IDirectDrawSurface7 ptr) as HRESULT
	Lock as function(byval This as IDirectDrawSurface7 ptr, byval lpDestRect as LPRECT, byval lpDDSurfaceDesc as LPDDSURFACEDESC2, byval dwFlags as DWORD, byval hEvent as HANDLE) as HRESULT
	ReleaseDC as function(byval This as IDirectDrawSurface7 ptr, byval hDC as HDC) as HRESULT
	Restore as function(byval This as IDirectDrawSurface7 ptr) as HRESULT
	SetClipper as function(byval This as IDirectDrawSurface7 ptr, byval lpDDClipper as LPDIRECTDRAWCLIPPER) as HRESULT
	SetColorKey as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD, byval lpDDColorKey as LPDDCOLORKEY) as HRESULT
	SetOverlayPosition as function(byval This as IDirectDrawSurface7 ptr, byval lX as LONG, byval lY as LONG) as HRESULT
	SetPalette as function(byval This as IDirectDrawSurface7 ptr, byval lpDDPalette as LPDIRECTDRAWPALETTE) as HRESULT
	Unlock as function(byval This as IDirectDrawSurface7 ptr, byval lpSurfaceData as LPRECT) as HRESULT
	UpdateOverlay as function(byval This as IDirectDrawSurface7 ptr, byval lpSrcRect as LPRECT, byval lpDDDestSurface as LPDIRECTDRAWSURFACE7, byval lpDestRect as LPRECT, byval dwFlags as DWORD, byval lpDDOverlayFx as LPDDOVERLAYFX) as HRESULT
	UpdateOverlayDisplay as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD) as HRESULT
	UpdateOverlayZOrder as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD, byval lpDDSReference as LPDIRECTDRAWSURFACE7) as HRESULT
	GetDDInterface as function(byval This as IDirectDrawSurface7 ptr, byval lplpDD as LPVOID ptr) as HRESULT
	PageLock as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD) as HRESULT
	PageUnlock as function(byval This as IDirectDrawSurface7 ptr, byval dwFlags as DWORD) as HRESULT
	SetSurfaceDesc as function(byval This as IDirectDrawSurface7 ptr, byval lpDDSD as LPDDSURFACEDESC2, byval dwFlags as DWORD) as HRESULT
	SetPrivateData as function(byval This as IDirectDrawSurface7 ptr, byval tag as const GUID const ptr, byval pData as LPVOID, byval cbSize as DWORD, byval dwFlags as DWORD) as HRESULT
	GetPrivateData as function(byval This as IDirectDrawSurface7 ptr, byval tag as const GUID const ptr, byval pBuffer as LPVOID, byval pcbBufferSize as LPDWORD) as HRESULT
	FreePrivateData as function(byval This as IDirectDrawSurface7 ptr, byval tag as const GUID const ptr) as HRESULT
	GetUniquenessValue as function(byval This as IDirectDrawSurface7 ptr, byval pValue as LPDWORD) as HRESULT
	ChangeUniquenessValue as function(byval This as IDirectDrawSurface7 ptr) as HRESULT
	SetPriority as function(byval This as IDirectDrawSurface7 ptr, byval prio as DWORD) as HRESULT
	GetPriority as function(byval This as IDirectDrawSurface7 ptr, byval prio as LPDWORD) as HRESULT
	SetLOD as function(byval This as IDirectDrawSurface7 ptr, byval lod as DWORD) as HRESULT
	GetLOD as function(byval This as IDirectDrawSurface7 ptr, byval lod as LPDWORD) as HRESULT
end type

#define IDirectDrawSurface7_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawSurface7_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawSurface7_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawSurface7_AddAttachedSurface(p, a) (p)->lpVtbl->AddAttachedSurface(p, a)
#define IDirectDrawSurface7_AddOverlayDirtyRect(p, a) (p)->lpVtbl->AddOverlayDirtyRect(p, a)
#define IDirectDrawSurface7_Blt(p, a, b, c, d, e) (p)->lpVtbl->Blt(p, a, b, c, d, e)
#define IDirectDrawSurface7_BltBatch(p, a, b, c) (p)->lpVtbl->BltBatch(p, a, b, c)
#define IDirectDrawSurface7_BltFast(p, a, b, c, d, e) (p)->lpVtbl->BltFast(p, a, b, c, d, e)
#define IDirectDrawSurface7_DeleteAttachedSurface(p, a, b) (p)->lpVtbl->DeleteAttachedSurface(p, a, b)
#define IDirectDrawSurface7_EnumAttachedSurfaces(p, a, b) (p)->lpVtbl->EnumAttachedSurfaces(p, a, b)
#define IDirectDrawSurface7_EnumOverlayZOrders(p, a, b, c) (p)->lpVtbl->EnumOverlayZOrders(p, a, b, c)
#define IDirectDrawSurface7_Flip(p, a, b) (p)->lpVtbl->Flip(p, a, b)
#define IDirectDrawSurface7_GetAttachedSurface(p, a, b) (p)->lpVtbl->GetAttachedSurface(p, a, b)
#define IDirectDrawSurface7_GetBltStatus(p, a) (p)->lpVtbl->GetBltStatus(p, a)
#define IDirectDrawSurface7_GetCaps(p, a) (p)->lpVtbl->GetCaps(p, a)
#define IDirectDrawSurface7_GetClipper(p, a) (p)->lpVtbl->GetClipper(p, a)
#define IDirectDrawSurface7_GetColorKey(p, a, b) (p)->lpVtbl->GetColorKey(p, a, b)
#define IDirectDrawSurface7_GetDC(p, a) (p)->lpVtbl->GetDC(p, a)
#define IDirectDrawSurface7_GetFlipStatus(p, a) (p)->lpVtbl->GetFlipStatus(p, a)
#define IDirectDrawSurface7_GetOverlayPosition(p, a, b) (p)->lpVtbl->GetOverlayPosition(p, a, b)
#define IDirectDrawSurface7_GetPalette(p, a) (p)->lpVtbl->GetPalette(p, a)
#define IDirectDrawSurface7_GetPixelFormat(p, a) (p)->lpVtbl->GetPixelFormat(p, a)
#define IDirectDrawSurface7_GetSurfaceDesc(p, a) (p)->lpVtbl->GetSurfaceDesc(p, a)
#define IDirectDrawSurface7_Initialize(p, a, b) (p)->lpVtbl->Initialize(p, a, b)
#define IDirectDrawSurface7_IsLost(p) (p)->lpVtbl->IsLost(p)
#define IDirectDrawSurface7_Lock(p, a, b, c, d) (p)->lpVtbl->Lock(p, a, b, c, d)
#define IDirectDrawSurface7_ReleaseDC(p, a) (p)->lpVtbl->ReleaseDC(p, a)
#define IDirectDrawSurface7_Restore(p) (p)->lpVtbl->Restore(p)
#define IDirectDrawSurface7_SetClipper(p, a) (p)->lpVtbl->SetClipper(p, a)
#define IDirectDrawSurface7_SetColorKey(p, a, b) (p)->lpVtbl->SetColorKey(p, a, b)
#define IDirectDrawSurface7_SetOverlayPosition(p, a, b) (p)->lpVtbl->SetOverlayPosition(p, a, b)
#define IDirectDrawSurface7_SetPalette(p, a) (p)->lpVtbl->SetPalette(p, a)
#define IDirectDrawSurface7_Unlock(p, a) (p)->lpVtbl->Unlock(p, a)
#define IDirectDrawSurface7_UpdateOverlay(p, a, b, c, d, e) (p)->lpVtbl->UpdateOverlay(p, a, b, c, d, e)
#define IDirectDrawSurface7_UpdateOverlayDisplay(p, a) (p)->lpVtbl->UpdateOverlayDisplay(p, a)
#define IDirectDrawSurface7_UpdateOverlayZOrder(p, a, b) (p)->lpVtbl->UpdateOverlayZOrder(p, a, b)
#define IDirectDrawSurface7_GetDDInterface(p, a) (p)->lpVtbl->GetDDInterface(p, a)
#define IDirectDrawSurface7_PageLock(p, a) (p)->lpVtbl->PageLock(p, a)
#define IDirectDrawSurface7_PageUnlock(p, a) (p)->lpVtbl->PageUnlock(p, a)
#define IDirectDrawSurface7_SetSurfaceDesc(p, a, b) (p)->lpVtbl->SetSurfaceDesc(p, a, b)
#define IDirectDrawSurface7_SetPrivateData(p, a, b, c, d) (p)->lpVtbl->SetPrivateData(p, a, b, c, d)
#define IDirectDrawSurface7_GetPrivateData(p, a, b, c) (p)->lpVtbl->GetPrivateData(p, a, b, c)
#define IDirectDrawSurface7_FreePrivateData(p, a) (p)->lpVtbl->FreePrivateData(p, a)
#define IDirectDrawSurface7_GetUniquenessValue(p, a) (p)->lpVtbl->GetUniquenessValue(p, a)
#define IDirectDrawSurface7_ChangeUniquenessValue(p) (p)->lpVtbl->ChangeUniquenessValue(p)
#define IDirectDrawSurface7_SetPriority(p, a) (p)->lpVtbl->SetPriority(p, a)
#define IDirectDrawSurface7_GetPriority(p, a) (p)->lpVtbl->GetPriority(p, a)
#define IDirectDrawSurface7_SetLOD(p, a) (p)->lpVtbl->SetLOD(p, a)
#define IDirectDrawSurface7_GetLOD(p, a) (p)->lpVtbl->GetLOD(p, a)
type IDirectDrawColorControlVtbl as IDirectDrawColorControlVtbl_

type IDirectDrawColorControl
	lpVtbl as IDirectDrawColorControlVtbl ptr
end type

type IDirectDrawColorControlVtbl_
	QueryInterface as function(byval This as IDirectDrawColorControl ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawColorControl ptr) as ULONG
	Release as function(byval This as IDirectDrawColorControl ptr) as ULONG
	GetColorControls as function(byval This as IDirectDrawColorControl ptr, byval lpColorControl as LPDDCOLORCONTROL) as HRESULT
	SetColorControls as function(byval This as IDirectDrawColorControl ptr, byval lpColorControl as LPDDCOLORCONTROL) as HRESULT
end type

#define IDirectDrawColorControl_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawColorControl_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawColorControl_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawColorControl_GetColorControls(p, a) (p)->lpVtbl->GetColorControls(p, a)
#define IDirectDrawColorControl_SetColorControls(p, a) (p)->lpVtbl->SetColorControls(p, a)
type IDirectDrawGammaControlVtbl as IDirectDrawGammaControlVtbl_

type IDirectDrawGammaControl
	lpVtbl as IDirectDrawGammaControlVtbl ptr
end type

type IDirectDrawGammaControlVtbl_
	QueryInterface as function(byval This as IDirectDrawGammaControl ptr, byval riid as const IID const ptr, byval ppvObject as any ptr ptr) as HRESULT
	AddRef as function(byval This as IDirectDrawGammaControl ptr) as ULONG
	Release as function(byval This as IDirectDrawGammaControl ptr) as ULONG
	GetGammaRamp as function(byval This as IDirectDrawGammaControl ptr, byval dwFlags as DWORD, byval lpGammaRamp as LPDDGAMMARAMP) as HRESULT
	SetGammaRamp as function(byval This as IDirectDrawGammaControl ptr, byval dwFlags as DWORD, byval lpGammaRamp as LPDDGAMMARAMP) as HRESULT
end type

#define IDirectDrawGammaControl_QueryInterface(p, a, b) (p)->lpVtbl->QueryInterface(p, a, b)
#define IDirectDrawGammaControl_AddRef(p) (p)->lpVtbl->AddRef(p)
#define IDirectDrawGammaControl_Release(p) (p)->lpVtbl->Release(p)
#define IDirectDrawGammaControl_GetGammaRamp(p, a, b) (p)->lpVtbl->GetGammaRamp(p, a, b)
#define IDirectDrawGammaControl_SetGammaRamp(p, a, b) (p)->lpVtbl->SetGammaRamp(p, a, b)

declare function DirectDrawCreate(byval as GUID ptr, byval as LPDIRECTDRAW ptr, byval as IUnknown ptr) as HRESULT
declare function DirectDrawCreateEx(byval as GUID ptr, byval as LPVOID ptr, byval as const IID const ptr, byval as IUnknown ptr) as HRESULT
declare function DirectDrawCreateClipper(byval as DWORD, byval as LPDIRECTDRAWCLIPPER ptr, byval as IUnknown ptr) as HRESULT

end extern
