import { CancellationToken } from 'vscode-languageserver';
import { Range, InlayHint } from 'vscode-languageserver-types';
import { Document } from '../../../lib/documents';
import { InlayHintProvider } from '../../interfaces';
import { LSAndTSDocResolver } from '../LSAndTSDocResolver';
export declare class InlayHintProviderImpl implements InlayHintProvider {
    private readonly lsAndTsDocResolver;
    constructor(lsAndTsDocResolver: LSAndTSDocResolver);
    getInlayHints(document: Document, range: Range, cancellationToken?: CancellationToken): Promise<InlayHint[] | null>;
    private areInlayHintsEnabled;
    private convertToTargetTextSpan;
    private convertInlayHintLabelParts;
    private getOriginalPosition;
    private convertInlayHintKind;
    private isSvelte2tsxFunctionHints;
    private isGeneratedVariableTypeHint;
    /** `true` if is one of the `async () => {...}` functions svelte2tsx generates */
    private isGeneratedAsyncFunctionReturnType;
    private isGeneratedFunctionReturnType;
    private getTypeAnnotationPosition;
    private checkGeneratedFunctionHintWithSource;
}
