/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ItertoolsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CountBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.CountBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.CountBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.itertools.PCount;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotIterNext;
import com.oracle.graal.python.lib.PyNumberAddNode;
import com.oracle.graal.python.lib.PyNumberCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCount})
public final class CountBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = CountBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CountBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object reducePos(PCount self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached CastToJavaLongExactNode castLongNode, @Cached PyObjectTypeCheck typeCheckNode, @Cached InlinedConditionProfile hasDefaultStep, @Bind PythonLanguage language) {
            ItertoolsModuleBuiltins.warnPickleDeprecated();
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = hasDefaultStep.profile(inliningTarget, !typeCheckNode.execute(inliningTarget, self.getStep(), (Object)PythonBuiltinClassType.PInt) || castLongNode.execute(inliningTarget, self.getStep()) != 1L) ? PFactory.createTuple(language, new Object[]{self.getCnt(), self.getStep()}) : PFactory.createTuple(language, new Object[]{self.getCnt()});
            return PFactory.createTuple(language, new Object[]{type, tuple});
        }
    }

    @Slot(value=Slot.SlotKind.tp_repr, isComplex=true)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString reprPos(VirtualFrame frame, PCount self, @Bind Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttr getAttrNode, @Cached PyObjectReprAsObjectNode reprNode, @Cached CastToTruffleStringNode castStringNode, @Cached CastToJavaLongExactNode castLongNode, @Cached PyObjectTypeCheck typeCheckNode, @Cached InlinedBranchProfile hasDefaultStep, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            TruffleString name = castStringNode.execute(inliningTarget, getAttrNode.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___NAME__));
            TruffleString cntRepr = castStringNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getCnt()));
            if (!typeCheckNode.execute(inliningTarget, self.getStep(), (Object)PythonBuiltinClassType.PInt) || castLongNode.execute(inliningTarget, self.getStep()) != 1L) {
                hasDefaultStep.enter(inliningTarget);
                return simpleTruffleStringFormatNode.format("%s(%s, %s)", name, cntRepr, castStringNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getStep())));
            }
            return simpleTruffleStringFormatNode.format("%s(%s)", name, cntRepr);
        }
    }

    @Slot(value=Slot.SlotKind.tp_iternext, isComplex=true)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends TpSlotIterNext.TpIterNextBuiltin {
        @Specialization
        static Object next(VirtualFrame frame, PCount self, @Cached PyNumberAddNode addNode) {
            Object cnt = self.getCnt();
            self.setCnt(addNode.execute(frame, self.getCnt(), self.getStep()));
            return cnt;
        }
    }

    @Slot(value=Slot.SlotKind.tp_iter, isComplex=true)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PCount self) {
            return self;
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="count", minNumOfPositionalArgs=1, parameterNames={"cls", "start", "step"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="step", defaultValue="1", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CountNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CountBuiltinsClinicProviders.CountNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object construct(Object cls, Object start, Object step, @Bind Node inliningTarget, @Cached PyNumberCheckNode checkNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Bind PythonLanguage language, @Cached TypeNodes.GetInstanceShape getInstanceShape, @Cached PRaiseNode raiseNode) {
            if (!isTypeNode.execute(inliningTarget, cls)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_TYPE_OBJ, "'cls'", cls);
            }
            if (!checkNode.execute(inliningTarget, start)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NUMBER_IS_REQUIRED);
            }
            if (!checkNode.execute(inliningTarget, step)) {
                throw raiseNode.raise(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.NUMBER_IS_REQUIRED);
            }
            PCount self = PFactory.createCount(language, cls, getInstanceShape.execute(cls));
            self.setCnt(start);
            self.setStep(step);
            return self;
        }
    }
}

